/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import io.stargate.db.schema.CollectionIndexingType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableCollectionIndexingType;
import io.stargate.db.schema.ImmutableSecondaryIndex;
import io.stargate.db.schema.Index;
import io.stargate.db.schema.QualifiedSchemaEntity;
import io.stargate.db.schema.SchemaHashable;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
public abstract class SecondaryIndex
implements Index,
QualifiedSchemaEntity {
    private static final long serialVersionUID = 424886903165529554L;

    @Nullable
    public abstract Column column();

    public abstract CollectionIndexingType indexingType();

    @Value.Default
    public boolean isCustom() {
        String indexingClass = this.indexingClass();
        return indexingClass != null && !indexingClass.isEmpty();
    }

    @Nullable
    public abstract String indexingClass();

    @Nullable
    public abstract Map<String, String> indexingOptions();

    public static SecondaryIndex create(String keyspace, String name, Column column) {
        return ImmutableSecondaryIndex.builder().keyspace(keyspace).name(name).column(column).indexingType(ImmutableCollectionIndexingType.builder().build()).build();
    }

    public static SecondaryIndex create(String keyspace, String name, Column column, CollectionIndexingType indexingType, String indexClass, Map<String, String> indexOptions) {
        return ImmutableSecondaryIndex.builder().keyspace(keyspace).name(name).column(column).indexingType(indexingType).indexingClass(indexClass).indexingOptions(indexOptions).build();
    }

    public static SecondaryIndex reference(String name) {
        return ImmutableSecondaryIndex.builder().keyspace("ignored-maybe").name(name).indexingType(ImmutableCollectionIndexingType.builder().build()).build();
    }

    @Override
    public int priority() {
        return 2;
    }

    @Override
    public String indexTypeName() {
        return "Secondary index";
    }

    @Override
    @Value.Derived
    @Value.Auxiliary
    public int schemaHashCode() {
        return SchemaHashable.combine(SchemaHashable.hashCode(this.keyspace()), SchemaHashable.hashCode(this.name()), SchemaHashable.hashCode(this.column()), SchemaHashable.hashCode(this.indexingType()), SchemaHashable.hashCode(this.isCustom()), SchemaHashable.hashCode(this.indexingClass()), SchemaHashable.hashCode(this.indexingOptions()), SchemaHashable.hashCode(this.priority()), SchemaHashable.hashCode(this.indexTypeName()));
    }
}

