/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableTable;
import io.stargate.db.schema.Index;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.SchemaHashable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
public abstract class Table
extends AbstractTable {
    private static final long serialVersionUID = 5913904335622827700L;

    public abstract List<Index> indexes();

    @Value.Lazy
    Map<String, Index> indexMap() {
        return this.indexes().stream().collect(Collectors.toMap(SchemaEntity::name, Function.identity()));
    }

    public Index index(String name) {
        return this.indexMap().get(name);
    }

    public static Table create(String keyspace, String name, Iterable<Column> columns, Iterable<Index> indexes, String comment, int ttl) {
        return ImmutableTable.builder().keyspace(keyspace).name(name).columns(columns).indexes(indexes).comment(comment).ttl(ttl).build();
    }

    public static Table create(String keyspace, String name, Iterable<Column> columns, Iterable<Index> indexes) {
        return ImmutableTable.builder().keyspace(keyspace).name(name).columns(columns).indexes(indexes).build();
    }

    @Override
    @Value.Default
    public String comment() {
        return "";
    }

    @Override
    @Value.Default
    public int ttl() {
        return 0;
    }

    @Override
    public int priority() {
        return 0;
    }

    public String toString() {
        StringBuilder tableBuilder = new StringBuilder();
        String name = this.name();
        tableBuilder.append("Table '").append(name).append("'");
        tableBuilder.append(":\n");
        tableBuilder.append(this.columns().stream().map(c -> "    " + c.name() + " " + c.type() + (c.kind() == Column.Kind.Regular ? "" : " " + (Object)((Object)c.kind()))).collect(Collectors.joining("\n")));
        if (!this.indexes().isEmpty()) {
            tableBuilder.append("\n");
            tableBuilder.append("\n  Table '").append(name).append("' indexes:\n");
            tableBuilder.append(this.indexes().stream().map(idx -> "    " + idx.toString()).collect(Collectors.joining("\n")));
            tableBuilder.append("\n");
        }
        if (!this.comment().isEmpty()) {
            tableBuilder.append("\n  Table '").append(name).append("' comment: " + this.comment());
        }
        tableBuilder.append("\n  Table '").append(name).append("' ttl: " + this.ttl());
        tableBuilder.append("\n");
        return tableBuilder.toString();
    }

    @Override
    public String indexTypeName() {
        return "Table: " + this.name();
    }

    @Override
    @Value.Derived
    @Value.Auxiliary
    public int schemaHashCode() {
        return SchemaHashable.combine(SchemaHashable.hashCode(this.name()), SchemaHashable.hashCode(this.keyspace()), SchemaHashable.hash(this.columns()), SchemaHashable.hash(this.indexes()), SchemaHashable.hashCode(this.comment()), SchemaHashable.hashCode(this.ttl()));
    }
}

