/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import com.datastax.oss.driver.internal.core.type.codec.UdtCodec;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableUserDefinedType;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.SchemaHashable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
public abstract class UserDefinedType
implements Column.ColumnType,
SchemaEntity {
    private static final String ANONYMOUS = "<anonymous>";

    public abstract String keyspace();

    @Override
    public UserDefinedType frozen(boolean frozen) {
        return ImmutableUserDefinedType.copyOf(this).withIsFrozen(frozen);
    }

    public abstract List<Column> columns();

    @Value.Lazy
    public Map<String, Column> columnMap() {
        return this.columns().stream().collect(Collectors.toMap(SchemaEntity::name, Function.identity()));
    }

    @Override
    public int id() {
        return this.rawType().id();
    }

    @Override
    public Column.Type rawType() {
        return Column.Type.UDT;
    }

    @Override
    public Class<?> javaType() {
        return UdtValue.class;
    }

    @Override
    public Object validate(Object value, String location) throws Column.ValidationException {
        this.checkKeyspaceSet();
        if (!(null == value || value instanceof UdtValue && ((UdtValue)value).getType().getName().asInternal().equals(this.name()))) {
            throw new Column.ValidationException(value.getClass(), this, location);
        }
        return value;
    }

    @Override
    public String cqlDefinition() {
        if (this.isFrozen()) {
            return "frozen<" + this.cqlName() + ">";
        }
        return this.cqlName();
    }

    public UdtValue create(Object ... fields) {
        this.checkKeyspaceSet();
        UdtValue udt = this.cqlDataType().newValue();
        Preconditions.checkArgument(fields.length == 0 || fields.length == this.columns().size(), "Expected %s parameter(s) when initializing '%s' but got %s", (Object)this.columns().size(), (Object)this.name(), (Object)fields.length);
        try {
            for (int count = 0; count < fields.length; ++count) {
                Object value = fields[count];
                if (value == null) continue;
                Column.ColumnType type = this.columns().get(count).type();
                Object validated = type.validate(value, this.columns().get(count).name());
                udt = (UdtValue)udt.set(count, validated, type.codec());
            }
        }
        catch (Column.ValidationException e) {
            throw this.validationException(e);
        }
        return udt;
    }

    public IllegalArgumentException validationException(Column.ValidationException e) {
        return new IllegalArgumentException(String.format("Wrong value type provided for user defined type '%s'. Provided type '%s' is not compatible with expected CQL type '%s' at location '%s'.", this.name(), e.providedType(), e.expectedCqlType(), e.location()));
    }

    public static UserDefinedType reference(String name) {
        return ImmutableUserDefinedType.builder().keyspace(ANONYMOUS).name(name).build();
    }

    public static UserDefinedType reference(String ksName, String name) {
        return ImmutableUserDefinedType.builder().keyspace(ksName).name(name).build();
    }

    @Override
    @Value.Lazy
    public TypeCodec codec() {
        this.checkKeyspaceSet();
        return new UdtCodec(this.cqlDataType());
    }

    private com.datastax.oss.driver.api.core.type.UserDefinedType cqlDataType() {
        return new DefaultUserDefinedType(CqlIdentifier.fromInternal(this.keyspace()), CqlIdentifier.fromInternal(this.name()), this.isFrozen(), this.columns().stream().map(c -> CqlIdentifier.fromInternal(c.name())).collect(Collectors.toList()), this.columns().stream().map(c -> c.type().codec().getCqlType()).collect(Collectors.toList()), CUSTOM_ATTACHMENT_POINT);
    }

    public void checkKeyspaceSet() {
        if (ANONYMOUS.equals(this.keyspace())) {
            throw new UnsupportedOperationException("User defined type must be obtained from schema to be used");
        }
    }

    @Override
    public boolean isUserDefined() {
        return true;
    }

    @Override
    public UserDefinedType dereference(Keyspace keyspace) {
        if (!ANONYMOUS.equals(this.keyspace())) {
            return this;
        }
        UserDefinedType userDefinedType = keyspace.userDefinedType(this.name());
        Preconditions.checkArgument(userDefinedType != null, "User defined type '%s' does not exist in keyspace '%s'", (Object)this.name(), (Object)keyspace.name());
        return userDefinedType.frozen(this.isFrozen());
    }

    @Override
    public Column.ColumnType fieldType(String name) {
        Column column = this.columnMap().get(name);
        Preconditions.checkArgument(null != column, "User defined type '%s' does not have field '%s'", (Object)this.cqlName(), (Object)name);
        return column.type();
    }

    @Override
    @Value.Derived
    @Value.Auxiliary
    public int schemaHashCode() {
        return SchemaHashable.combine(SchemaHashable.hashCode(this.isFrozen()), SchemaHashable.hashCode(this.name()), SchemaHashable.hashCode(this.keyspace()), SchemaHashable.hash(this.columns()));
    }
}

