/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stargate.exceptions;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.cassandra.stargate.exceptions.ExceptionCode;

public abstract class PersistenceException
extends RuntimeException {
    private final ExceptionCode code;
    private volatile List<String> warnings;

    protected PersistenceException(ExceptionCode code, String msg) {
        super(msg);
        this.code = code;
    }

    protected PersistenceException(ExceptionCode code, String msg, Throwable cause) {
        super(msg, cause);
        this.code = code;
    }

    public ExceptionCode code() {
        return this.code;
    }

    public PersistenceException setWarnings(List<String> warnings) {
        Preconditions.checkState(this.warnings == null, "Warnings have already been set");
        this.warnings = warnings;
        return this;
    }

    @Nullable
    public List<String> warnings() {
        return this.warnings;
    }
}

