/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stargate.exceptions;

public enum RequestFailureReason {
    UNKNOWN(0),
    READ_TOO_MANY_TOMBSTONES(1),
    TIMEOUT(2),
    INCOMPATIBLE_SCHEMA(3),
    INDEX_NOT_AVAILABLE,
    CDC_SEGMENT_FULL,
    COUNTER_FORWARDING_FAILURE,
    UNKNOWN_TABLE,
    UNKNOWN_KEYSPACE,
    UNKNOWN_COLUMN,
    NODESYNC_NOT_RUNNING,
    UNKNOWN_NODESYNC_USER_VALIDATION,
    CANCELLED_NODESYNC_USER_VALIDATION,
    NODESYNC_TRACING_ALREADY_ENABLED,
    OVERSIZE_READ_REPAIR_MUTATION,
    BUFFER_POOL_EXHAUSTED,
    BACKUP_SERVICE_NOT_RUNNING,
    REMOTE_STORAGE_FAILURE,
    BOOTSTRAPPING,
    FROM_THE_FUTURE;

    public final int code;
    private final boolean hasProtocolSupport;
    private static final RequestFailureReason[] codeToReasonMap;

    private RequestFailureReason(int code) {
        this.code = code;
        this.hasProtocolSupport = true;
    }

    private RequestFailureReason() {
        this.code = 0;
        this.hasProtocolSupport = false;
    }

    public static RequestFailureReason fromCode(int code) {
        if (code < 0) {
            throw new IllegalArgumentException("RequestFailureReason code must be non-negative (got " + code + ')');
        }
        return code < codeToReasonMap.length ? codeToReasonMap[code] : UNKNOWN;
    }

    static {
        RequestFailureReason[] reasons = RequestFailureReason.values();
        int max = -1;
        for (RequestFailureReason r : reasons) {
            max = Math.max(r.code, max);
        }
        RequestFailureReason[] codeMap = new RequestFailureReason[max + 1];
        for (RequestFailureReason reason : reasons) {
            if (!reason.hasProtocolSupport) continue;
            if (codeMap[reason.code] != null) {
                throw new RuntimeException("Two RequestFailureReason-s that map to the same code: " + reason.code);
            }
            codeMap[reason.code] = reason;
        }
        codeToReasonMap = codeMap;
    }
}

