/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stargate.locator;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.net.HostAndPort;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cassandra.stargate.utils.FastByteOperations;

public final class InetAddressAndPort
implements Comparable<InetAddressAndPort>,
Serializable {
    private static final long serialVersionUID = 0L;
    static volatile int defaultPort = 7000;
    public final InetAddress address;
    public final byte[] addressBytes;
    public final int port;

    private InetAddressAndPort(InetAddress address, byte[] addressBytes, int port) {
        Preconditions.checkNotNull(address);
        Preconditions.checkNotNull(addressBytes);
        InetAddressAndPort.validatePortRange(port);
        this.address = address;
        this.port = port;
        this.addressBytes = addressBytes;
    }

    public InetAddressAndPort withPort(int port) {
        return new InetAddressAndPort(this.address, this.addressBytes, port);
    }

    private static void validatePortRange(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port " + port + " is not a valid port number in the range 0-65535");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InetAddressAndPort that = (InetAddressAndPort)o;
        if (this.port != that.port) {
            return false;
        }
        return this.address.equals(that.address);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public int compareTo(InetAddressAndPort o) {
        int retval = FastByteOperations.compareUnsigned(this.addressBytes, 0, this.addressBytes.length, o.addressBytes, 0, o.addressBytes.length);
        if (retval != 0) {
            return retval;
        }
        return Integer.compare(this.port, o.port);
    }

    public String getHostAddress(boolean withPort) {
        if (withPort) {
            return this.toString();
        }
        return this.address.getHostAddress();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withPort) {
        if (withPort) {
            return InetAddressAndPort.toString(this.address, this.port);
        }
        return this.address.toString();
    }

    public static String toString(InetAddress address, int port) {
        return HostAndPort.fromParts(address.getHostAddress(), port).toString();
    }

    public static InetAddressAndPort getByName(String name) throws UnknownHostException {
        return InetAddressAndPort.getByNameOverrideDefaults(name, null);
    }

    public static InetAddressAndPort getByNameOverrideDefaults(String name, Integer port) throws UnknownHostException {
        HostAndPort hap = HostAndPort.fromString(name);
        if (hap.hasPort()) {
            port = hap.getPort();
        }
        return InetAddressAndPort.getByAddressOverrideDefaults(InetAddress.getByName(hap.getHost()), port);
    }

    public static InetAddressAndPort getByAddress(byte[] address) throws UnknownHostException {
        return InetAddressAndPort.getByAddressOverrideDefaults(InetAddress.getByAddress(address), address, null);
    }

    public static InetAddressAndPort getByAddress(InetAddress address) {
        return InetAddressAndPort.getByAddressOverrideDefaults(address, null);
    }

    public static InetAddressAndPort getByAddressOverrideDefaults(InetAddress address, Integer port) {
        if (port == null) {
            port = defaultPort;
        }
        return new InetAddressAndPort(address, address.getAddress(), port);
    }

    public static InetAddressAndPort getByAddressOverrideDefaults(InetAddress address, byte[] addressBytes, Integer port) {
        if (port == null) {
            port = defaultPort;
        }
        return new InetAddressAndPort(address, addressBytes, port);
    }

    public static InetAddressAndPort getLoopbackAddress() {
        return InetAddressAndPort.getByAddress(InetAddress.getLoopbackAddress());
    }

    public static void initializeDefaultPort(int port) {
        defaultPort = port;
    }

    static int getDefaultPort() {
        return defaultPort;
    }
}

