/*
 * Decompiled with CFR 0.152.
 */
package org.javatuples;

import java.util.Collection;
import java.util.Iterator;
import org.javatuples.Tuple;
import org.javatuples.valueintf.IValueKey;
import org.javatuples.valueintf.IValueValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyValue<A, B>
extends Tuple
implements IValueKey<A>,
IValueValue<B> {
    private static final long serialVersionUID = 3460957157833872509L;
    private static final int SIZE = 2;
    private final A key;
    private final B value;

    public static <A, B> KeyValue<A, B> with(A key, B value) {
        return new KeyValue<A, B>(key, value);
    }

    public static <X> KeyValue<X, X> fromArray(X[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null");
        }
        if (array.length != 2) {
            throw new IllegalArgumentException("Array must have exactly 2 elements in order to create a KeyValue. Size is " + array.length);
        }
        return new KeyValue<X, X>(array[0], array[1]);
    }

    public static <X> KeyValue<X, X> fromCollection(Collection<X> collection) {
        return KeyValue.fromIterable(collection);
    }

    public static <X> KeyValue<X, X> fromIterable(Iterable<X> iterable) {
        return KeyValue.fromIterable(iterable, 0, true);
    }

    public static <X> KeyValue<X, X> fromIterable(Iterable<X> iterable, int index) {
        return KeyValue.fromIterable(iterable, index, false);
    }

    private static <X> KeyValue<X, X> fromIterable(Iterable<X> iterable, int index, boolean exactSize) {
        if (iterable == null) {
            throw new IllegalArgumentException("Iterable cannot be null");
        }
        boolean tooFewElements = false;
        Object element0 = null;
        Object element1 = null;
        Iterator<X> iter = iterable.iterator();
        for (int i = 0; i < index; ++i) {
            if (iter.hasNext()) {
                iter.next();
                continue;
            }
            tooFewElements = true;
        }
        if (iter.hasNext()) {
            element0 = iter.next();
        } else {
            tooFewElements = true;
        }
        if (iter.hasNext()) {
            element1 = iter.next();
        } else {
            tooFewElements = true;
        }
        if (tooFewElements && exactSize) {
            throw new IllegalArgumentException("Not enough elements for creating a KeyValue (2 needed)");
        }
        if (iter.hasNext() && exactSize) {
            throw new IllegalArgumentException("Iterable must have exactly 2 available elements in order to create a KeyValue.");
        }
        return new KeyValue<Object, Object>(element0, element1);
    }

    public KeyValue(A key, B value) {
        super(key, value);
        this.key = key;
        this.value = value;
    }

    public A getKey() {
        return this.key;
    }

    public B getValue() {
        return this.value;
    }

    @Override
    public int getSize() {
        return 2;
    }

    public <X> KeyValue<X, B> setKey(X key) {
        return new KeyValue<X, B>(key, this.value);
    }

    public <Y> KeyValue<A, Y> setValue(Y value) {
        return new KeyValue<A, Y>(this.key, value);
    }
}

