/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericRecordBuilder;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;

class AvroRecordBuilderImpl
implements GenericRecordBuilder {
    private final GenericSchemaImpl genericSchema;
    private final org.apache.pulsar.shade.org.apache.avro.generic.GenericRecordBuilder avroRecordBuilder;

    AvroRecordBuilderImpl(GenericSchemaImpl genericSchema) {
        this.genericSchema = genericSchema;
        this.avroRecordBuilder = new org.apache.pulsar.shade.org.apache.avro.generic.GenericRecordBuilder(genericSchema.getAvroSchema());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GenericRecordBuilder set(String fieldName, Object value) {
        if (value instanceof GenericRecord) {
            if (!(value instanceof GenericAvroRecord)) throw new IllegalArgumentException("Avro Record Builder doesn't support non-avro record as a field");
            this.avroRecordBuilder.set(fieldName, (Object)((GenericAvroRecord)value).getAvroRecord());
            return this;
        } else {
            this.avroRecordBuilder.set(fieldName, value);
        }
        return this;
    }

    @Override
    public GenericRecordBuilder set(Field field, Object value) {
        this.set(field.getIndex(), value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected GenericRecordBuilder set(int index, Object value) {
        if (value instanceof GenericRecord) {
            if (!(value instanceof GenericAvroRecord)) throw new IllegalArgumentException("Avro Record Builder doesn't support non-avro record as a field");
            this.avroRecordBuilder.set(this.genericSchema.getAvroSchema().getFields().get(index), (Object)((GenericAvroRecord)value).getAvroRecord());
            return this;
        } else {
            this.avroRecordBuilder.set(this.genericSchema.getAvroSchema().getFields().get(index), value);
        }
        return this;
    }

    @Override
    public GenericRecordBuilder clear(String fieldName) {
        this.avroRecordBuilder.clear(fieldName);
        return this;
    }

    @Override
    public GenericRecordBuilder clear(Field field) {
        return this.clear(field.getIndex());
    }

    protected GenericRecordBuilder clear(int index) {
        this.avroRecordBuilder.clear(this.genericSchema.getAvroSchema().getFields().get(index));
        return this;
    }

    @Override
    public GenericRecord build() {
        return new GenericAvroRecord(null, this.genericSchema.getAvroSchema(), this.genericSchema.getFields(), this.avroRecordBuilder.build());
    }
}

