/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.LinkedHashSet;
import org.apache.pulsar.client.admin.utils.ReflectionUtils;
import org.apache.pulsar.client.api.ProxyProtocol;

public interface ClusterData {
    public String getServiceUrl();

    public String getServiceUrlTls();

    public String getBrokerServiceUrl();

    public String getBrokerServiceUrlTls();

    public String getProxyServiceUrl();

    public ProxyProtocol getProxyProtocol();

    public LinkedHashSet<String> getPeerClusterNames();

    public String getAuthenticationPlugin();

    public String getAuthenticationParameters();

    public boolean isBrokerClientTlsEnabled();

    public boolean isTlsAllowInsecureConnection();

    public boolean isBrokerClientTlsEnabledWithKeyStore();

    public String getBrokerClientTlsTrustStoreType();

    public String getBrokerClientTlsTrustStore();

    public String getBrokerClientTlsTrustStorePassword();

    public String getBrokerClientTrustCertsFilePath();

    public String getListenerName();

    public Builder clone();

    public static Builder builder() {
        return (Builder)ReflectionUtils.newBuilder("org.apache.pulsar.common.policies.data.ClusterDataImpl");
    }

    public static interface Builder {
        public Builder serviceUrl(String var1);

        public Builder serviceUrlTls(String var1);

        public Builder brokerServiceUrl(String var1);

        public Builder brokerServiceUrlTls(String var1);

        public Builder proxyServiceUrl(String var1);

        public Builder proxyProtocol(ProxyProtocol var1);

        public Builder authenticationPlugin(String var1);

        public Builder authenticationParameters(String var1);

        public Builder peerClusterNames(LinkedHashSet<String> var1);

        public Builder brokerClientTlsEnabled(boolean var1);

        public Builder tlsAllowInsecureConnection(boolean var1);

        public Builder brokerClientTlsEnabledWithKeyStore(boolean var1);

        public Builder brokerClientTlsTrustStoreType(String var1);

        public Builder brokerClientTlsTrustStore(String var1);

        public Builder brokerClientTlsTrustStorePassword(String var1);

        public Builder brokerClientTrustCertsFilePath(String var1);

        public Builder listenerName(String var1);

        public ClusterData build();
    }
}

