/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.com.google.common.cache.RemovalListener;
import org.apache.pulsar.shade.com.google.common.cache.RemovalNotification;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ExecutionError;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.pulsar.PulsarConfigUpdater;
import org.apache.spark.sql.pulsar.PulsarConfigUpdater$;
import org.apache.spark.sql.pulsar.PulsarOptions$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class CachedPulsarClient$
implements Logging {
    public static CachedPulsarClient$ MODULE$;
    private long cacheExpireTimeout;
    private LoadingCache<java.util.Map<String, Object>, PulsarClientImpl> guavaCache;
    private final long defaultCacheExpireTimeout;
    private final CacheLoader<java.util.Map<String, Object>, PulsarClientImpl> cacheLoader;
    private final RemovalListener<java.util.Map<String, Object>, PulsarClientImpl> removalListener;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new CachedPulsarClient$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long defaultCacheExpireTimeout() {
        return this.defaultCacheExpireTimeout;
    }

    private long cacheExpireTimeout$lzycompute() {
        CachedPulsarClient$ cachedPulsarClient$ = this;
        synchronized (cachedPulsarClient$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.cacheExpireTimeout = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)CachedPulsarClient$.$anonfun$cacheExpireTimeout$1(x$1))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> MODULE$.defaultCacheExpireTimeout()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.cacheExpireTimeout;
    }

    private long cacheExpireTimeout() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.cacheExpireTimeout$lzycompute() : this.cacheExpireTimeout;
    }

    private CacheLoader<java.util.Map<String, Object>, PulsarClientImpl> cacheLoader() {
        return this.cacheLoader;
    }

    private RemovalListener<java.util.Map<String, Object>, PulsarClientImpl> removalListener() {
        return this.removalListener;
    }

    private LoadingCache<java.util.Map<String, Object>, PulsarClientImpl> guavaCache$lzycompute() {
        CachedPulsarClient$ cachedPulsarClient$ = this;
        synchronized (cachedPulsarClient$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.guavaCache = CacheBuilder.newBuilder().expireAfterAccess(this.cacheExpireTimeout(), TimeUnit.MILLISECONDS).removalListener(this.removalListener()).build(this.cacheLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.cacheLoader = null;
        this.removalListener = null;
        return this.guavaCache;
    }

    private LoadingCache<java.util.Map<String, Object>, PulsarClientImpl> guavaCache() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.guavaCache$lzycompute() : this.guavaCache;
    }

    public PulsarClientImpl getOrCreate(java.util.Map<String, Object> params) {
        PulsarClientImpl pulsarClientImpl;
        try {
            pulsarClientImpl = this.guavaCache().get(params);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ExecutionException ? true : (throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError);
            if (bl && throwable2.getCause() != null) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
        return pulsarClientImpl;
    }

    public void close(java.util.Map<String, Object> params) {
        this.guavaCache().invalidate(params);
    }

    public void clear() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cleaning up PulsarClient cache.");
        this.guavaCache().invalidateAll();
    }

    public static final /* synthetic */ long $anonfun$cacheExpireTimeout$1(SparkEnv x$1) {
        return x$1.conf().getTimeAsMs("spark.pulsar.client.cache.timeout", new StringBuilder(2).append(MODULE$.defaultCacheExpireTimeout()).append("ms").toString());
    }

    private CachedPulsarClient$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.defaultCacheExpireTimeout = TimeUnit.MINUTES.toMillis(10L);
        this.cacheLoader = new CacheLoader<java.util.Map<String, Object>, PulsarClientImpl>(){

            public PulsarClientImpl load(java.util.Map<String, Object> config) {
                PulsarClientImpl pulsarClientImpl;
                String pulsarServiceUrl = config.get(PulsarOptions$.MODULE$.ServiceUrlOptionKey()).toString();
                java.util.Map<String, Object> clientConf = new PulsarConfigUpdater("pulsarClientCache", (Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config).asScala()).toMap(Predef$.MODULE$.$conforms()), PulsarOptions$.MODULE$.FilteredKeys(), PulsarConfigUpdater$.MODULE$.apply$default$4()).rebuild();
                CachedPulsarClient$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Client Conf = ").append(clientConf).toString());
                ClientBuilder builder = PulsarClient.builder();
                try {
                    builder.loadConf(clientConf).serviceUrl(pulsarServiceUrl);
                    Object object = clientConf.containsKey(PulsarOptions$.MODULE$.AuthPluginClassName()) ? builder.authentication(clientConf.get(PulsarOptions$.MODULE$.AuthPluginClassName()).toString(), clientConf.get(PulsarOptions$.MODULE$.AuthParams()).toString()) : BoxedUnit.UNIT;
                    PulsarClient pulsarClient = builder.build();
                    CachedPulsarClient$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Created a new instance of PulsarClient for serviceUrl = ").append(pulsarServiceUrl).append(",").append(" clientConf = ").append(clientConf).append(".").toString());
                    pulsarClientImpl = (PulsarClientImpl)pulsarClient;
                }
                catch (Throwable e) {
                    CachedPulsarClient$.MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Failed to create PulsarClient to serviceUrl ").append(pulsarServiceUrl).append(" using client conf ").append(clientConf).toString(), e);
                    throw e;
                }
                return pulsarClientImpl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$1(java.util.Map ), $anonfun$load$2(java.lang.String java.util.Map ), $anonfun$load$3(java.lang.String java.util.Map )}, serializedLambda);
            }
        };
        this.removalListener = new RemovalListener<java.util.Map<String, Object>, PulsarClientImpl>(){

            public void onRemoval(RemovalNotification<java.util.Map<String, Object>, PulsarClientImpl> notification) {
                java.util.Map params = (java.util.Map)notification.getKey();
                PulsarClient client = (PulsarClient)notification.getValue();
                CachedPulsarClient$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Evicting pulsar producer ").append(client).append(" params: ").append(params).append(", due to ").append((Object)((Object)notification.getCause())).toString());
                try {
                    CachedPulsarClient$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Closing the Pulsar Client with params: ").append(params).append(".").toString());
                    client.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        CachedPulsarClient$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while closing pulsar producer.", e);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onRemoval$1(org.apache.pulsar.client.api.PulsarClient java.util.Map org.apache.pulsar.shade.com.google.common.cache.RemovalNotification ), $anonfun$onRemoval$2(java.util.Map ), $anonfun$onRemoval$3()}, serializedLambda);
            }
        };
    }
}

