/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.pulsar.CachedConsumer$;
import org.apache.spark.sql.pulsar.CachedPulsarClient$;
import org.apache.spark.sql.pulsar.EarliestOffset$;
import org.apache.spark.sql.pulsar.LatestOffset$;
import org.apache.spark.sql.pulsar.PerTopicOffset;
import org.apache.spark.sql.pulsar.PulsarHelper$;
import org.apache.spark.sql.pulsar.PulsarOffset;
import org.apache.spark.sql.pulsar.PulsarOptions$;
import org.apache.spark.sql.pulsar.PulsarProvider$;
import org.apache.spark.sql.pulsar.PulsarSourceUtils$;
import org.apache.spark.sql.pulsar.SchemaUtils$;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset;
import org.apache.spark.sql.pulsar.SpecificPulsarTime;
import org.apache.spark.sql.pulsar.TimeOffset;
import org.apache.spark.sql.pulsar.UserProvidedMessageId;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r%d!\u0002$H\u0001\u001e\u000b\u0006\u0002C8\u0001\u0005+\u0007I\u0011A9\t\u0011u\u0004!\u0011#Q\u0001\nID\u0001B \u0001\u0003\u0016\u0004%\ta \u0005\u000b\u0003\u001b\u0001!\u0011#Q\u0001\n\u0005\u0005\u0001\"CA\b\u0001\tU\r\u0011\"\u0001r\u0011%\t\t\u0002\u0001B\tB\u0003%!\u000f\u0003\u0006\u0002\u0014\u0001\u0011)\u001a!C\u0001\u0003+A!\"a\u0007\u0001\u0005#\u0005\u000b\u0011BA\f\u0011)\ti\u0002\u0001BK\u0002\u0013\u0005\u0011q\u0004\u0005\u000b\u0003O\u0001!\u0011#Q\u0001\n\u0005\u0005\u0002BCA\u0015\u0001\tU\r\u0011\"\u0001\u0002,!Q\u00111\u0007\u0001\u0003\u0012\u0003\u0006I!!\f\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!I\u0011\u0011\n\u0001A\u0002\u0013E\u00111\n\u0005\n\u0003;\u0002\u0001\u0019!C\t\u0003?B\u0001\"a\u001b\u0001A\u0003&\u0011Q\n\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0007C\u0006\u0002\u0004\u0002\u0001\r\u00111A\u0005\n\u0005\u0015\u0005bCAE\u0001\u0001\u0007\t\u0011)Q\u0005\u0003cB1\"a#\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002p!Y\u0011Q\u0012\u0001A\u0002\u0003\u0007I\u0011BAH\u0011-\t\u0019\n\u0001a\u0001\u0002\u0003\u0006K!!\u001d\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003s\u0003A\u0011BA^\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017Dq!a7\u0001\t\u0003\ti\u000eC\u0004\u0002p\u0002!\t!a&\t\u000f\u0005E\b\u0001\"\u0001\u0002t\"9!q\u0001\u0001\u0005\u0002\t%\u0001b\u0002B\u0004\u0001\u0011%!\u0011\u0004\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005KAqA!\u000b\u0001\t\u0003\u0011Y\u0003C\u0004\u00030\u0001!I!a&\t\u000f\tE\u0002\u0001\"\u0003\u0002p!9!q\u0006\u0001\u0005\n\tM\u0002b\u0002B\u001d\u0001\u0011%!1\b\u0005\b\u0005\u0013\u0002A\u0011BAL\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u001bBqAa\u0013\u0001\t\u0003\u0011\t\u0007C\u0004\u0003l\u0001!\tA!\u001c\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\"9!Q\u0011\u0001\u0005\n\t5\u0005b\u0002BJ\u0001\u0011%!Q\u0013\u0005\b\u0005[\u0003A\u0011\u0002BX\u0011%\u0011\u0019\fAA\u0001\n\u0003\u0011)\fC\u0005\u0003D\u0002\t\n\u0011\"\u0001\u0003F\"I!1\u001c\u0001\u0012\u0002\u0013\u0005!Q\u001c\u0005\n\u0005C\u0004\u0011\u0013!C\u0001\u0005\u000bD\u0011Ba9\u0001#\u0003%\tA!:\t\u0013\t%\b!%A\u0005\u0002\t-\b\"\u0003Bx\u0001E\u0005I\u0011\u0001By\u0011%\u0011)\u0010AA\u0001\n\u0003\u00129\u0010C\u0005\u0003~\u0002\t\t\u0011\"\u0001\u0003\u0000\"I1\u0011\u0001\u0001\u0002\u0002\u0013\u000511\u0001\u0005\n\u0007\u001b\u0001\u0011\u0011!C!\u0007\u001fA\u0011b!\b\u0001\u0003\u0003%\taa\b\t\u0013\r\r\u0002!!A\u0005B\r\u0015\u0002\"CB\u0014\u0001\u0005\u0005I\u0011IB\u0015\u0011%\u0019Y\u0003AA\u0001\n\u0003\u001aic\u0002\u0006\u00042\u001d\u000b\t\u0011#\u0001H\u0007g1\u0011BR$\u0002\u0002#\u0005qi!\u000e\t\u000f\u0005U\u0002\t\"\u0001\u0004D!I1q\u0005!\u0002\u0002\u0013\u00153\u0011\u0006\u0005\n\u0007\u000b\u0002\u0015\u0011!CA\u0007\u000fB\u0011b!\u0016A\u0003\u0003%\tia\u0016\t\u0013\r\u0015\u0004)!A\u0005\n\r\u001d$\u0001\u0004)vYN\f'\u000fS3ma\u0016\u0014(B\u0001%J\u0003\u0019\u0001X\u000f\\:be*\u0011!jS\u0001\u0004gFd'B\u0001'N\u0003\u0015\u0019\b/\u0019:l\u0015\tqu*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0006\u0019qN]4\u0014\r\u0001\u0011&\f\u00194m!\t\u0019\u0006,D\u0001U\u0015\t)f+\u0001\u0003mC:<'\"A,\u0002\t)\fg/Y\u0005\u00033R\u0013aa\u00142kK\u000e$\bCA._\u001b\u0005a&BA/W\u0003\tIw.\u0003\u0002`9\nI1\t\\8tK\u0006\u0014G.\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G.\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003K\n\u0014q\u0001T8hO&tw\r\u0005\u0002hU6\t\u0001NC\u0001j\u0003\u0015\u00198-\u00197b\u0013\tY\u0007NA\u0004Qe>$Wo\u0019;\u0011\u0005\u001dl\u0017B\u00018i\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003)\u0019XM\u001d<jG\u0016,&\u000f\\\u0002\u0001+\u0005\u0011\bCA:{\u001d\t!\b\u0010\u0005\u0002vQ6\taO\u0003\u0002xa\u00061AH]8pizJ!!\u001f5\u0002\rA\u0013X\rZ3g\u0013\tYHP\u0001\u0004TiJLgn\u001a\u0006\u0003s\"\f1b]3sm&\u001cW-\u0016:mA\u0005Q1\r\\5f]R\u001cuN\u001c4\u0016\u0005\u0005\u0005\u0001CBA\u0002\u0003\u0013\u0011(+\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001,\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0017\t)AA\u0002NCB\f1b\u00197jK:$8i\u001c8gA\u0005\u0019BM]5wKJ<%o\\;q\u0013\u0012\u0004&/\u001a4jq\u0006!BM]5wKJ<%o\\;q\u0013\u0012\u0004&/\u001a4jq\u0002\n\u0011dY1tK&s7/\u001a8tSRLg/\u001a)be\u0006lW\r^3sgV\u0011\u0011q\u0003\t\u0006g\u0006e!O]\u0005\u0004\u0003\u0017a\u0018AG2bg\u0016Len]3og&$\u0018N^3QCJ\fW.\u001a;feN\u0004\u0013AG1mY><H)\u001b4gKJ,g\u000e\u001e+pa&\u001c7k\u00195f[\u0006\u001cXCAA\u0011!\r9\u00171E\u0005\u0004\u0003KA'a\u0002\"p_2,\u0017M\\\u0001\u001cC2dwn\u001e#jM\u001a,'/\u001a8u)>\u0004\u0018nY*dQ\u0016l\u0017m\u001d\u0011\u0002-A\u0014X\rZ3gS:,GmU;cg\u000e\u0014\u0018\u000e\u001d;j_:,\"!!\f\u0011\t\u001d\fyC]\u0005\u0004\u0003cA'AB(qi&|g.A\fqe\u0016$WMZ5oK\u0012\u001cVOY:de&\u0004H/[8oA\u00051A(\u001b8jiz\"b\"!\u000f\u0002>\u0005}\u0012\u0011IA\"\u0003\u000b\n9\u0005E\u0002\u0002<\u0001i\u0011a\u0012\u0005\u0006_6\u0001\rA\u001d\u0005\u0007}6\u0001\r!!\u0001\t\r\u0005=Q\u00021\u0001s\u0011\u001d\t\u0019\"\u0004a\u0001\u0003/Aq!!\b\u000e\u0001\u0004\t\t\u0003C\u0004\u0002*5\u0001\r!!\f\u0002\r\rd\u0017.\u001a8u+\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\t%l\u0007\u000f\u001c\u0006\u0005\u0003\u0013\n9F\u0003\u0002I\u001b&!\u00111LA)\u0005A\u0001V\u000f\\:be\u000ec\u0017.\u001a8u\u00136\u0004H.\u0001\u0006dY&,g\u000e^0%KF$B!!\u0019\u0002hA\u0019q-a\u0019\n\u0007\u0005\u0015\u0004N\u0001\u0003V]&$\b\"CA5\u001f\u0005\u0005\t\u0019AA'\u0003\rAH%M\u0001\bG2LWM\u001c;!\u0003\u0019!x\u000e]5dgV\u0011\u0011\u0011\u000f\t\u0006\u0003g\niH\u001d\b\u0005\u0003k\nIHD\u0002v\u0003oJ\u0011![\u0005\u0004\u0003wB\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\n\tIA\u0002TKFT1!a\u001fi\u0003)!x\u000e]5dg~#S-\u001d\u000b\u0005\u0003C\n9\tC\u0005\u0002jI\t\t\u00111\u0001\u0002r\u00059Ao\u001c9jGN\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0002'Q|\u0007/[2QCJ$\u0018\u000e^5p]N|F%Z9\u0015\t\u0005\u0005\u0014\u0011\u0013\u0005\n\u0003S*\u0012\u0011!a\u0001\u0003c\n\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u000b\rdwn]3\u0015\u0005\u0005\u0005\u0014aC:fiV\u00048)\u001e:t_J$B!!\u0019\u0002\u001e\"9\u0011q\u0014\rA\u0002\u0005\u0005\u0016aC:uCJ$\u0018N\\4Q_N\u0004B!a\u000f\u0002$&\u0019\u0011QU$\u0003\u001dA+'\u000fV8qS\u000e|eMZ:fi\u0006\u00012/\u001a;va\u000e+(o]8s\u0005fl\u0015\u000e\u001a\u000b\u0007\u0003C\nY+!.\t\u000f\u00055\u0016\u00041\u0001\u00020\u00061qN\u001a4tKR\u0004B!a\u000f\u00022&\u0019\u00111W$\u0003)M\u0003XmY5gS\u000e\u0004V\u000f\\:be>3gm]3u\u0011\u001d\t9,\u0007a\u0001\u0003[\tAb];cg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0011c]3ukB\u001cUO]:pe\nKH+[7f)\u0019\t\t'!0\u0002H\"9\u0011q\u0018\u000eA\u0002\u0005\u0005\u0017\u0001\u0002;j[\u0016\u0004B!a\u000f\u0002D&\u0019\u0011QY$\u0003%M\u0003XmY5gS\u000e\u0004V\u000f\\:beRKW.\u001a\u0005\b\u0003oS\u0002\u0019AA\u0017\u0003M)\u0007\u0010\u001e:bGR\u001cVOY:de&\u0004H/[8o)\u0019\ti-a5\u0002XB1q-a4s\u0003CI1!!5i\u0005\u0019!V\u000f\u001d7fe!9\u0011Q[\u000eA\u0002\u00055\u0012\u0001E:vEN\u001c'/\u001b9uS>tg*Y7f\u0011\u0019\tIn\u0007a\u0001e\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001F2p[6LGoQ;sg>\u0014Hk\\(gMN,G\u000f\u0006\u0003\u0002b\u0005}\u0007bBAW9\u0001\u0007\u0011\u0011\u001d\t\u0007g\u0006e!/a9\u0011\t\u0005\u0015\u00181^\u0007\u0003\u0003OTA!!;\u0002V\u0005\u0019\u0011\r]5\n\t\u00055\u0018q\u001d\u0002\n\u001b\u0016\u001c8/Y4f\u0013\u0012\fAB]3n_Z,7)\u001e:t_J\fQcZ3u\u0003:$7\t[3dW\u000e{W\u000e]1uS\ndW\r\u0006\u0003\u0002v\n\u0005\u0001\u0003BA|\u0003{l!!!?\u000b\u0007\u0005m\u0018*A\u0003usB,7/\u0003\u0003\u0002\u0000\u0006e(AC*ueV\u001cG\u000fV=qK\"9!1\u0001\u0010A\u0002\t\u0015\u0011AB:dQ\u0016l\u0017\rE\u0003h\u0003_\t)0A\bhKR\u0004V\u000f\\:beN\u001b\u0007.Z7b)\t\u0011Y\u0001\u0005\u0003\u0003\u000e\tUQB\u0001B\b\u0015\u0011\u0011\u0019A!\u0005\u000b\t\tM\u0011qK\u0001\u0007G>lWn\u001c8\n\t\t]!q\u0002\u0002\u000b'\u000eDW-\\1J]\u001a|G\u0003\u0002B\u0006\u00057AaA!\b!\u0001\u0004\u0011\u0018!\u0002;pa&\u001c\u0017A\u00054fi\u000eDG*\u0019;fgR|eMZ:fiN$\"!a,\u00023\u0019,Go\u00195MCR,7\u000f^(gMN,GOR8s)>\u0004\u0018n\u0019\u000b\u0005\u0003G\u00149\u0003\u0003\u0004\u0003\u001e\t\u0002\rA]\u0001\u0015M\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r^:\u0015\t\u0005\u0005(Q\u0006\u0005\b\u0003[\u001a\u0003\u0019AA9\u0003%9W\r\u001e+pa&\u001c7/\u0001\nhKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cH\u0003BA9\u0005kAaAa\u000e'\u0001\u0004\u0011\u0018!\u0004;pa&\u001c7\u000fU1ui\u0016\u0014h.A\nu_BL7m\u001d)biR,'O\u001c$jYR,'\u000f\u0006\u0004\u0002r\tu\"q\t\u0005\b\u0005\u007f9\u0003\u0019\u0001B!\u0003%\tG\u000e\u001c+pa&\u001c7\u000fE\u0003\u0002\u0004\t\r#/\u0003\u0003\u0003F\u0005\u0015!\u0001\u0002'jgRDaAa\u000e(\u0001\u0004\u0011\u0018\u0001F<bSR4uN\u001d+pa&\u001c\u0017J\u001a(fK\u0012,G-\u0001\npM\u001a\u001cX\r\u001e$pe\u0016\u000b7\r\u001b+pa&\u001cG\u0003CAQ\u0005\u001f\u0012\u0019F!\u0018\t\u000f\tE\u0013\u00061\u0001\u0002\u0018\u00051\u0001/\u0019:b[NDqA!\u0016*\u0001\u0004\u00119&\u0001\beK\u001a\fW\u000f\u001c;PM\u001a\u001cX\r^:\u0011\t\u0005m\"\u0011L\u0005\u0004\u00057:%\u0001\u0004)vYN\f'o\u00144gg\u0016$\bB\u0002B0S\u0001\u0007!/A\u0005paRLwN\\&fsRA\u0011q\u0016B2\u0005K\u0012I\u0007C\u0004\u0003R)\u0002\r!a\u0006\t\r\t\u001d$\u00061\u0001s\u0003=ygMZ:fi>\u0003H/[8o\u0017\u0016L\bb\u0002B+U\u0001\u0007!qK\u0001\u000eC\u000e$X/\u00197PM\u001a\u001cX\r^:\u0015\u0011\u0005\u0005(q\u000eB9\u0005wBq!!,,\u0001\u0004\t\t\u000bC\u0004\u0003t-\u0002\rA!\u001e\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t!\r9'qO\u0005\u0004\u0005sB'aA%oi\"9!QP\u0016A\u0002\t}\u0014A\u0004:fa>\u0014H\u000fR1uC2{7o\u001d\t\u0007O\n\u0005%/!\u0019\n\u0007\t\r\u0005NA\u0005Gk:\u001cG/[8oc\u0005\u0019b-\u001a;dQ\u000e+(O]3oi>3gm]3ugR1\u0011\u0011\u001dBE\u0005\u0017Cq!!,-\u0001\u0004\ty\u000bC\u0004\u0003~1\u0002\rAa \u0015\r\u0005\u0005(q\u0012BI\u0011\u001d\ty,\fa\u0001\u0003\u0003DqA! .\u0001\u0004\u0011y(\u0001\rhKR,6/\u001a:Qe>4\u0018\u000eZ3e\u001b\u0016\u001c8/Y4f\u0013\u0012$\u0002Ba&\u0003\u001e\n}%\u0011\u0016\t\u0005\u0003\u001f\u0012I*\u0003\u0003\u0003\u001c\u0006E#!D'fgN\fw-Z%e\u00136\u0004H\u000e\u0003\u0004\u0003\u001e9\u0002\rA\u001d\u0005\b\u0003\u007fs\u0003\u0019\u0001BQ!\u00159\u0017q\u0006BR!\r9'QU\u0005\u0004\u0005OC'\u0001\u0002'p]\u001eDq!!,/\u0001\u0004\u0011Y\u000bE\u0003h\u0003_\t\u0019/\u0001\thKRd\u0015m\u001d;NKN\u001c\u0018mZ3JIR!\u00111\u001dBY\u0011\u0019\u0011ib\fa\u0001e\u0006!1m\u001c9z)9\tIDa.\u0003:\nm&Q\u0018B`\u0005\u0003Dqa\u001c\u0019\u0011\u0002\u0003\u0007!\u000f\u0003\u0005\u007faA\u0005\t\u0019AA\u0001\u0011!\ty\u0001\rI\u0001\u0002\u0004\u0011\b\"CA\naA\u0005\t\u0019AA\f\u0011%\ti\u0002\rI\u0001\u0002\u0004\t\t\u0003C\u0005\u0002*A\u0002\n\u00111\u0001\u0002.\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BdU\r\u0011(\u0011Z\u0016\u0003\u0005\u0017\u0004BA!4\u0003X6\u0011!q\u001a\u0006\u0005\u0005#\u0014\u0019.A\u0005v]\u000eDWmY6fI*\u0019!Q\u001b5\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003Z\n='!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BpU\u0011\t\tA!3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001BtU\u0011\t9B!3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u001e\u0016\u0005\u0003C\u0011I-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tM(\u0006BA\u0017\u0005\u0013\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B}!\r\u0019&1`\u0005\u0003wR\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u001e\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!1QAB\u0006!\r97qA\u0005\u0004\u0007\u0013A'aA!os\"I\u0011\u0011N\u001d\u0002\u0002\u0003\u0007!QO\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111\u0011\u0003\t\u0007\u0007'\u0019Ib!\u0002\u000e\u0005\rU!bAB\fQ\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\rm1Q\u0003\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\"\r\u0005\u0002\"CA5w\u0005\u0005\t\u0019AB\u0003\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B;\u0003!!xn\u0015;sS:<GC\u0001B}\u0003\u0019)\u0017/^1mgR!\u0011\u0011EB\u0018\u0011%\tIGPA\u0001\u0002\u0004\u0019)!\u0001\u0007Qk2\u001c\u0018M\u001d%fYB,'\u000fE\u0002\u0002<\u0001\u001bB\u0001QB\u001cYB\u00012\u0011HB e\u0006\u0005!/a\u0006\u0002\"\u00055\u0012\u0011H\u0007\u0003\u0007wQ1a!\u0010i\u0003\u001d\u0011XO\u001c;j[\u0016LAa!\u0011\u0004<\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001c\u0015\u0005\rM\u0012!B1qa2LHCDA\u001d\u0007\u0013\u001aYe!\u0014\u0004P\rE31\u000b\u0005\u0006_\u000e\u0003\rA\u001d\u0005\u0007}\u000e\u0003\r!!\u0001\t\r\u0005=1\t1\u0001s\u0011\u001d\t\u0019b\u0011a\u0001\u0003/Aq!!\bD\u0001\u0004\t\t\u0003C\u0004\u0002*\r\u0003\r!!\f\u0002\u000fUt\u0017\r\u001d9msR!1\u0011LB1!\u00159\u0017qFB.!597Q\f:\u0002\u0002I\f9\"!\t\u0002.%\u00191q\f5\u0003\rQ+\b\u000f\\37\u0011%\u0019\u0019\u0007RA\u0001\u0002\u0004\tI$A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\t!\u000b")
public class PulsarHelper
implements Closeable,
Logging,
Product,
scala.Serializable {
    private final String serviceUrl;
    private final Map<String, Object> clientConf;
    private final String driverGroupIdPrefix;
    private final scala.collection.immutable.Map<String, String> caseInsensitiveParameters;
    private final boolean allowDifferentTopicSchemas;
    private final Option<String> predefinedSubscription;
    private PulsarClientImpl client;
    private Seq<String> topics;
    private Seq<String> topicPartitions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Tuple6<String, Map<String, Object>, String, scala.collection.immutable.Map<String, String>, Object, Option<String>>> unapply(PulsarHelper pulsarHelper) {
        return PulsarHelper$.MODULE$.unapply(pulsarHelper);
    }

    public static PulsarHelper apply(String string, Map<String, Object> map, String string2, scala.collection.immutable.Map<String, String> map2, boolean bl, Option<String> option) {
        return PulsarHelper$.MODULE$.apply(string, map, string2, map2, bl, option);
    }

    public static Function1<Tuple6<String, Map<String, Object>, String, scala.collection.immutable.Map<String, String>, Object, Option<String>>, PulsarHelper> tupled() {
        return PulsarHelper$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Map<String, Object>, Function1<String, Function1<scala.collection.immutable.Map<String, String>, Function1<Object, Function1<Option<String>, PulsarHelper>>>>>> curried() {
        return PulsarHelper$.MODULE$.curried();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String serviceUrl() {
        return this.serviceUrl;
    }

    public Map<String, Object> clientConf() {
        return this.clientConf;
    }

    public String driverGroupIdPrefix() {
        return this.driverGroupIdPrefix;
    }

    public scala.collection.immutable.Map<String, String> caseInsensitiveParameters() {
        return this.caseInsensitiveParameters;
    }

    public boolean allowDifferentTopicSchemas() {
        return this.allowDifferentTopicSchemas;
    }

    public Option<String> predefinedSubscription() {
        return this.predefinedSubscription;
    }

    public PulsarClientImpl client() {
        return this.client;
    }

    public void client_$eq(PulsarClientImpl x$1) {
        this.client = x$1;
    }

    private Seq<String> topics() {
        return this.topics;
    }

    private void topics_$eq(Seq<String> x$1) {
        this.topics = x$1;
    }

    private Seq<String> topicPartitions() {
        return this.topicPartitions;
    }

    private void topicPartitions_$eq(Seq<String> x$1) {
        this.topicPartitions = x$1;
    }

    @Override
    public void close() {
    }

    public void setupCursor(PerTopicOffset startingPos) {
        PerTopicOffset perTopicOffset = startingPos;
        if (perTopicOffset instanceof SpecificPulsarOffset) {
            SpecificPulsarOffset specificPulsarOffset = (SpecificPulsarOffset)perTopicOffset;
            this.setupCursorByMid(specificPulsarOffset, this.predefinedSubscription());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (perTopicOffset instanceof SpecificPulsarTime) {
            SpecificPulsarTime specificPulsarTime = (SpecificPulsarTime)perTopicOffset;
            this.setupCursorByTime(specificPulsarTime, this.predefinedSubscription());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(37).append(perTopicOffset).append(" shouldn't appear here, a bug occurs.").toString());
        }
    }

    private void setupCursorByMid(SpecificPulsarOffset offset, Option<String> subscription) {
        offset.topicOffsets().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PulsarHelper.$anonfun$setupCursorByMid$1(this, subscription, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void setupCursorByTime(SpecificPulsarTime time, Option<String> subscription) {
        time.topicTimes().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PulsarHelper.$anonfun$setupCursorByTime$1(this, subscription, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<String, Object> extractSubscription(Option<String> subscriptionName, String topicPartition) {
        Tuple2 tuple2;
        Option<String> option = subscriptionName;
        if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2((Object)new StringBuilder(1).append(this.driverGroupIdPrefix()).append("-").append(topicPartition).toString(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String subName = (String)some.value();
            tuple2 = new Tuple2((Object)subName, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    public void commitCursorToOffset(scala.collection.immutable.Map<String, MessageId> offset) {
        offset.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PulsarHelper.$anonfun$commitCursorToOffset$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeCursor() {
        this.getTopics();
        this.topics().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            PulsarHelper.$anonfun$removeCursor$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     */
    public StructType getAndCheckCompatible(Option<StructType> schema) {
        si = this.getPulsarSchema();
        inferredSchema = SchemaUtils$.MODULE$.pulsarSourceSchema(si);
        if (schema.isEmpty()) ** GOTO lbl-1000
        v0 = inferredSchema;
        var4_4 = schema.get();
        if (!(v0 != null ? v0.equals(var4_4) == false : var4_4 != null)) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        Predef$.MODULE$.require(v1, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getAndCheckCompatible$1(), ()Ljava/lang/String;)());
        return var3_3;
    }

    public SchemaInfo getPulsarSchema() {
        SchemaInfo schemaInfo;
        this.getTopics();
        boolean bl = this.allowDifferentTopicSchemas();
        if (!bl) {
            SchemaInfo schemaInfo2;
            if (this.topics().size() > 0) {
                Seq schemas = (Seq)this.topics().map((Function1 & Serializable & scala.Serializable)tp -> this.getPulsarSchema((String)tp), Seq$.MODULE$.canBuildFrom());
                Set sset = schemas.toSet();
                if (sset.size() != 1) {
                    throw new IllegalArgumentException(new StringBuilder(145).append("Topics to read must share identical schema. Consider setting ").append("'").append(PulsarOptions$.MODULE$.AllowDifferentTopicSchemas()).append("' to 'false' to read topics with empty ").append("schemas instead. We got ").append(sset.size()).append(" distinct ").append("schemas:[").append(sset.mkString(", ")).append("]").toString());
                }
                schemaInfo2 = (SchemaInfo)sset.head();
            } else {
                schemaInfo2 = SchemaUtils$.MODULE$.emptySchemaInfo();
            }
            schemaInfo = schemaInfo2;
        } else if (bl) {
            schemaInfo = SchemaUtils$.MODULE$.emptySchemaInfo();
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return schemaInfo;
    }

    private SchemaInfo getPulsarSchema(String topic) {
        SchemaInfo schemaInfo;
        try {
            schemaInfo = this.client().getSchema(topic).get().get();
        }
        catch (NoSuchElementException e) {
            schemaInfo = BytesSchema.of().getSchemaInfo();
        }
        catch (Throwable e) {
            throw new RuntimeException(new StringBuilder(37).append("Failed to get schema information for ").append(TopicName.get(topic).toString()).toString(), e);
        }
        return schemaInfo;
    }

    public SpecificPulsarOffset fetchLatestOffsets() {
        this.getTopicPartitions();
        return new SpecificPulsarOffset((scala.collection.immutable.Map<String, MessageId>)((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)this.fetchLatestOffsetForTopic((String)tp)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public MessageId fetchLatestOffsetForTopic(String topic) {
        MessageId messageId;
        try {
            messageId = this.getLastMessageId(topic);
        }
        catch (Throwable e) {
            throw new RuntimeException(new StringBuilder(33).append("Failed to get last messageId for ").append(TopicName.get(topic).toString()).toString(), e);
        }
        MessageId messageId2 = messageId;
        return PulsarSourceUtils$.MODULE$.seekableLatestMid(messageId2);
    }

    public scala.collection.immutable.Map<String, MessageId> fetchEarliestOffsets(Seq<String> topics) {
        return topics.isEmpty() ? Predef$.MODULE$.Map().empty() : ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)MessageId.earliest), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * Unable to fully structure code
     */
    private void getTopics() {
        block4: {
            block5: {
                block3: {
                    optionalTopics = this.caseInsensitiveParameters().find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getTopics$1$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)());
                    var3_2 = false;
                    var4_3 = null;
                    var5_4 = optionalTopics;
                    if (!(var5_4 instanceof Some)) break block3;
                    var3_2 = true;
                    var4_3 = (Some)var5_4;
                    var6_5 = (Tuple2)var4_3.value();
                    if (var6_5 == null) break block3;
                    var7_6 = (String)var6_5._1();
                    value = (String)var6_5._2();
                    v0 = PulsarOptions$.MODULE$.TopicSingle();
                    var9_8 = var7_6;
                    if (v0 != null ? v0.equals(var9_8) == false : var9_8 != null) break block3;
                    var10_9 = TopicName.get(value).toString();
                    var1_10 = Nil$.MODULE$.$colon$colon((Object)var10_9);
                    break block4;
                }
                if (!var3_2 || (var11_11 = (Tuple2)var4_3.value()) == null) break block5;
                var12_12 = (String)var11_11._1();
                value = (String)var11_11._2();
                v1 = PulsarOptions$.MODULE$.TopicMulti();
                var14_14 = var12_12;
                if (v1 != null ? v1.equals(var14_14) == false : var14_14 != null) break block5;
                var1_10 = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.split(","))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getTopics$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getTopics$3$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getTopics$4(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                break block4;
            }
            if (!var3_2 || (var15_15 = (Tuple2)var4_3.value()) == null) ** GOTO lbl-1000
            var16_16 = (String)var15_15._1();
            value = (String)var15_15._2();
            v2 = PulsarOptions$.MODULE$.TopicPattern();
            var18_18 = var16_16;
            if (!(v2 != null ? v2.equals(var18_18) == false : var18_18 != null)) {
                var1_10 = this.getTopics(value);
            } else lbl-1000:
            // 2 sources

            {
                if (None$.MODULE$.equals(var5_4)) {
                    throw new RuntimeException("Failed to get topics from configurations");
                }
                throw new MatchError((Object)var5_4);
            }
        }
        this.topics_$eq((Seq<String>)var1_10);
        this.waitForTopicIfNeeded();
    }

    private Seq<String> getTopicPartitions() {
        this.getTopics();
        this.topicPartitions_$eq((Seq<String>)((Seq)this.topics().flatMap((Function1 & Serializable & scala.Serializable)tp -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.client().getPartitionsForTopic((String)tp).get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString(), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())));
        return this.topicPartitions();
    }

    private Seq<String> getTopics(String topicsPattern) {
        TopicName dest = TopicName.get(topicsPattern);
        List<String> allTopics = this.client().getLookup().getTopicsUnderNamespace(dest.getNamespaceObject(), CommandGetTopicsOfNamespace.Mode.ALL).get();
        List allNonPartitionedTopics = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(allTopics).asScala()).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)PulsarHelper.$anonfun$getTopics$5(t)))).asJava();
        Seq<String> nonPartitionedMatch = this.topicsPatternFilter(allNonPartitionedTopics, dest.toString());
        List allPartitionedTopics = (List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(allTopics).asScala()).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)PulsarHelper.$anonfun$getTopics$6(t)))).map((Function1 & Serializable & scala.Serializable)x$7 -> TopicName.get(x$7).getPartitionedTopicName(), Buffer$.MODULE$.canBuildFrom())).toSet().toSeq()).asJava();
        Seq<String> partitionedMatch = this.topicsPatternFilter(allPartitionedTopics, dest.toString());
        return (Seq)nonPartitionedMatch.$plus$plus(partitionedMatch, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> topicsPatternFilter(List<String> allTopics, String topicsPattern) {
        Pattern shortenedTopicsPattern = Pattern.compile(topicsPattern.split("\\:\\/\\/")[1]);
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(allTopics).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> TopicName.get(x$8).toString(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)PulsarHelper.$anonfun$topicsPatternFilter$2(shortenedTopicsPattern, tp)));
    }

    private void waitForTopicIfNeeded() {
        if (new StringOps(Predef$.MODULE$.augmentString((String)this.caseInsensitiveParameters().getOrElse((Object)PulsarOptions$.MODULE$.WaitingForNonExistedTopic(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean()) {
            ListBuffer waitList = (ListBuffer)ListBuffer$.MODULE$.apply(this.topics());
            while (waitList.nonEmpty()) {
                ListBuffer listBuffer;
                String topic = (String)waitList.head();
                try {
                    this.client().getPartitionedTopicMetadata(topic).get();
                    listBuffer = waitList.$minus$eq((Object)topic);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("The desired ").append(topic).append(" doesn't existed, wait for 5 seconds.").toString());
                    Uninterruptibles.sleepUninterruptibly(5L, TimeUnit.SECONDS);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    listBuffer = boxedUnit;
                }
            }
        }
    }

    public PerTopicOffset offsetForEachTopic(scala.collection.immutable.Map<String, String> params, PulsarOffset defaultOffsets, String optionKey) {
        Offset offset;
        PulsarOffset offset2;
        this.getTopicPartitions();
        PulsarOffset pulsarOffset = offset2 = PulsarProvider$.MODULE$.getPulsarOffset(params, defaultOffsets, optionKey);
        if (LatestOffset$.MODULE$.equals(pulsarOffset)) {
            offset = new SpecificPulsarOffset((scala.collection.immutable.Map<String, MessageId>)((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp, (Object)new UserProvidedMessageId(MessageId.latest)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        } else if (EarliestOffset$.MODULE$.equals(pulsarOffset)) {
            offset = new SpecificPulsarOffset((scala.collection.immutable.Map<String, MessageId>)((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp, (Object)new UserProvidedMessageId(MessageId.earliest)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        } else if (pulsarOffset instanceof SpecificPulsarOffset) {
            SpecificPulsarOffset specificPulsarOffset = (SpecificPulsarOffset)pulsarOffset;
            scala.collection.immutable.Map specified = (scala.collection.immutable.Map)specificPulsarOffset.topicOffsets().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String tp = (String)tuple2._1();
                MessageId mid = (MessageId)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)tp, (Object)new UserProvidedMessageId(mid));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            Predef$.MODULE$.assert(specified.keySet().subsetOf((GenSet)this.topicPartitions().toSet()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("topics designated in startingOffsets/endingOffsets").append(" should all appear in ").append(PulsarOptions$.MODULE$.TopicOptionKeys()).append(" .\n").append("topics: ").append(this.topicPartitions()).append(", topics in offsets: ").append(specified.keySet()).toString());
            Set nonSpecifiedTopics = (Set)this.topicPartitions().toSet().$minus$minus((GenTraversableOnce)specified.keySet());
            scala.collection.immutable.Map nonSpecified = ((TraversableOnce)nonSpecifiedTopics.map((Function1 & Serializable & scala.Serializable)tp -> {
                Tuple2 tuple2;
                PulsarOffset pulsarOffset = defaultOffsets;
                if (LatestOffset$.MODULE$.equals(pulsarOffset)) {
                    tuple2 = new Tuple2(tp, (Object)new UserProvidedMessageId(MessageId.latest));
                } else if (EarliestOffset$.MODULE$.equals(pulsarOffset)) {
                    tuple2 = new Tuple2(tp, (Object)new UserProvidedMessageId(MessageId.earliest));
                } else {
                    throw new IllegalArgumentException("Defaults should be latest or earliest");
                }
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            offset = new SpecificPulsarOffset((scala.collection.immutable.Map<String, MessageId>)specified.$plus$plus((GenTraversableOnce)nonSpecified));
        } else if (pulsarOffset instanceof TimeOffset) {
            TimeOffset timeOffset = (TimeOffset)pulsarOffset;
            long ts = timeOffset.ts();
            offset = new SpecificPulsarTime((scala.collection.immutable.Map<String, Object>)((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp, (Object)BoxesRunTime.boxToLong((long)ts)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        } else if (pulsarOffset instanceof SpecificPulsarTime) {
            SpecificPulsarTime specificPulsarTime = (SpecificPulsarTime)pulsarOffset;
            scala.collection.immutable.Map<String, Object> specified = specificPulsarTime.topicTimes();
            Predef$.MODULE$.assert(specified.keySet().subsetOf((GenSet)this.topicPartitions().toSet()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("topics designated in ").append(optionKey).append(" should all appear in ").append(PulsarOptions$.MODULE$.TopicOptionKeys()).append(" .\n").append("topics: ").append(this.topicPartitions()).append(", topics in ").append(optionKey).append(": ").append(specified.keySet()).toString());
            Set nonSpecifiedTopics = (Set)this.topicPartitions().toSet().$minus$minus((GenTraversableOnce)specified.keySet());
            scala.collection.immutable.Map nonSpecified = ((TraversableOnce)nonSpecifiedTopics.map((Function1 & Serializable & scala.Serializable)tp -> {
                Tuple2 tuple2;
                PulsarOffset pulsarOffset = defaultOffsets;
                if (LatestOffset$.MODULE$.equals(pulsarOffset)) {
                    tuple2 = new Tuple2(tp, (Object)BoxesRunTime.boxToLong((long)PulsarProvider$.MODULE$.LATEST_TIME()));
                } else if (EarliestOffset$.MODULE$.equals(pulsarOffset)) {
                    tuple2 = new Tuple2(tp, (Object)BoxesRunTime.boxToLong((long)PulsarProvider$.MODULE$.EARLIEST_TIME()));
                } else {
                    throw new IllegalArgumentException("Defaults should be latest or earliest");
                }
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            offset = new SpecificPulsarTime((scala.collection.immutable.Map<String, Object>)specified.$plus$plus((GenTraversableOnce)nonSpecified));
        } else {
            throw new MatchError((Object)pulsarOffset);
        }
        return offset;
    }

    public SpecificPulsarOffset offsetForEachTopic(scala.collection.immutable.Map<String, String> params, String offsetOptionKey, PulsarOffset defaultOffsets) {
        SpecificPulsarOffset specificPulsarOffset;
        PulsarOffset offset;
        this.getTopicPartitions();
        PulsarOffset pulsarOffset = offset = PulsarProvider$.MODULE$.getPulsarOffset(params, offsetOptionKey, defaultOffsets);
        if (LatestOffset$.MODULE$.equals(pulsarOffset)) {
            specificPulsarOffset = new SpecificPulsarOffset((scala.collection.immutable.Map<String, MessageId>)((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp, (Object)MessageId.latest), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        } else if (EarliestOffset$.MODULE$.equals(pulsarOffset)) {
            specificPulsarOffset = new SpecificPulsarOffset((scala.collection.immutable.Map<String, MessageId>)((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp, (Object)MessageId.earliest), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        } else if (pulsarOffset instanceof SpecificPulsarOffset) {
            SpecificPulsarOffset specificPulsarOffset2 = (SpecificPulsarOffset)pulsarOffset;
            scala.collection.immutable.Map<String, MessageId> specified = specificPulsarOffset2.topicOffsets();
            Predef$.MODULE$.assert(specified.keySet().subsetOf((GenSet)this.topicPartitions().toSet()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("topics designated in startingOffsets/endingOffsets").append(" should all appear in ").append(PulsarOptions$.MODULE$.TopicOptionKeys()).append(" .\n").append("topics: ").append(this.topicPartitions()).append(", topics in offsets: ").append(specified.keySet()).toString());
            Set nonSpecifiedTopics = (Set)this.topicPartitions().toSet().$minus$minus((GenTraversableOnce)specified.keySet());
            scala.collection.immutable.Map nonSpecified = ((TraversableOnce)nonSpecifiedTopics.map((Function1 & Serializable & scala.Serializable)tp -> {
                Tuple2 tuple2;
                PulsarOffset pulsarOffset = defaultOffsets;
                if (LatestOffset$.MODULE$.equals(pulsarOffset)) {
                    tuple2 = new Tuple2(tp, (Object)MessageId.latest);
                } else if (EarliestOffset$.MODULE$.equals(pulsarOffset)) {
                    tuple2 = new Tuple2(tp, (Object)MessageId.earliest);
                } else {
                    throw new IllegalArgumentException("Defaults should be latest or earliest");
                }
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            specificPulsarOffset = new SpecificPulsarOffset((scala.collection.immutable.Map<String, MessageId>)specified.$plus$plus((GenTraversableOnce)nonSpecified));
        } else {
            throw new MatchError((Object)pulsarOffset);
        }
        return specificPulsarOffset;
    }

    public scala.collection.immutable.Map<String, MessageId> actualOffsets(PerTopicOffset offset, int pollTimeoutMs, Function1<String, BoxedUnit> reportDataLoss) {
        scala.collection.immutable.Map<String, MessageId> map;
        PerTopicOffset perTopicOffset = offset;
        if (perTopicOffset instanceof SpecificPulsarOffset) {
            SpecificPulsarOffset specificPulsarOffset = (SpecificPulsarOffset)perTopicOffset;
            map = this.fetchCurrentOffsets(specificPulsarOffset, reportDataLoss);
        } else if (perTopicOffset instanceof SpecificPulsarTime) {
            SpecificPulsarTime specificPulsarTime = (SpecificPulsarTime)perTopicOffset;
            map = this.fetchCurrentOffsets(specificPulsarTime, reportDataLoss);
        } else {
            throw new IllegalArgumentException(new StringBuilder(27).append("not supported offset type: ").append(perTopicOffset).toString());
        }
        return map;
    }

    private scala.collection.immutable.Map<String, MessageId> fetchCurrentOffsets(SpecificPulsarOffset offset, Function1<String, BoxedUnit> reportDataLoss) {
        return (scala.collection.immutable.Map)offset.topicOffsets().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var3_10;
            MessageId off;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String tp = (String)tuple2._1();
            MessageId messageId = off = (MessageId)tuple2._2();
            MessageId messageId2 = MessageId.earliest;
            MessageId messageId3 = messageId;
            if (!(messageId2 != null ? !messageId2.equals(messageId3) : messageId3 != null)) {
                UserProvidedMessageId userProvidedMessageId = new UserProvidedMessageId(off);
            } else {
                MessageId messageId4 = MessageId.latest;
                MessageId messageId5 = messageId;
                if (!(messageId4 != null ? !messageId4.equals(messageId5) : messageId5 != null)) {
                    UserProvidedMessageId userProvidedMessageId = new UserProvidedMessageId(PulsarSourceUtils$.MODULE$.seekableLatestMid(this.getLastMessageId(tp)));
                } else {
                    if (messageId == null) throw new IllegalArgumentException(new StringBuilder(27).append("not supported offset type: ").append(off).toString());
                    MessageIdImpl messageIdImpl = this.getUserProvidedMessageId(tp, (Option<Object>)None$.MODULE$, (Option<MessageId>)new Some((Object)off));
                }
            }
            void actualOffset = var3_10;
            return new Tuple2((Object)tp, (Object)actualOffset);
        }, Map$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Map<String, MessageId> fetchCurrentOffsets(SpecificPulsarTime time, Function1<String, BoxedUnit> reportDataLoss) {
        return (scala.collection.immutable.Map)time.topicTimes().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MessageIdImpl messageIdImpl;
            String tp;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long time;
                tp = (String)tuple2._1();
                long l = time = tuple2._2$mcJ$sp();
                if (PulsarProvider$.MODULE$.EARLIEST_TIME() == l) {
                    messageIdImpl = new UserProvidedMessageId(MessageId.earliest);
                } else if (PulsarProvider$.MODULE$.LATEST_TIME() == l) {
                    messageIdImpl = new UserProvidedMessageId(PulsarSourceUtils$.MODULE$.seekableLatestMid(this.getLastMessageId(tp)));
                } else {
                    Predef$.MODULE$.assert(time > 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("time less than 0: ").append(time).toString());
                    messageIdImpl = this.getUserProvidedMessageId(tp, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)time)), (Option<MessageId>)None$.MODULE$);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            UserProvidedMessageId actualOffset = messageIdImpl;
            Tuple2 tuple22 = new Tuple2((Object)tp, (Object)actualOffset);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private MessageIdImpl getUserProvidedMessageId(String topic, Option<Object> time, Option<MessageId> offset) {
        block6: {
            block3: {
                block5: {
                    block4: {
                        var7_4 = this.extractSubscription(this.predefinedSubscription(), topic);
                        if (var7_4 == null) {
                            throw new MatchError(var7_4);
                        }
                        var5_6 = subscriptionName = (String)var7_4._1();
                        subscriptionName = var5_6;
                        consumer = CachedConsumer$.MODULE$.getOrCreate(topic, subscriptionName, this.client());
                        if (!((ConsumerImpl)consumer).hasMessageAvailable()) break block3;
                        var10_9 = new Tuple2(time, offset);
                        if (var10_9 == null) break block4;
                        var11_10 = (Option)var10_9._1();
                        var12_11 = (Option)var10_9._2();
                        if (!None$.MODULE$.equals(var11_10) || !(var12_11 instanceof Some)) break block4;
                        var13_12 = (Some)var12_11;
                        o = (MessageId)var13_12.value();
                        consumer.seek(o);
                        var4_14 = BoxedUnit.UNIT;
                        break block5;
                    }
                    if (var10_9 == null) ** GOTO lbl-1000
                    var15_16 = (Option)var10_9._1();
                    var16_17 = (Option)var10_9._2();
                    if (!(var15_16 instanceof Some)) ** GOTO lbl-1000
                    var17_18 = (Some)var15_16;
                    t = BoxesRunTime.unboxToLong((Object)var17_18.value());
                    if (None$.MODULE$.equals(var16_17)) {
                        consumer.seek(t);
                        var4_15 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 3 sources

                    {
                        throw new IllegalArgumentException(new StringBuilder(54).append("one of time and offset should be set. time: ").append(time).append(", offset: ").append(offset).toString());
                    }
                }
                v0 /* !! */  = PulsarSourceUtils$.MODULE$.mid2Impl(consumer.receive().getMessageId());
                break block6;
            }
            v0 /* !! */  = new UserProvidedMessageId(MessageId.earliest);
        }
        return v0 /* !! */ ;
    }

    private MessageId getLastMessageId(String topic) {
        String subscriptionName;
        Tuple2<String, Object> tuple2 = this.extractSubscription(this.predefinedSubscription(), topic);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String string = subscriptionName = (String)tuple2._1();
        String subscriptionName2 = string;
        return CachedConsumer$.MODULE$.getOrCreate(topic, subscriptionName2, this.client()).getLastMessageId();
    }

    public PulsarHelper copy(String serviceUrl, Map<String, Object> clientConf, String driverGroupIdPrefix, scala.collection.immutable.Map<String, String> caseInsensitiveParameters, boolean allowDifferentTopicSchemas, Option<String> predefinedSubscription) {
        return new PulsarHelper(serviceUrl, clientConf, driverGroupIdPrefix, caseInsensitiveParameters, allowDifferentTopicSchemas, predefinedSubscription);
    }

    public String copy$default$1() {
        return this.serviceUrl();
    }

    public Map<String, Object> copy$default$2() {
        return this.clientConf();
    }

    public String copy$default$3() {
        return this.driverGroupIdPrefix();
    }

    public scala.collection.immutable.Map<String, String> copy$default$4() {
        return this.caseInsensitiveParameters();
    }

    public boolean copy$default$5() {
        return this.allowDifferentTopicSchemas();
    }

    public Option<String> copy$default$6() {
        return this.predefinedSubscription();
    }

    public String productPrefix() {
        return "PulsarHelper";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.serviceUrl();
                break;
            }
            case 1: {
                object = this.clientConf();
                break;
            }
            case 2: {
                object = this.driverGroupIdPrefix();
                break;
            }
            case 3: {
                object = this.caseInsensitiveParameters();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.allowDifferentTopicSchemas());
                break;
            }
            case 5: {
                object = this.predefinedSubscription();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PulsarHelper;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serviceUrl()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.clientConf()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.driverGroupIdPrefix()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.caseInsensitiveParameters()));
        n = Statics.mix((int)n, (int)(this.allowDifferentTopicSchemas() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.predefinedSubscription()));
        return Statics.finalizeHash((int)n, (int)6);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PulsarHelper)) return false;
        boolean bl = true;
        if (!bl) return false;
        PulsarHelper pulsarHelper = (PulsarHelper)x$1;
        String string = this.serviceUrl();
        String string2 = pulsarHelper.serviceUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Map<String, Object> map = this.clientConf();
        Map<String, Object> map2 = pulsarHelper.clientConf();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!((Object)map).equals(map2)) return false;
        String string3 = this.driverGroupIdPrefix();
        String string4 = pulsarHelper.driverGroupIdPrefix();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        scala.collection.immutable.Map<String, String> map3 = this.caseInsensitiveParameters();
        scala.collection.immutable.Map<String, String> map4 = pulsarHelper.caseInsensitiveParameters();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        if (this.allowDifferentTopicSchemas() != pulsarHelper.allowDifferentTopicSchemas()) return false;
        Option<String> option = this.predefinedSubscription();
        Option<String> option2 = pulsarHelper.predefinedSubscription();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!pulsarHelper.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$setupCursorByMid$1(PulsarHelper $this, Option subscription$1, Tuple2 x0$1) {
        String string;
        UserProvidedMessageId umid;
        String tp;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String subscriptionName;
            tp = (String)tuple2._1();
            MessageId mid = (MessageId)tuple2._2();
            umid = (UserProvidedMessageId)mid;
            Tuple2<String, Object> tuple22 = $this.extractSubscription((Option<String>)subscription$1, tp);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            string = subscriptionName = (String)tuple22._1();
        } else {
            throw new MatchError((Object)tuple2);
        }
        String subscriptionName = string;
        Consumer<GenericRecord> consumer = CachedConsumer$.MODULE$.getOrCreate(tp, subscriptionName, $this.client());
        $this.log().info(new StringBuilder(37).append("Resetting cursor for ").append(subscriptionName).append(" to given offset").toString());
        consumer.seek(umid.mid());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$setupCursorByTime$1(PulsarHelper $this, Option subscription$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String subscriptionNames;
            MessageId messageId;
            long time;
            String tp = (String)tuple2._1();
            long l = time = tuple2._2$mcJ$sp();
            if (PulsarProvider$.MODULE$.EARLIEST_TIME() == l) {
                messageId = MessageId.earliest;
            } else if (PulsarProvider$.MODULE$.LATEST_TIME() == l) {
                messageId = MessageId.latest;
            } else if (l >= 0L) {
                messageId = MessageId.latest;
            } else {
                throw new RuntimeException(new StringBuilder(28).append("Invalid starting time for ").append(tp).append(": ").append(time).toString());
            }
            MessageId msgID = messageId;
            Tuple2<String, Object> tuple22 = $this.extractSubscription((Option<String>)subscription$2, tp);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            String string = subscriptionNames = (String)tuple22._1();
            String subscriptionNames2 = string;
            Consumer<GenericRecord> consumer = CachedConsumer$.MODULE$.getOrCreate(tp, subscriptionNames2, $this.client());
            $this.log().info(new StringBuilder(40).append("Resetting cursor for ").append(subscriptionNames2).append(" to given timestamp").toString());
            long l2 = time;
            boolean bl = PulsarProvider$.MODULE$.EARLIEST_TIME() == l2 ? true : PulsarProvider$.MODULE$.LATEST_TIME() == l2;
            if (bl) {
                consumer.seek(msgID);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                consumer.seek(time);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$commitCursorToOffset$1(PulsarHelper $this, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String tp = (String)tuple2._1();
            MessageId mid = (MessageId)tuple2._2();
            try {
                String subscription;
                Tuple2<String, Object> tuple22 = $this.extractSubscription($this.predefinedSubscription(), tp);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                String string = subscription = (String)tuple22._1();
                String subscription2 = string;
                CachedConsumer$.MODULE$.getOrCreate(tp, subscription2, $this.client()).seek(mid);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                throw new RuntimeException(new StringBuilder(28).append("Failed to commit cursor for ").append(TopicName.get(tp).toString()).toString(), e);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$removeCursor$1(PulsarHelper $this, String tp) {
        Tuple2<String, Object> tuple2 = $this.extractSubscription($this.predefinedSubscription(), tp);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String subscriptionName = (String)tuple2._1();
        boolean subscriptionPredefined = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)subscriptionName, (Object)BoxesRunTime.boxToBoolean((boolean)subscriptionPredefined));
        Tuple2 tuple23 = tuple22;
        String subscriptionName2 = (String)tuple23._1();
        boolean subscriptionPredefined2 = tuple23._2$mcZ$sp();
        if (!subscriptionPredefined2) {
            try {
                CachedConsumer$.MODULE$.getOrCreate(tp, subscriptionName2, $this.client()).unsubscribe();
            }
            catch (Throwable e) {
                throw new RuntimeException(new StringBuilder(28).append("Failed to remove cursor for ").append(TopicName.get(tp).toString()).toString(), e);
            }
        }
    }

    public static final /* synthetic */ String $anonfun$getAndCheckCompatible$1() {
        return "The Schema of Pulsar source and provided doesn't match";
    }

    public static final /* synthetic */ boolean $anonfun$getTopics$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = PulsarOptions$.MODULE$.TopicOptionKeys().contains((Object)key);
        return bl;
    }

    public static final /* synthetic */ String $anonfun$getTopics$2(String x$3) {
        return x$3.trim();
    }

    public static final /* synthetic */ boolean $anonfun$getTopics$3(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$getTopics$4(String x$5) {
        return TopicName.get(x$5).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getTopics$5(String t) {
        return !TopicName.get(t).isPartitioned();
    }

    public static final /* synthetic */ boolean $anonfun$getTopics$6(String t) {
        return TopicName.get(t).isPartitioned();
    }

    public static final /* synthetic */ boolean $anonfun$topicsPatternFilter$2(Pattern shortenedTopicsPattern$1, String tp) {
        return shortenedTopicsPattern$1.matcher(tp.split("\\:\\/\\/")[1]).matches();
    }

    public PulsarHelper(String serviceUrl, Map<String, Object> clientConf, String driverGroupIdPrefix, scala.collection.immutable.Map<String, String> caseInsensitiveParameters, boolean allowDifferentTopicSchemas, Option<String> predefinedSubscription) {
        this.serviceUrl = serviceUrl;
        this.clientConf = clientConf;
        this.driverGroupIdPrefix = driverGroupIdPrefix;
        this.caseInsensitiveParameters = caseInsensitiveParameters;
        this.allowDifferentTopicSchemas = allowDifferentTopicSchemas;
        this.predefinedSubscription = predefinedSubscription;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.client = CachedPulsarClient$.MODULE$.getOrCreate(clientConf);
    }

    public static final /* synthetic */ Object $anonfun$getTopics$1$adapted(Tuple2 x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)PulsarHelper.$anonfun$getTopics$1(x0$1));
    }

    public static final /* synthetic */ Object $anonfun$getTopics$3$adapted(String x$4) {
        return BoxesRunTime.boxToBoolean((boolean)PulsarHelper.$anonfun$getTopics$3(x$4));
    }
}

