/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import org.apache.pulsar.client.api.MessageId;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.pulsar.PulsarOffsetRange;
import org.apache.spark.sql.pulsar.PulsarOffsetRange$;
import org.apache.spark.sql.pulsar.PulsarSourceRDD4Batch;
import org.apache.spark.sql.pulsar.PulsarSourceUtils$;
import org.apache.spark.sql.pulsar.SchemaInfoSerializable;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!\u0002\n\u0014\u0001Mi\u0002\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011I\u0018\t\u0011Q\u0002!\u0011!Q\u0001\nAB\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!y\u0006A!A!\u0002\u0013!\u0005\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0005D\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005W\"Aa\u000e\u0001B\u0001B\u0003%A\n\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003q\u0011\u0015A\b\u0001\"\u0001z\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\u0011\u001d\ty\u0002\u0001C!\u0003C\u0011a\u0002U;mg\u0006\u0014(+\u001a7bi&|gN\u0003\u0002\u0015+\u00051\u0001/\u001e7tCJT!AF\f\u0002\u0007M\fHN\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h'\u0011\u0001a\u0004J\u0014\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005*\u0012aB:pkJ\u001cWm]\u0005\u0003G\u0001\u0012ABQ1tKJ+G.\u0019;j_:\u0004\"aH\u0013\n\u0005\u0019\u0002#!\u0003+bE2,7kY1o!\tA3&D\u0001*\u0015\tQs#\u0001\u0005j]R,'O\\1m\u0013\ta\u0013FA\u0004M_\u001e<\u0017N\\4\u0002\u0015M\fHnQ8oi\u0016DHo\u0001\u0001\u0016\u0003A\u0002\"!\r\u001a\u000e\u0003UI!aM\u000b\u0003\u0015M\u000bFjQ8oi\u0016DH/A\u0006tc2\u001cuN\u001c;fqR\u0004\u0013AB:dQ\u0016l\u0017-F\u00018!\tA4(D\u0001:\u0015\tQT#A\u0003usB,7/\u0003\u0002=s\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u0005Q1o\u00195f[\u0006LeNZ8\u0011\u0005\u0001\u000bU\"A\n\n\u0005\t\u001b\"AF*dQ\u0016l\u0017-\u00138g_N+'/[1mSj\f'\r\\3\u0002\u0015\rd\u0017.\u001a8u\u0007>tg\r\u0005\u0003F\u00152KV\"\u0001$\u000b\u0005\u001dC\u0015\u0001B;uS2T\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n\u0019Q*\u00199\u0011\u000553fB\u0001(U!\ty%+D\u0001Q\u0015\t\tf&\u0001\u0004=e>|GO\u0010\u0006\u0002'\u0006)1oY1mC&\u0011QKU\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V%B\u0011!,X\u0007\u00027*\u0011A\fS\u0001\u0005Y\u0006tw-\u0003\u0002_7\n1qJ\u00196fGR\f!B]3bI\u0016\u00148i\u001c8g\u00039\u0019H/\u0019:uS:<wJ\u001a4tKR\u0004\"\u0001\u00112\n\u0005\r\u001c\"\u0001F*qK\u000eLg-[2Qk2\u001c\u0018M](gMN,G/\u0001\u0007f]\u0012LgnZ(gMN,G/A\u0007q_2dG+[7f_V$Xj\u001d\t\u0003O\"l\u0011AU\u0005\u0003SJ\u00131!\u00138u\u000391\u0017-\u001b7P]\u0012\u000bG/\u0019'pgN\u0004\"a\u001a7\n\u00055\u0014&a\u0002\"p_2,\u0017M\\\u0001\u0017gV\u00147o\u0019:jaRLwN\u001c(b[\u0016\u0004&/\u001a4jq\u0006Y!n]8o\u001fB$\u0018n\u001c8t!\t\th/D\u0001s\u0015\t\u0019H/\u0001\u0003kg>t'BA;\u0016\u0003!\u0019\u0017\r^1msN$\u0018BA<s\u0005EQ5k\u0014(PaRLwN\\:J]J+\u0017\rZ\u0001\u0007y%t\u0017\u000e\u001e \u0015%i\\H0 @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111\u0002\t\u0003\u0001\u0002AQ!\f\bA\u0002ABQ!\u000e\bA\u0002]BQA\u0010\bA\u0002}BQa\u0011\bA\u0002\u0011CQa\u0018\bA\u0002\u0011CQ\u0001\u0019\bA\u0002\u0005DQ\u0001\u001a\bA\u0002\u0005DQ!\u001a\bA\u0002\u0019DQA\u001b\bA\u0002-DQA\u001c\bA\u00021CQa\u001c\bA\u0002A\faB]3q_J$H)\u0019;b\u0019>\u001c8/\u0006\u0002\u0002\u0012A1q-a\u0005M\u0003/I1!!\u0006S\u0005%1UO\\2uS>t\u0017\u0007E\u0002h\u00033I1!a\u0007S\u0005\u0011)f.\u001b;\u0002\u001fI,\u0007o\u001c:u\t\u0006$\u0018\rT8tg\u0002\n\u0011BY;jY\u0012\u001c6-\u00198\u0015\u0005\u0005\r\u0002CBA\u0013\u0003W\ty#\u0004\u0002\u0002()\u0019\u0011\u0011F\f\u0002\u0007I$G-\u0003\u0003\u0002.\u0005\u001d\"a\u0001*E\tB\u0019\u0011'!\r\n\u0007\u0005MRCA\u0002S_^\u0004")
public class PulsarRelation
extends BaseRelation
implements TableScan,
Logging {
    private final SQLContext sqlContext;
    private final StructType schema;
    private final SchemaInfoSerializable schemaInfo;
    private final java.util.Map<String, Object> clientConf;
    private final java.util.Map<String, Object> readerConf;
    private final SpecificPulsarOffset startingOffset;
    private final SpecificPulsarOffset endingOffset;
    private final int pollTimeoutMs;
    private final boolean failOnDataLoss;
    private final String subscriptionNamePrefix;
    private final JSONOptionsInRead jsonOptions;
    private final Function1<String, BoxedUnit> reportDataLoss;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        return this.schema;
    }

    private Function1<String, BoxedUnit> reportDataLoss() {
        return this.reportDataLoss;
    }

    public RDD<Row> buildScan() {
        Map<String, MessageId> fromTopicOffsets = this.startingOffset.topicOffsets();
        Map<String, MessageId> endTopicOffsets = this.endingOffset.topicOffsets();
        Set set = fromTopicOffsets.keySet();
        Set set2 = endTopicOffsets.keySet();
        if (set == null ? set2 != null : !set.equals(set2)) {
            String fromTopics = ((TraversableOnce)fromTopicOffsets.keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
            String endTopics = ((TraversableOnce)endTopicOffsets.keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
            throw new IllegalStateException(new StringBuilder(74).append("different topics ").append("for starting offsets topics[").append(fromTopics).append("] and ").append("ending offsets topics[").append(endTopics).append("]").toString());
        }
        Seq offsetRanges = ((SetLike)((TraversableLike)endTopicOffsets.keySet().map((Function1 & Serializable & scala.Serializable)tp -> {
            MessageId fromOffset = (MessageId)fromTopicOffsets.getOrElse(tp, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(27).append((String)tp).append(" doesn't have a from offset").toString());
            });
            MessageId untilOffset = (MessageId)endTopicOffsets.apply(tp);
            return PulsarOffsetRange$.MODULE$.apply((String)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)range -> BoxesRunTime.boxToBoolean((boolean)PulsarRelation.$anonfun$buildScan$3(this, range)))).toSeq();
        PulsarSourceRDD4Batch rdd = new PulsarSourceRDD4Batch(this.sqlContext().sparkContext(), this.schemaInfo, this.clientConf, this.readerConf, (Seq<PulsarOffsetRange>)offsetRanges, this.pollTimeoutMs, this.failOnDataLoss, this.subscriptionNamePrefix, this.jsonOptions);
        return this.sqlContext().internalCreateDataFrame(rdd.setName("pulsar"), this.schema(), this.sqlContext().internalCreateDataFrame$default$3()).rdd();
    }

    public static final /* synthetic */ boolean $anonfun$buildScan$3(PulsarRelation $this, PulsarOffsetRange range) {
        boolean bl;
        if (range.untilOffset().compareTo(range.fromOffset()) < 0) {
            $this.reportDataLoss().apply((Object)new StringBuilder(64).append(range.topic()).append("'s offset was changed ").append("from ").append(range.fromOffset()).append(" to ").append(range.untilOffset()).append(", ").append("some data might has been missed").toString());
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public PulsarRelation(SQLContext sqlContext, StructType schema, SchemaInfoSerializable schemaInfo, java.util.Map<String, Object> clientConf, java.util.Map<String, Object> readerConf, SpecificPulsarOffset startingOffset, SpecificPulsarOffset endingOffset, int pollTimeoutMs, boolean failOnDataLoss, String subscriptionNamePrefix, JSONOptionsInRead jsonOptions) {
        this.sqlContext = sqlContext;
        this.schema = schema;
        this.schemaInfo = schemaInfo;
        this.clientConf = clientConf;
        this.readerConf = readerConf;
        this.startingOffset = startingOffset;
        this.endingOffset = endingOffset;
        this.pollTimeoutMs = pollTimeoutMs;
        this.failOnDataLoss = failOnDataLoss;
        this.subscriptionNamePrefix = subscriptionNamePrefix;
        this.jsonOptions = jsonOptions;
        Logging.$init$((Logging)this);
        this.reportDataLoss = PulsarSourceUtils$.MODULE$.reportDataLossFunc(failOnDataLoss);
    }
}

