/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.pulsar.PulsarOptions$;
import org.apache.spark.sql.pulsar.PulsarSerializer;
import org.apache.spark.sql.pulsar.PulsarSinks$;
import org.apache.spark.sql.pulsar.SchemaUtils$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055hA\u0002\u0011\"\u0003\u0003\t3\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00035\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005DQ\u0001\u001a\u0001\u0005\u0002\u0015DQ\u0001\u001c\u0001\u0005\n5D\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011C?\t\u0017\u0005\r\u0001\u00011AA\u0002\u0013E\u0011Q\u0001\u0005\u000b\u0003#\u0001\u0001\u0019!A!B\u0013q\bbCA\u000e\u0001A\u0005\t1!Q\u0001\n9D\u0011\"!\b\u0001\u0005\u0004%\t\"a\b\t\u000f\u0005\u0005\u0002\u0001)A\u0005c\"I\u00111\u0005\u0001C\u0002\u0013E\u0011Q\u0005\u0005\b\u0003O\u0001\u0001\u0015!\u0003w\u0011%\tI\u0003\u0001b\u0001\n#\t)\u0003C\u0004\u0002,\u0001\u0001\u000b\u0011\u0002<\t\u0013\u00055\u0002A1A\u0005\u0012\u0005=\u0002bBA\u0019\u0001\u0001\u0006I!\u001f\u0005\u000b\u0003g\u0001\u0001R1A\u0005\u0012\u0005U\u0002BCA\"\u0001!\u0015\r\u0011\"\u0005\u0002F!Q\u0011\u0011\u000f\u0001\t\u0006\u0004%\t\"a\u001d\t\u0015\u0005m\u0004\u0001#b\u0001\n#\ti\bC\u0005\u0002\f\u0002\u0011\r\u0011\"\u0005\u0002\u000e\"A\u00111\u0015\u0001!\u0002\u0013\ty\tC\u0004\u0002&\u0002!\t!a*\t\u0013\u0005]\u0006A1A\u0005\n\u0005e\u0006\u0002CAa\u0001\u0001\u0006I!a/\t\u000f\u0005U\u0007\u0001\"\u0005\u0002X\"9\u0011Q\u001d\u0001\u0005\u0012\u0005\u001d\bbBAu\u0001\u0011E\u0011q\u001d\u0005\b\u0003W\u0004A\u0011CAt\u0005=\u0001V\u000f\\:beJ{wo\u0016:ji\u0016\u0014(B\u0001\u0012$\u0003\u0019\u0001X\u000f\\:be*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0014\u0005\u0001a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g-A\u0006j]B,HoU2iK6\f7\u0001\u0001\t\u0004ku\u0002eB\u0001\u001c<\u001d\t9$(D\u00019\u0015\tI4'\u0001\u0004=e>|GOP\u0005\u0002_%\u0011AHL\u0001\ba\u0006\u001c7.Y4f\u0013\tqtHA\u0002TKFT!\u0001\u0010\u0018\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015aC3yaJ,7o]5p]NT!!R\u0012\u0002\u0011\r\fG/\u00197zgRL!a\u0012\"\u0003\u0013\u0005#HO]5ckR,\u0017AC2mS\u0016tGoQ8oMB!!jT)Z\u001b\u0005Y%B\u0001'N\u0003\u0011)H/\u001b7\u000b\u00039\u000bAA[1wC&\u0011\u0001k\u0013\u0002\u0004\u001b\u0006\u0004\bC\u0001*W\u001d\t\u0019F\u000b\u0005\u00028]%\u0011QKL\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V]A\u0011!,X\u0007\u00027*\u0011A,T\u0001\u0005Y\u0006tw-\u0003\u0002_7\n1qJ\u00196fGR\fA\u0002\u001d:pIV\u001cWM]\"p]\u001a\fQ\u0001^8qS\u000e\u00042!\f2R\u0013\t\u0019gF\u0001\u0004PaRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0019D\u0017N[6\u0011\u0005\u001d\u0004Q\"A\u0011\t\u000bI*\u0001\u0019\u0001\u001b\t\u000b!+\u0001\u0019A%\t\u000b}+\u0001\u0019A%\t\u000b\u0001,\u0001\u0019A1\u0002#\r\u0014X-\u0019;f!J|'.Z2uS>t7/F\u0001o!\u0019is.\u001d<ws&\u0011\u0001O\f\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u0007I,\b)D\u0001t\u0015\t!h&\u0001\u0006d_2dWm\u0019;j_:L!AP:\u0011\u0005\u0005;\u0018B\u0001=C\u0005A)fn]1gKB\u0013xN[3di&|g\u000e\u0005\u0002.u&\u00111P\f\u0002\b\u0005>|G.Z1o\u0003-1\u0017-\u001b7fI^\u0013\u0018\u000e^3\u0016\u0003y\u0004\"!N@\n\u0007\u0005\u0005qHA\u0005UQJ|w/\u00192mK\u0006ya-Y5mK\u0012<&/\u001b;f?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u00055\u0001cA\u0017\u0002\n%\u0019\u00111\u0002\u0018\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u001fA\u0011\u0011!a\u0001}\u0006\u0019\u0001\u0010J\u0019\u0002\u0019\u0019\f\u0017\u000e\\3e/JLG/\u001a\u0011)\u0007%\t)\u0002E\u0002.\u0003/I1!!\u0007/\u0005!1x\u000e\\1uS2,\u0017a\u0001=%k\u0005Ya/\u00197vKN\u001b\u0007.Z7b+\u0005\t\u0018\u0001\u0004<bYV,7k\u00195f[\u0006\u0004\u0013\u0001C7fi\u0006\u0004&o\u001c6\u0016\u0003Y\f\u0011\"\\3uCB\u0013xN\u001b\u0011\u0002\u0013Y\fG.^3Qe>T\u0017A\u0003<bYV,\u0007K]8kA\u0005Ya/\u00197JgN#(/^2u+\u0005I\u0018\u0001\u0004<bY&\u001b8\u000b\u001e:vGR\u0004\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u2%A\u0003usB,7/\u0003\u0003\u0002B\u0005m\"\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0019A,Hn]1s'\u000eDW-\\1\u0016\u0005\u0005\u001d\u0003\u0007BA%\u0003?\u0002b!a\u0013\u0002X\u0005mSBAA'\u0015\u0011\ty%!\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002T\u0005U\u0013AB2mS\u0016tGO\u0003\u0002#O%!\u0011\u0011LA'\u0005\u0019\u00196\r[3nCB!\u0011QLA0\u0019\u0001!1\"!\u0019\u0015\u0003\u0003\u0005\tQ!\u0001\u0002d\t\u0019q\f\n\u001a\u0012\t\u0005\u0015\u00141\u000e\t\u0004[\u0005\u001d\u0014bAA5]\t9aj\u001c;iS:<\u0007cA\u0017\u0002n%\u0019\u0011q\u000e\u0018\u0003\u0007\u0005s\u00170\u0001\u0006tKJL\u0017\r\\5{KJ,\"!!\u001e\u0011\u0007\u001d\f9(C\u0002\u0002z\u0005\u0012\u0001\u0003U;mg\u0006\u00148+\u001a:jC2L'0\u001a:\u0002\u001dMLgn\u001a7f!J|G-^2feV\u0011\u0011q\u0010\u0019\u0005\u0003\u0003\u000bI\t\u0005\u0004\u0002L\u0005\r\u0015qQ\u0005\u0005\u0003\u000b\u000biE\u0001\u0005Qe>$WoY3s!\u0011\ti&!#\u0005\u0017\u0005\u0005d#!A\u0001\u0002\u000b\u0005\u00111M\u0001\u000fi>\u0004\u0018n\u0019\u001aQe>$WoY3s+\t\ty\tE\u0004\u0002\u0012\u0006]\u0015+!'\u000e\u0005\u0005M%bAAKg\u00069Q.\u001e;bE2,\u0017b\u0001)\u0002\u0014B\"\u00111TAP!\u0019\tY%a!\u0002\u001eB!\u0011QLAP\t-\t\t\u000bGA\u0001\u0002\u0003\u0015\t!a\u0019\u0003\u0007}#\u0013'A\bu_BL7M\r)s_\u0012,8-\u001a:!\u0003-9W\r\u001e)s_\u0012,8-\u001a:\u0016\t\u0005%\u0016q\u0016\u000b\u0005\u0003W\u000b\u0019\f\u0005\u0004\u0002L\u0005\r\u0015Q\u0016\t\u0005\u0003;\ny\u000bB\u0004\u00022f\u0011\r!a\u0019\u0003\u0003QCa!!.\u001a\u0001\u0004\t\u0016A\u0001;q\u00031\u0019XM\u001c3DC2d'-Y2l+\t\tYLE\u0003\u0002>f\u000b\u0019M\u0002\u0004\u0002@n\u0001\u00111\u0018\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\u000eg\u0016tGmQ1mY\n\f7m\u001b\u0011\u0011\u000f\u0005\u0015\u00171ZAh}6\u0011\u0011q\u0019\u0006\u0004\u0003\u0013\\\u0015\u0001\u00034v]\u000e$\u0018n\u001c8\n\t\u00055\u0017q\u0019\u0002\u000b\u0005&\u001cuN\\:v[\u0016\u0014\b\u0003BA&\u0003#LA!a5\u0002N\tIQ*Z:tC\u001e,\u0017\nZ\u0001\bg\u0016tGMU8x)\u0011\t9!!7\t\u000f\u0005mG\u00041\u0001\u0002^\u0006\u0019!o\\<\u0011\t\u0005}\u0017\u0011]\u0007\u0002\t&\u0019\u00111\u001d#\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u000fG\",7m\u001b$pe\u0016\u0013(o\u001c:t)\t\t9!A\u0007qe>$WoY3s\r2,8\u000f[\u0001\u000eaJ|G-^2fe\u000ecwn]3")
public abstract class PulsarRowWriter {
    private DataType dataType;
    private Schema<?> pulsarSchema;
    private PulsarSerializer serializer;
    private Producer<?> singleProducer;
    private final Seq<Attribute> inputSchema;
    private final Map<String, Object> clientConf;
    private final Map<String, Object> producerConf;
    private final Option<String> topic;
    private volatile Throwable failedWrite;
    private final /* synthetic */ Tuple4 x$5;
    private final Seq<Attribute> valueSchema;
    private final UnsafeProjection metaProj;
    private final UnsafeProjection valueProj;
    private final boolean valIsStruct;
    private final scala.collection.mutable.Map<String, Producer<?>> topic2Producer;
    private final BiConsumer<MessageId, Throwable> sendCallback;
    private volatile byte bitmap$0;

    private Tuple4<Seq<Attribute>, UnsafeProjection, UnsafeProjection, Object> createProjections() {
        boolean bl;
        LeafExpression topicExpression = (LeafExpression)this.topic.map((Function1 & Serializable & scala.Serializable)x$1 -> Literal$.MODULE$.apply(x$1)).orElse((Function0 & Serializable & scala.Serializable)() -> $this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PulsarRowWriter.$anonfun$createProjections$3(x$2)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(53).append("topic option required when no ").append("'").append(PulsarOptions$.MODULE$.TopicAttributeName()).append("' attribute is present").toString());
        });
        DataType dataType = topicExpression.dataType();
        if (!StringType$.MODULE$.equals(dataType)) {
            throw new IllegalStateException(new StringBuilder(40).append(PulsarOptions$.MODULE$.TopicAttributeName()).append("attribute unsupported type ").append(dataType).append(". ").append(PulsarOptions$.MODULE$.TopicAttributeName()).append(" ").append("must be a ").append(StringType$.MODULE$.catalogString()).toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        LeafExpression keyExpression = (LeafExpression)this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PulsarRowWriter.$anonfun$createProjections$5(x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Literal(null, (DataType)BinaryType$.MODULE$));
        DataType dataType2 = keyExpression.dataType();
        boolean bl2 = StringType$.MODULE$.equals(dataType2) ? true : BinaryType$.MODULE$.equals(dataType2);
        if (!bl2) {
            throw new IllegalStateException(new StringBuilder(27).append(PulsarOptions$.MODULE$.KeyAttributeName()).append("attribute unsupported type ").append(dataType2.catalogString()).toString());
        }
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        LeafExpression eventTimeExpression = (LeafExpression)this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PulsarRowWriter.$anonfun$createProjections$7(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Literal(null, (DataType)LongType$.MODULE$));
        DataType dataType3 = eventTimeExpression.dataType();
        boolean bl3 = LongType$.MODULE$.equals(dataType3) ? true : TimestampType$.MODULE$.equals(dataType3);
        if (!bl3) {
            throw new IllegalStateException(new StringBuilder(27).append(PulsarOptions$.MODULE$.EventTimeName()).append("attribute unsupported type ").append(dataType3.catalogString()).toString());
        }
        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        UnsafeProjection metaProj = UnsafeProjection$.MODULE$.create((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{topicExpression, new Cast((Expression)keyExpression, (DataType)BinaryType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), eventTimeExpression})), this.inputSchema);
        Seq valuesExpression = (Seq)this.inputSchema.filter((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)PulsarRowWriter.$anonfun$createProjections$9(n)));
        UnsafeProjection valueProj = UnsafeProjection$.MODULE$.create(valuesExpression, this.inputSchema);
        if (valuesExpression.length() == 1) {
            DataType dataType4 = ((Expression)valuesExpression.head()).dataType();
            boolean bl4 = dataType4 instanceof StructType;
            bl = bl4;
        } else {
            bl = true;
        }
        boolean isStruct = bl;
        return new Tuple4((Object)valuesExpression, (Object)metaProj, (Object)valueProj, (Object)BoxesRunTime.boxToBoolean((boolean)isStruct));
    }

    public Throwable failedWrite() {
        return this.failedWrite;
    }

    public void failedWrite_$eq(Throwable x$1) {
        this.failedWrite = x$1;
    }

    public Seq<Attribute> valueSchema() {
        return this.valueSchema;
    }

    public UnsafeProjection metaProj() {
        return this.metaProj;
    }

    public UnsafeProjection valueProj() {
        return this.valueProj;
    }

    public boolean valIsStruct() {
        return this.valIsStruct;
    }

    private DataType dataType$lzycompute() {
        PulsarRowWriter pulsarRowWriter = this;
        synchronized (pulsarRowWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dataType = this.valIsStruct() ? PulsarSinks$.MODULE$.toStructType(this.valueSchema()) : ((Expression)this.valueSchema().head()).dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dataType;
    }

    public DataType dataType() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    private Schema<?> pulsarSchema$lzycompute() {
        PulsarRowWriter pulsarRowWriter = this;
        synchronized (pulsarRowWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.pulsarSchema = SchemaUtils$.MODULE$.sqlType2PSchema(this.dataType(), SchemaUtils$.MODULE$.sqlType2PSchema$default$2());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.pulsarSchema;
    }

    public Schema<?> pulsarSchema() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.pulsarSchema$lzycompute() : this.pulsarSchema;
    }

    private PulsarSerializer serializer$lzycompute() {
        PulsarRowWriter pulsarRowWriter = this;
        synchronized (pulsarRowWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serializer = new PulsarSerializer(this.dataType(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.serializer;
    }

    public PulsarSerializer serializer() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serializer$lzycompute() : this.serializer;
    }

    private Producer<?> singleProducer$lzycompute() {
        PulsarRowWriter pulsarRowWriter = this;
        synchronized (pulsarRowWriter) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.singleProducer = this.topic.isDefined() ? PulsarSinks$.MODULE$.createProducer(this.clientConf, this.producerConf, (String)this.topic.get(), this.pulsarSchema()) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.singleProducer;
    }

    public Producer<?> singleProducer() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.singleProducer$lzycompute() : this.singleProducer;
    }

    public scala.collection.mutable.Map<String, Producer<?>> topic2Producer() {
        return this.topic2Producer;
    }

    /*
     * WARNING - void declaration
     */
    public <T> Producer<T> getProducer(String tp) {
        Producer producer;
        if (this.singleProducer() != null) {
            return this.singleProducer();
        }
        if (this.topic2Producer().contains((Object)tp)) {
            producer = (Producer)this.topic2Producer().apply((Object)tp);
        } else {
            void var2_2;
            Producer<?> p = PulsarSinks$.MODULE$.createProducer(this.clientConf, this.producerConf, tp, this.pulsarSchema());
            this.topic2Producer().put((Object)tp, p);
            producer = var2_2;
        }
        return producer;
    }

    private BiConsumer<MessageId, Throwable> sendCallback() {
        return this.sendCallback;
    }

    public void sendRow(InternalRow row) {
        long eventTime;
        UnsafeRow metaRow = this.metaProj().apply(row);
        UnsafeRow valueRow = this.valueProj().apply(row);
        Object value = this.serializer().serialize(valueRow);
        UTF8String topic = metaRow.getUTF8String(0);
        byte[] key = metaRow.getBinary(1);
        if (topic == null) {
            throw new NullPointerException(new StringBuilder(68).append("null topic present in the data. Use the ").append(PulsarOptions$.MODULE$.TopicSingle()).append(" option for setting a topic.").toString());
        }
        TypedMessageBuilder<Object> mb = this.getProducer(topic.toString()).newMessage().value(value);
        Object object = key != null ? mb.keyBytes(key) : BoxedUnit.UNIT;
        Object object2 = !metaRow.isNullAt(2) ? ((eventTime = metaRow.getLong(2)) > 0L ? mb.eventTime(eventTime) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        mb.sendAsync().whenComplete((BiConsumer)this.sendCallback());
    }

    public void checkForErrors() {
        if (this.failedWrite() != null) {
            throw this.failedWrite();
        }
    }

    public void producerFlush() {
        if (this.singleProducer() != null) {
            this.singleProducer().flush();
        } else {
            this.topic2Producer().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                PulsarRowWriter.$anonfun$producerFlush$1(x$6);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void producerClose() {
        this.producerFlush();
        if (this.singleProducer() != null) {
            this.singleProducer().close();
        } else {
            this.topic2Producer().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                PulsarRowWriter.$anonfun$producerClose$1(x$7);
                return BoxedUnit.UNIT;
            });
        }
        this.topic2Producer().clear();
    }

    public static final /* synthetic */ boolean $anonfun$createProjections$3(Attribute x$2) {
        String string = x$2.name();
        String string2 = PulsarOptions$.MODULE$.TopicAttributeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createProjections$5(Attribute x$3) {
        String string = x$3.name();
        String string2 = PulsarOptions$.MODULE$.KeyAttributeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createProjections$7(Attribute x$4) {
        String string = x$4.name();
        String string2 = PulsarOptions$.MODULE$.EventTimeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createProjections$9(Attribute n) {
        return !PulsarOptions$.MODULE$.MetaFieldNames().contains((Object)n.name());
    }

    public static final /* synthetic */ void $anonfun$producerFlush$1(Tuple2 x$6) {
        ((Producer)x$6._2()).flush();
    }

    public static final /* synthetic */ void $anonfun$producerClose$1(Tuple2 x$7) {
        ((Producer)x$7._2()).close();
    }

    public PulsarRowWriter(Seq<Attribute> inputSchema, Map<String, Object> clientConf, Map<String, Object> producerConf, Option<String> topic) {
        this.inputSchema = inputSchema;
        this.clientConf = clientConf;
        this.producerConf = producerConf;
        this.topic = topic;
        Tuple4<Seq<Attribute>, UnsafeProjection, UnsafeProjection, Object> tuple4 = this.createProjections();
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Seq valueSchema = (Seq)tuple4._1();
        UnsafeProjection metaProj = (UnsafeProjection)tuple4._2();
        UnsafeProjection valueProj = (UnsafeProjection)tuple4._3();
        boolean valIsStruct = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)valueSchema, (Object)metaProj, (Object)valueProj, (Object)BoxesRunTime.boxToBoolean((boolean)valIsStruct));
        this.x$5 = tuple42;
        this.valueSchema = (Seq)this.x$5._1();
        this.metaProj = (UnsafeProjection)this.x$5._2();
        this.valueProj = (UnsafeProjection)this.x$5._3();
        this.valIsStruct = BoxesRunTime.unboxToBoolean((Object)this.x$5._4());
        this.topic2Producer = Map$.MODULE$.empty();
        this.sendCallback = new BiConsumer<MessageId, Throwable>(this){
            private final /* synthetic */ PulsarRowWriter $outer;

            public BiConsumer<MessageId, Throwable> andThen(BiConsumer<? super MessageId, ? super Throwable> x$1) {
                return BiConsumer.super.andThen(x$1);
            }

            public void accept(MessageId t, Throwable u) {
                block0: {
                    if (this.$outer.failedWrite() != null || u == null) break block0;
                    this.$outer.failedWrite_$eq(u);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

