/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.shade.org.apache.commons.io.IOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.pulsar.PerTopicOffset;
import org.apache.spark.sql.pulsar.PulsarHelper;
import org.apache.spark.sql.pulsar.PulsarSourceUtils$;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u001d4Aa\u0002\u0005\u0001'!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0015A\u0004\u0001\"\u0011:\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015\t\u0006\u0001\"\u0001S\u0005}\u0001V\u000f\\:beN{WO]2f\u0013:LG/[1m\u001f\u001a47/\u001a;Xe&$XM\u001d\u0006\u0003\u0013)\ta\u0001];mg\u0006\u0014(BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\r)\"\u0004H\u0007\u0002-)\u0011q\u0003G\u0001\ngR\u0014X-Y7j]\u001eT!!\u0007\u0006\u0002\u0013\u0015DXmY;uS>t\u0017BA\u000e\u0017\u0005=AEIR*NKR\fG-\u0019;b\u0019><\u0007CA\u000f\u001f\u001b\u0005A\u0011BA\u0010\t\u0005Q\u0019\u0006/Z2jM&\u001c\u0007+\u001e7tCJ|eMZ:fi\u0006a1\u000f]1sWN+7o]5p]B\u0011!eI\u0007\u0002\u0015%\u0011AE\u0003\u0002\r'B\f'o[*fgNLwN\\\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\t\u0003OAr!\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-\u0012\u0012A\u0002\u001fs_>$hHC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyC&\u0001\u0004Qe\u0016$WMZ\u0005\u0003cI\u0012aa\u0015;sS:<'BA\u0018-\u0003\u0019a\u0014N\\5u}Q\u0019QGN\u001c\u0011\u0005u\u0001\u0001\"\u0002\u0011\u0004\u0001\u0004\t\u0003\"B\u0013\u0004\u0001\u00041\u0013!C:fe&\fG.\u001b>f)\rQd\b\u0011\t\u0003wqj\u0011\u0001L\u0005\u0003{1\u0012A!\u00168ji\")q\b\u0002a\u00019\u0005AQ.\u001a;bI\u0006$\u0018\rC\u0003B\t\u0001\u0007!)A\u0002pkR\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u0005%|'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013AbT;uaV$8\u000b\u001e:fC6\f1\u0002Z3tKJL\u0017\r\\5{KR\u0011A\u0004\u0014\u0005\u0006\u001b\u0016\u0001\rAT\u0001\u0003S:\u0004\"aQ(\n\u0005A#%aC%oaV$8\u000b\u001e:fC6\f\u0001cZ3u\u0013:LG/[1m\u001f\u001a47/\u001a;\u0015\u000bq\u0019\u0006,\u00182\t\u000bQ3\u0001\u0019A+\u0002\u0019A,Hn]1s\u0011\u0016d\u0007/\u001a:\u0011\u0005u1\u0016BA,\t\u00051\u0001V\u000f\\:be\"+G\u000e]3s\u0011\u0015If\u00011\u0001[\u0003=\u0019H/\u0019:uS:<wJ\u001a4tKR\u001c\bCA\u000f\\\u0013\ta\u0006B\u0001\bQKJ$v\u000e]5d\u001f\u001a47/\u001a;\t\u000by3\u0001\u0019A0\u0002\u001bA|w\u000e\u001c+j[\u0016|W\u000f^'t!\tY\u0004-\u0003\u0002bY\t\u0019\u0011J\u001c;\t\u000b\r4\u0001\u0019\u00013\u0002\u001dI,\u0007o\u001c:u\t\u0006$\u0018\rT8tgB!1(\u001a\u0014;\u0013\t1GFA\u0005Gk:\u001cG/[8oc\u0001")
public class PulsarSourceInitialOffsetWriter
extends HDFSMetadataLog<SpecificPulsarOffset> {
    public void serialize(SpecificPulsarOffset metadata, OutputStream out) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        writer.write(new StringBuilder(2).append("v").append(PulsarSourceUtils$.MODULE$.VERSION()).append("\n").toString());
        writer.write(metadata.json());
        writer.flush();
    }

    public SpecificPulsarOffset deserialize(InputStream in) {
        int indexOfNewLine;
        String content = IOUtils.toString(new InputStreamReader(in, StandardCharsets.UTF_8));
        Predef$.MODULE$.assert(content.length() != 0);
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
            indexOfNewLine = content.indexOf("\n");
            if (indexOfNewLine <= 0) {
                throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
            }
        } else {
            throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
        }
        int version = this.validateVersion(content.substring(0, indexOfNewLine), PulsarSourceUtils$.MODULE$.VERSION());
        return SpecificPulsarOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
    }

    public SpecificPulsarOffset getInitialOffset(PulsarHelper pulsarHelper, PerTopicOffset startingOffsets, int poolTimeoutMs, Function1<String, BoxedUnit> reportDataLoss) {
        return (SpecificPulsarOffset)this.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            SpecificPulsarOffset actualOffsets = new SpecificPulsarOffset(pulsarHelper.actualOffsets(startingOffsets, poolTimeoutMs, reportDataLoss));
            this.add(0L, actualOffsets);
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial Offsets: ").append(actualOffsets).toString());
            return actualOffsets;
        });
    }

    public PulsarSourceInitialOffsetWriter(SparkSession sparkSession, String metadataPath) {
        super(sparkSession, metadataPath, ClassTag$.MODULE$.apply(SpecificPulsarOffset.class));
    }
}

