/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.pulsar.PulsarOptions$;
import org.apache.spark.sql.pulsar.UserProvidedMessageId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PulsarSourceUtils$
implements Logging {
    public static PulsarSourceUtils$ MODULE$;
    private final int VERSION;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PulsarSourceUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int VERSION() {
        return this.VERSION;
    }

    public String[] getSortedExecutorList(BlockManager blockManager) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockManager.master().getPeers(blockManager.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class)))).map((Function1 & Serializable & scala.Serializable)x -> new ExecutorCacheTaskLocation(x.host(), x.executorId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class))))).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)PulsarSourceUtils$.MODULE$.compare(a, b))))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public String[] getSortedExecutorList(SparkContext sc) {
        return this.getSortedExecutorList(sc.env().blockManager());
    }

    public String[] getSortedExecutorList() {
        return this.getSortedExecutorList(SparkEnv$.MODULE$.get().blockManager());
    }

    private boolean compare(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId()) : new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public Function1<String, BoxedUnit> reportDataLossFunc(boolean failOnDataLoss) {
        return (Function1 & Serializable & scala.Serializable)message -> {
            PulsarSourceUtils$.$anonfun$reportDataLossFunc$1(failOnDataLoss, message);
            return BoxedUnit.UNIT;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean messageIdRoughEquals(MessageId l, MessageId r) {
        Tuple2 tuple2 = new Tuple2((Object)l, (Object)r);
        if (tuple2 != null) {
            MessageId lb = (MessageId)tuple2._1();
            MessageId rb = (MessageId)tuple2._2();
            if (lb instanceof BatchMessageIdImpl) {
                BatchMessageIdImpl batchMessageIdImpl = (BatchMessageIdImpl)lb;
                if (rb instanceof BatchMessageIdImpl) {
                    BatchMessageIdImpl batchMessageIdImpl2 = (BatchMessageIdImpl)rb;
                    return batchMessageIdImpl.equals(batchMessageIdImpl2);
                }
            }
        }
        if (tuple2 != null) {
            MessageId lm = (MessageId)tuple2._1();
            MessageId rb = (MessageId)tuple2._2();
            if (lm instanceof MessageIdImpl) {
                MessageIdImpl messageIdImpl = (MessageIdImpl)lm;
                if (rb instanceof BatchMessageIdImpl) {
                    BatchMessageIdImpl batchMessageIdImpl = (BatchMessageIdImpl)rb;
                    return messageIdImpl.equals(new MessageIdImpl(batchMessageIdImpl.getLedgerId(), batchMessageIdImpl.getEntryId(), batchMessageIdImpl.getPartitionIndex()));
                }
            }
        }
        if (tuple2 != null) {
            MessageId lb = (MessageId)tuple2._1();
            MessageId rm = (MessageId)tuple2._2();
            if (lb instanceof BatchMessageIdImpl) {
                BatchMessageIdImpl batchMessageIdImpl = (BatchMessageIdImpl)lb;
                if (rm instanceof MessageIdImpl) {
                    MessageIdImpl messageIdImpl = (MessageIdImpl)rm;
                    return messageIdImpl.equals(new MessageIdImpl(batchMessageIdImpl.getLedgerId(), batchMessageIdImpl.getEntryId(), batchMessageIdImpl.getPartitionIndex()));
                }
            }
        }
        if (tuple2 == null) throw new IllegalStateException(new StringBuilder(33).append("comparing messageIds of type [").append(l.getClass().getName()).append(", ").append(r.getClass().getName()).append("]").toString());
        MessageId lm = (MessageId)tuple2._1();
        MessageId rm = (MessageId)tuple2._2();
        if (!(lm instanceof MessageIdImpl)) throw new IllegalStateException(new StringBuilder(33).append("comparing messageIds of type [").append(l.getClass().getName()).append(", ").append(r.getClass().getName()).append("]").toString());
        MessageIdImpl messageIdImpl = (MessageIdImpl)lm;
        if (!(rm instanceof MessageIdImpl)) throw new IllegalStateException(new StringBuilder(33).append("comparing messageIds of type [").append(l.getClass().getName()).append(", ").append(r.getClass().getName()).append("]").toString());
        MessageIdImpl messageIdImpl2 = (MessageIdImpl)rm;
        return messageIdImpl.equals(messageIdImpl2);
    }

    public boolean messageExists(MessageId mid) {
        MessageId messageId;
        block1: {
            while (true) {
                if ((messageId = mid) instanceof MessageIdImpl) break block1;
                if (!(messageId instanceof TopicMessageIdImpl)) break;
                TopicMessageIdImpl topicMessageIdImpl = (TopicMessageIdImpl)messageId;
                mid = topicMessageIdImpl.getInnerMessageId();
            }
            throw new MatchError((Object)messageId);
        }
        MessageIdImpl messageIdImpl = (MessageIdImpl)messageId;
        boolean bl = messageIdImpl.getLedgerId() != -1L && messageIdImpl.getEntryId() != -1L;
        return bl;
    }

    public boolean enteredEnd(MessageId end, MessageId current) {
        MessageIdImpl endImpl = (MessageIdImpl)end;
        MessageIdImpl currentImpl = (MessageIdImpl)current;
        boolean result = endImpl.getLedgerId() == currentImpl.getLedgerId() && endImpl.getEntryId() == currentImpl.getEntryId();
        return result;
    }

    public boolean isLastMessage(MessageId messageId) {
        boolean bl;
        MessageId messageId2 = messageId;
        if (messageId2 instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl batchMessageIdImpl = (BatchMessageIdImpl)messageId2;
            bl = batchMessageIdImpl.getBatchIndex() == batchMessageIdImpl.getBatchSize() - 1;
        } else if (messageId2 instanceof MessageIdImpl) {
            bl = true;
        } else {
            throw new IllegalStateException(new StringBuilder(26).append("reading a message of type ").append(messageId.getClass().getName()).toString());
        }
        return bl;
    }

    public MessageIdImpl mid2Impl(MessageId mid) {
        MessageIdImpl messageIdImpl;
        block4: {
            MessageId messageId;
            while (true) {
                if ((messageId = mid) instanceof BatchMessageIdImpl) {
                    BatchMessageIdImpl batchMessageIdImpl = (BatchMessageIdImpl)messageId;
                    messageIdImpl = new MessageIdImpl(batchMessageIdImpl.getLedgerId(), batchMessageIdImpl.getEntryId(), batchMessageIdImpl.getPartitionIndex());
                    break block4;
                }
                if (messageId instanceof MessageIdImpl) {
                    MessageIdImpl messageIdImpl2;
                    messageIdImpl = messageIdImpl2 = (MessageIdImpl)messageId;
                    break block4;
                }
                if (messageId instanceof TopicMessageIdImpl) {
                    TopicMessageIdImpl topicMessageIdImpl = (TopicMessageIdImpl)messageId;
                    mid = topicMessageIdImpl.getInnerMessageId();
                    continue;
                }
                if (!(messageId instanceof UserProvidedMessageId)) break;
                UserProvidedMessageId userProvidedMessageId = (UserProvidedMessageId)messageId;
                mid = userProvidedMessageId.mid();
            }
            throw new MatchError((Object)messageId);
        }
        return messageIdImpl;
    }

    public MessageId seekableLatestMid(MessageId mid) {
        return this.messageExists(mid) ? mid : MessageId.earliest;
    }

    public static final /* synthetic */ void $anonfun$reportDataLossFunc$1(boolean failOnDataLoss$1, String message) {
        if (failOnDataLoss$1) {
            throw new IllegalStateException(new StringBuilder(2).append(message).append(". ").append(PulsarOptions$.MODULE$.InstructionForFailOnDataLossTrue()).toString());
        }
        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(message).append(". ").append(PulsarOptions$.MODULE$.InstructionForFailOnDataLossFalse()).toString());
    }

    private PulsarSourceUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.VERSION = 1;
    }
}

