/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AbstractStructSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

@Deprecated
public abstract class StructSchema<T>
extends AbstractStructSchema<T> {
    protected final Schema schema;

    protected StructSchema(SchemaInfo schemaInfo) {
        super(schemaInfo);
        this.schema = StructSchema.parseAvroSchema(new String(schemaInfo.getSchema(), StandardCharsets.UTF_8));
        if (schemaInfo.getProperties().containsKey("__AVRO_READ_OFFSET__")) {
            this.schema.addProp("__AVRO_READ_OFFSET__", schemaInfo.getProperties().get("__AVRO_READ_OFFSET__"));
        }
    }

    public Schema getAvroSchema() {
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Schema createAvroSchema(SchemaDefinition schemaDefinition) {
        Class pojo = schemaDefinition.getPojo();
        if (StringUtils.isNotBlank(schemaDefinition.getJsonDef())) {
            return StructSchema.parseAvroSchema(schemaDefinition.getJsonDef());
        }
        if (pojo != null) {
            ThreadLocal validateDefaults = null;
            try {
                Field validateDefaultsField = Schema.class.getDeclaredField("VALIDATE_DEFAULTS");
                validateDefaultsField.setAccessible(true);
                validateDefaults = (ThreadLocal)validateDefaultsField.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Cannot disable validation of default values", e);
            }
            boolean savedValidateDefaults = (Boolean)validateDefaults.get();
            try {
                validateDefaults.set(false);
                Schema schema = StructSchema.extractAvroSchema(schemaDefinition, pojo);
                return schema;
            }
            finally {
                validateDefaults.set(savedValidateDefaults);
            }
        }
        throw new RuntimeException("Schema definition must specify pojo class or schema json definition");
    }

    protected static Schema extractAvroSchema(SchemaDefinition schemaDefinition, Class pojo) {
        try {
            return StructSchema.parseAvroSchema(pojo.getDeclaredField("SCHEMA$").get(null).toString());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ignored) {
            return schemaDefinition.getAlwaysAllowNull() ? ReflectData.AllowNull.get().getSchema(pojo) : ReflectData.get().getSchema(pojo);
        }
    }

    protected static Schema parseAvroSchema(String schemaJson) {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser.parse(schemaJson);
    }

    public static <T> SchemaInfo parseSchemaInfo(SchemaDefinition<T> schemaDefinition, SchemaType schemaType) {
        return SchemaInfoImpl.builder().schema(StructSchema.createAvroSchema(schemaDefinition).toString().getBytes(StandardCharsets.UTF_8)).properties(schemaDefinition.getProperties()).name("").type(schemaType).build();
    }
}

