/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeRecord;
import org.apache.pulsar.shade.com.google.protobuf.Descriptors;
import org.apache.pulsar.shade.com.google.protobuf.DynamicMessage;
import org.apache.pulsar.shade.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericProtobufNativeReader
implements SchemaReader<GenericRecord> {
    private final Descriptors.Descriptor descriptor;
    private final byte[] schemaVersion;
    private final List<Field> fields;
    private static final Logger log = LoggerFactory.getLogger(GenericProtobufNativeReader.class);

    public GenericProtobufNativeReader(Descriptors.Descriptor descriptor) {
        this(descriptor, null);
    }

    public GenericProtobufNativeReader(Descriptors.Descriptor descriptor, byte[] schemaVersion) {
        try {
            this.schemaVersion = schemaVersion;
            this.descriptor = descriptor;
            this.fields = descriptor.getFields().stream().map(f -> new Field(f.getName(), f.getIndex())).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("GenericProtobufNativeReader init error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public GenericProtobufNativeRecord read(byte[] bytes, int offset, int length) {
        try {
            if (bytes.length != length || offset != 0) {
                bytes = Arrays.copyOfRange(bytes, offset, offset + length);
            }
            return new GenericProtobufNativeRecord(this.schemaVersion, this.descriptor, this.fields, DynamicMessage.parseFrom((Descriptors.Descriptor)this.descriptor, (byte[])bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public GenericProtobufNativeRecord read(InputStream inputStream) {
        try {
            return new GenericProtobufNativeRecord(this.schemaVersion, this.descriptor, this.fields, DynamicMessage.parseFrom((Descriptors.Descriptor)this.descriptor, (InputStream)inputStream));
        }
        catch (IOException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public Optional<Object> getNativeSchema() {
        return Optional.of(this.descriptor);
    }
}

