/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.util.Map;
import java.util.Set;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.pulsar.PulsarSinks$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4Qa\u0003\u0007\u0001\u0019YA\u0001\"\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\t\u0001B\u0001B\u0003%A\u0007\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u001d)\u0006\u00011A\u0005\nYCqA\u0017\u0001A\u0002\u0013%1\f\u0003\u0004b\u0001\u0001\u0006Ka\u0016\u0005\u0006M\u0002!\te\u001a\u0005\u0006Q\u0002!\t%\u001b\u0002\u000b!Vd7/\u0019:TS:\\'BA\u0007\u000f\u0003\u0019\u0001X\u000f\\:be*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0014\t\u00019rd\n\t\u00031ui\u0011!\u0007\u0006\u00035m\tA\u0001\\1oO*\tA$\u0001\u0003kCZ\f\u0017B\u0001\u0010\u001a\u0005\u0019y%M[3diB\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\ngR\u0014X-Y7j]\u001eT!\u0001\n\b\u0002\u0013\u0015DXmY;uS>t\u0017B\u0001\u0014\"\u0005\u0011\u0019\u0016N\\6\u0011\u0005!ZS\"A\u0015\u000b\u0005)\u0002\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00051J#a\u0002'pO\u001eLgnZ\u0001\u000bgFd7i\u001c8uKb$8\u0001\u0001\t\u0003aEj\u0011AD\u0005\u0003e9\u0011!bU)M\u0007>tG/\u001a=u\u0003A\u0001X\u000f\\:be\u000ec\u0017.\u001a8u\u0007>tg\r\u0005\u00036qi:R\"\u0001\u001c\u000b\u0005]Z\u0012\u0001B;uS2L!!\u000f\u001c\u0003\u00075\u000b\u0007\u000f\u0005\u0002<\t:\u0011AH\u0011\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f9\na\u0001\u0010:p_Rt$\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011!\u0002%A,Hn]1s!J|G-^2fe\u000e{gNZ\u0001\u0006i>\u0004\u0018n\u0019\t\u0004\u0015.ST\"\u0001!\n\u00051\u0003%AB(qi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0006\u001fF\u00136\u000b\u0016\t\u0003!\u0002i\u0011\u0001\u0004\u0005\u0006[\u0015\u0001\ra\f\u0005\u0006g\u0015\u0001\r\u0001\u000e\u0005\u0006\u000f\u0016\u0001\r\u0001\u000e\u0005\u0006\u0011\u0016\u0001\r!S\u0001\u000eY\u0006$Xm\u001d;CCR\u001c\u0007.\u00133\u0016\u0003]\u0003\"A\u0013-\n\u0005e\u0003%\u0001\u0002'p]\u001e\f\u0011\u0003\\1uKN$()\u0019;dQ&#w\fJ3r)\tav\f\u0005\u0002K;&\u0011a\f\u0011\u0002\u0005+:LG\u000fC\u0004a\u000f\u0005\u0005\t\u0019A,\u0002\u0007a$\u0013'\u0001\bmCR,7\u000f\u001e\"bi\u000eD\u0017\n\u001a\u0011)\u0005!\u0019\u0007C\u0001&e\u0013\t)\u0007I\u0001\u0005w_2\fG/\u001b7f\u0003!!xn\u0015;sS:<G#\u0001\u001e\u0002\u0011\u0005$GMQ1uG\"$2\u0001\u00186m\u0011\u0015Y'\u00021\u0001X\u0003\u001d\u0011\u0017\r^2i\u0013\u0012DQ!\u001c\u0006A\u00029\fA\u0001Z1uCB\u0011qN\u001f\b\u0003abt!!]<\u000f\u0005I4hBA:v\u001d\tiD/C\u0001\u0016\u0013\t\u0019B#\u0003\u0002\u0012%%\u0011q\u0002E\u0005\u0003s:\tq\u0001]1dW\u0006<W-\u0003\u0002|y\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003s:\u0001")
public class PulsarSink
implements Sink,
Logging {
    private final SQLContext sqlContext;
    private final Map<String, Object> pulsarClientConf;
    private final Map<String, Object> pulsarProducerConf;
    private final Option<String> topic;
    private volatile long latestBatchId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public String name() {
        return Sink.name$((Sink)this);
    }

    public StructType schema() {
        return Sink.schema$((Sink)this);
    }

    public Set<TableCapability> capabilities() {
        return Sink.capabilities$((Sink)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long latestBatchId() {
        return this.latestBatchId;
    }

    private void latestBatchId_$eq(long x$1) {
        this.latestBatchId = x$1;
    }

    public String toString() {
        return "PulsarSink";
    }

    public void addBatch(long batchId, Dataset<Row> data) {
        PulsarSinks$.MODULE$.validateQuery((Seq<Attribute>)data.schema().toAttributes(), this.topic);
        if (batchId <= this.latestBatchId()) {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(33).append("Skipping already committed batch ").append(batchId).toString());
            return;
        }
        PulsarSinks$.MODULE$.write(this.sqlContext.sparkSession(), data.queryExecution(), this.pulsarClientConf, this.pulsarProducerConf, this.topic);
        this.latestBatchId_$eq(batchId);
    }

    public PulsarSink(SQLContext sqlContext, Map<String, Object> pulsarClientConf, Map<String, Object> pulsarProducerConf, Option<String> topic) {
        this.sqlContext = sqlContext;
        this.pulsarClientConf = pulsarClientConf;
        this.pulsarProducerConf = pulsarProducerConf;
        this.topic = topic;
        Sink.$init$((Sink)this);
        Logging.$init$((Logging)this);
        this.latestBatchId = -1L;
    }
}

