/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PulsarVersion {
    private static final Pattern majorMinorPatchPattern = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)(.*)");
    private static final Pattern majorMinorPatter = Pattern.compile("([0-9]+)\\.([0-9]+)(.*)");

    static String fixVersionString(String version) {
        if (null == version) {
            return null;
        }
        Matcher majorMinorPatchMatcher = majorMinorPatchPattern.matcher(version);
        if (majorMinorPatchMatcher.matches()) {
            return version;
        }
        Matcher matcher2 = majorMinorPatter.matcher(version);
        if (matcher2.matches()) {
            int startMajorVersion = matcher2.start(1);
            int stopMinorVersion = matcher2.end(2);
            int startReleaseCandidate = matcher2.start(3);
            String prefix = new String(version.getBytes(), startMajorVersion, stopMinorVersion - startMajorVersion);
            String patchVersion = ".0";
            String suffix = new String(version.getBytes(), startReleaseCandidate, version.length() - startReleaseCandidate);
            return prefix + patchVersion + suffix;
        }
        return version;
    }

    public static String getVersion() {
        return PulsarVersion.fixVersionString("3.3.2");
    }

    public static String getGitSha() {
        String commit = "f547100542f2af7d8cd23f4e56269fb3d1f8101e";
        String dirtyString = "false";
        if (commit.contains("git.commit.id")) {
            commit = "";
        }
        if (dirtyString == null || Boolean.valueOf(dirtyString).booleanValue()) {
            return commit + "(dirty)";
        }
        return commit;
    }

    public static String getGitBranch() {
        return "branch-3.3";
    }

    public static String getBuildUser() {
        String email = "lhotari@apache.org";
        String name = "Lari Hotari";
        return String.format("%s <%s>", name, email);
    }

    public static String getBuildHost() {
        return "Laris-MBP.lan";
    }

    public static String getBuildTime() {
        return "2024-10-04T19:05:16+0300";
    }
}

