/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Source;
import org.apache.pulsar.client.admin.Sources;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.admin.internal.http.AsyncHttpRequestExecutor;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.common.policies.data.SourceStatus;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.asynchttpclient.Dsl;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.FilePart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.StringPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourcesImpl
extends ComponentResource
implements Sources,
Source {
    private static final Logger log = LoggerFactory.getLogger(SourcesImpl.class);
    private final WebTarget source;
    private final AsyncHttpRequestExecutor asyncHttpRequestExecutor;

    public SourcesImpl(WebTarget web, Authentication auth, AsyncHttpRequestExecutor asyncHttpRequestExecutor, long requestTimeoutMs) {
        super(auth, requestTimeoutMs);
        this.source = web.path("/admin/v3/source");
        this.asyncHttpRequestExecutor = asyncHttpRequestExecutor;
    }

    @Override
    public List<String> listSources(String tenant, String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.listSourcesAsync(tenant, namespace));
    }

    @Override
    public CompletableFuture<List<String>> listSourcesAsync(String tenant, String namespace) {
        WebTarget path = this.source.path(tenant).path(namespace);
        return this.asyncGetRequest(path, new GenericType<List<String>>(){});
    }

    @Override
    public SourceConfig getSource(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        return (SourceConfig)this.sync(() -> this.getSourceAsync(tenant, namespace, sourceName));
    }

    @Override
    public CompletableFuture<SourceConfig> getSourceAsync(String tenant, String namespace, String sourceName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName);
        return this.asyncGetRequest(path, SourceConfig.class);
    }

    @Override
    public SourceStatus getSourceStatus(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        return (SourceStatus)this.sync(() -> this.getSourceStatusAsync(tenant, namespace, sourceName));
    }

    @Override
    public CompletableFuture<SourceStatus> getSourceStatusAsync(String tenant, String namespace, String sourceName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path("status");
        return this.asyncGetRequest(path, SourceStatus.class);
    }

    @Override
    public SourceStatus.SourceInstanceStatus.SourceInstanceStatusData getSourceStatus(String tenant, String namespace, String sourceName, int id) throws PulsarAdminException {
        return (SourceStatus.SourceInstanceStatus.SourceInstanceStatusData)this.sync(() -> this.getSourceStatusAsync(tenant, namespace, sourceName, id));
    }

    @Override
    public CompletableFuture<SourceStatus.SourceInstanceStatus.SourceInstanceStatusData> getSourceStatusAsync(String tenant, String namespace, String sourceName, int id) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path(Integer.toString(id)).path("status");
        return this.asyncGetRequest(path, SourceStatus.SourceInstanceStatus.SourceInstanceStatusData.class);
    }

    @Override
    public void createSource(SourceConfig sourceConfig, String fileName) throws PulsarAdminException {
        this.sync(() -> this.createSourceAsync(sourceConfig, fileName));
    }

    @Override
    public CompletableFuture<Void> createSourceAsync(SourceConfig sourceConfig, String fileName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.post(this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sourceConfig", this.objectWriter().writeValueAsString(sourceConfig), "application/json"));
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpRequestExecutor.executeRequest(this.addAuthHeaders(this.source, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(SourcesImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(SourcesImpl.getApiException(e));
        }
        return future;
    }

    @Override
    public void createSourceWithUrl(SourceConfig sourceConfig, String pkgUrl) throws PulsarAdminException {
        this.sync(() -> this.createSourceWithUrlAsync(sourceConfig, pkgUrl));
    }

    @Override
    public CompletableFuture<Void> createSourceWithUrlAsync(SourceConfig sourceConfig, String pkgUrl) {
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
        mp.bodyPart(new FormDataBodyPart("sourceConfig", (Object)new Gson().toJson(sourceConfig), MediaType.APPLICATION_JSON_TYPE));
        WebTarget path = this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName());
        return this.asyncPostRequest(path, Entity.entity(mp, "multipart/form-data"));
    }

    @Override
    public void deleteSource(String cluster, String namespace, String function) throws PulsarAdminException {
        this.sync(() -> this.deleteSourceAsync(cluster, namespace, function));
    }

    @Override
    public CompletableFuture<Void> deleteSourceAsync(String tenant, String namespace, String function) {
        WebTarget path = this.source.path(tenant).path(namespace).path(function);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void updateSource(SourceConfig sourceConfig, String fileName, UpdateOptions updateOptions) throws PulsarAdminException {
        this.sync(() -> this.updateSourceAsync(sourceConfig, fileName, updateOptions));
    }

    @Override
    public CompletableFuture<Void> updateSourceAsync(SourceConfig sourceConfig, String fileName, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.put(this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sourceConfig", this.objectWriter().writeValueAsString(sourceConfig), "application/json"));
            UpdateOptionsImpl options = (UpdateOptionsImpl)updateOptions;
            if (options != null) {
                builder.addBodyPart(new StringPart("updateOptions", this.objectWriter().writeValueAsString(options), "application/json"));
            }
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpRequestExecutor.executeRequest(this.addAuthHeaders(this.source, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(SourcesImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(SourcesImpl.getApiException(e));
        }
        return future;
    }

    @Override
    public void updateSource(SourceConfig sourceConfig, String fileName) throws PulsarAdminException {
        this.updateSource(sourceConfig, fileName, null);
    }

    @Override
    public CompletableFuture<Void> updateSourceAsync(SourceConfig sourceConfig, String fileName) {
        return this.updateSourceAsync(sourceConfig, fileName, null);
    }

    @Override
    public void updateSourceWithUrl(SourceConfig sourceConfig, String pkgUrl, UpdateOptions updateOptions) throws PulsarAdminException {
        this.sync(() -> this.updateSourceWithUrlAsync(sourceConfig, pkgUrl, updateOptions));
    }

    @Override
    public CompletableFuture<Void> updateSourceWithUrlAsync(SourceConfig sourceConfig, String pkgUrl, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("sourceConfig", (Object)new Gson().toJson(sourceConfig), MediaType.APPLICATION_JSON_TYPE));
            UpdateOptionsImpl options = (UpdateOptionsImpl)updateOptions;
            if (options != null) {
                mp.bodyPart(new FormDataBodyPart("updateOptions", (Object)this.objectWriter().writeValueAsString(options), MediaType.APPLICATION_JSON_TYPE));
            }
            WebTarget path = this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName());
            return this.asyncPutRequest(path, Entity.entity(mp, "multipart/form-data"));
        }
        catch (Exception e) {
            future.completeExceptionally(SourcesImpl.getApiException(e));
            return future;
        }
    }

    @Override
    public void updateSourceWithUrl(SourceConfig sourceConfig, String pkgUrl) throws PulsarAdminException {
        this.updateSourceWithUrl(sourceConfig, pkgUrl, null);
    }

    @Override
    public CompletableFuture<Void> updateSourceWithUrlAsync(SourceConfig sourceConfig, String pkgUrl) {
        return this.updateSourceWithUrlAsync(sourceConfig, pkgUrl, null);
    }

    @Override
    public void restartSource(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        this.sync(() -> this.restartSourceAsync(tenant, namespace, functionName, instanceId));
    }

    @Override
    public CompletableFuture<Void> restartSourceAsync(String tenant, String namespace, String functionName, int instanceId) {
        WebTarget path = this.source.path(tenant).path(namespace).path(functionName).path(Integer.toString(instanceId)).path("restart");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void restartSource(String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.sync(() -> this.restartSourceAsync(tenant, namespace, functionName));
    }

    @Override
    public CompletableFuture<Void> restartSourceAsync(String tenant, String namespace, String functionName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(functionName).path("restart");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void stopSource(String tenant, String namespace, String sourceName, int instanceId) throws PulsarAdminException {
        this.sync(() -> this.stopSourceAsync(tenant, namespace, sourceName, instanceId));
    }

    @Override
    public CompletableFuture<Void> stopSourceAsync(String tenant, String namespace, String sourceName, int instanceId) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path(Integer.toString(instanceId)).path("stop");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void stopSource(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        this.sync(() -> this.stopSourceAsync(tenant, namespace, sourceName));
    }

    @Override
    public CompletableFuture<Void> stopSourceAsync(String tenant, String namespace, String sourceName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path("stop");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void startSource(String tenant, String namespace, String sourceName, int instanceId) throws PulsarAdminException {
        this.sync(() -> this.startSourceAsync(tenant, namespace, sourceName, instanceId));
    }

    @Override
    public CompletableFuture<Void> startSourceAsync(String tenant, String namespace, String sourceName, int instanceId) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path(Integer.toString(instanceId)).path("start");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void startSource(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        this.sync(() -> this.startSourceAsync(tenant, namespace, sourceName));
    }

    @Override
    public CompletableFuture<Void> startSourceAsync(String tenant, String namespace, String sourceName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path("start");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public List<ConnectorDefinition> getBuiltInSources() throws PulsarAdminException {
        return (List)this.sync(() -> this.getBuiltInSourcesAsync());
    }

    @Override
    public CompletableFuture<List<ConnectorDefinition>> getBuiltInSourcesAsync() {
        WebTarget path = this.source.path("builtinsources");
        CompletableFuture future = new CompletableFuture();
        return this.asyncGetRequest(path, new GenericType<List<ConnectorDefinition>>(){});
    }

    @Override
    public void reloadBuiltInSources() throws PulsarAdminException {
        this.sync(() -> this.reloadBuiltInSourcesAsync());
    }

    @Override
    public CompletableFuture<Void> reloadBuiltInSourcesAsync() {
        WebTarget path = this.source.path("reloadBuiltInSources");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }
}

