/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerStats;
import org.apache.pulsar.client.api.MultiTopicConsumerStats;
import org.apache.pulsar.client.api.ProducerStats;
import org.apache.pulsar.client.impl.ConsumerStatsRecorderImpl;
import org.apache.pulsar.client.impl.PartitionedTopicProducerStatsRecorderImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTopicConsumerStatsRecorderImpl
extends ConsumerStatsRecorderImpl
implements MultiTopicConsumerStats {
    private static final long serialVersionUID = 1L;
    private Map<String, ConsumerStats> partitionStats = new ConcurrentHashMap<String, ConsumerStats>();
    private PartitionedTopicProducerStatsRecorderImpl deadLetterStats = new PartitionedTopicProducerStatsRecorderImpl();
    private PartitionedTopicProducerStatsRecorderImpl retryLetterStats = new PartitionedTopicProducerStatsRecorderImpl();
    private static final Logger log = LoggerFactory.getLogger(MultiTopicConsumerStatsRecorderImpl.class);

    public MultiTopicConsumerStatsRecorderImpl() {
    }

    public MultiTopicConsumerStatsRecorderImpl(Consumer<?> consumer) {
        super(consumer);
    }

    public MultiTopicConsumerStatsRecorderImpl(PulsarClientImpl pulsarClient, ConsumerConfigurationData<?> conf, Consumer<?> consumer) {
        super(pulsarClient, conf, consumer);
    }

    public void updateCumulativeStats(String partition, ConsumerStats stats) {
        super.updateCumulativeStats(stats);
        this.partitionStats.put(partition, stats);
    }

    @Override
    public Map<String, ConsumerStats> getPartitionStats() {
        return this.partitionStats;
    }

    @Override
    public ProducerStats getDeadLetterProducerStats() {
        this.deadLetterStats.reset();
        this.partitionStats.forEach((partition, consumerStats) -> this.deadLetterStats.updateCumulativeStats((String)partition, consumerStats.getDeadLetterProducerStats()));
        return this.deadLetterStats;
    }

    @Override
    public ProducerStats getRetryLetterProducerStats() {
        this.retryLetterStats.reset();
        this.partitionStats.forEach((partition, consumerStats) -> this.retryLetterStats.updateCumulativeStats((String)partition, consumerStats.getRetryLetterProducerStats()));
        return this.retryLetterStats;
    }
}

