/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.BatchReceivePolicy;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ConsumerEventListener;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.MessagePayloadProcessor;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.conf.TopicConsumerConfigurationData;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Sets;

public class ConsumerConfigurationData<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(name="topicNames", required=true, value="Topic name")
    private Set<String> topicNames = new TreeSet<String>();
    @ApiModelProperty(name="topicsPattern", value="The regexp for the topic name(not contains partition suffix).")
    private Pattern topicsPattern;
    @ApiModelProperty(name="subscriptionName", value="Subscription name")
    private String subscriptionName;
    @ApiModelProperty(name="subscriptionType", value="Subscription type.\nFour subscription types are available:\n* Exclusive\n* Failover\n* Shared\n* Key_Shared")
    private SubscriptionType subscriptionType = SubscriptionType.Exclusive;
    private Map<String, String> subscriptionProperties;
    private SubscriptionMode subscriptionMode = SubscriptionMode.Durable;
    @JsonIgnore
    private MessageListener<T> messageListener;
    @JsonIgnore
    private ConsumerEventListener consumerEventListener;
    @ApiModelProperty(name="negativeAckRedeliveryBackoff", value="Interface for custom message is negativeAcked policy. You can specify `RedeliveryBackoff` for a consumer.")
    @JsonIgnore
    private RedeliveryBackoff negativeAckRedeliveryBackoff;
    @ApiModelProperty(name="ackTimeoutRedeliveryBackoff", value="Interface for custom message is ackTimeout policy. You can specify `RedeliveryBackoff` for a consumer.")
    @JsonIgnore
    private RedeliveryBackoff ackTimeoutRedeliveryBackoff;
    @ApiModelProperty(name="receiverQueueSize", value="Size of a consumer's receiver queue.\n\nFor example, the number of messages accumulated by a consumer before an application calls `Receive`.\n\nA value higher than the default value increases consumer throughput, though at the expense of more memory utilization.")
    private int receiverQueueSize = 1000;
    @ApiModelProperty(name="acknowledgementsGroupTimeMicros", value="Group a consumer acknowledgment for a specified time.\n\nBy default, a consumer uses 100ms grouping time to send out acknowledgments to a broker.\n\nSetting a group time of 0 sends out acknowledgments immediately.\n\nA longer ack group time is more efficient at the expense of a slight increase in message re-deliveries after a failure.")
    private long acknowledgementsGroupTimeMicros = TimeUnit.MILLISECONDS.toMicros(100L);
    @ApiModelProperty(name="maxAcknowledgmentGroupSize", value="Group a consumer acknowledgment for the number of messages.")
    private int maxAcknowledgmentGroupSize = 1000;
    @ApiModelProperty(name="negativeAckRedeliveryDelayMicros", value="Delay to wait before redelivering messages that failed to be processed.\n\nWhen an application uses {@link Consumer#negativeAcknowledge(Message)}, failed messages are redelivered after a fixed timeout.")
    private long negativeAckRedeliveryDelayMicros = TimeUnit.MINUTES.toMicros(1L);
    @ApiModelProperty(name="maxTotalReceiverQueueSizeAcrossPartitions", value="The max total receiver queue size across partitions.\n\nThis setting reduces the receiver queue size for individual partitions if the total receiver queue size exceeds this value.")
    private int maxTotalReceiverQueueSizeAcrossPartitions = 50000;
    @ApiModelProperty(name="consumerName", value="Consumer name")
    private String consumerName = null;
    @ApiModelProperty(name="ackTimeoutMillis", value="Timeout of unacked messages")
    private long ackTimeoutMillis = 0L;
    @ApiModelProperty(name="tickDurationMillis", value="Granularity of the ack-timeout redelivery.\n\nUsing an higher `tickDurationMillis` reduces the memory overhead to track messages when setting ack-timeout to a bigger value (for example, 1 hour).")
    private long tickDurationMillis = 1000L;
    @ApiModelProperty(name="priorityLevel", value="Priority level for a consumer to which a broker gives more priority while dispatching messages in Shared subscription type.\n\nThe broker follows descending priorities. For example, 0=max-priority, 1, 2,...\n\nIn Shared subscription type, the broker **first dispatches messages to the max priority level consumers if they have permits**. Otherwise, the broker considers next priority level consumers.\n\n**Example 1**\nIf a subscription has consumerA with `priorityLevel` 0 and consumerB with `priorityLevel` 1, then the broker **only dispatches messages to consumerA until it runs out permits** and then starts dispatching messages to consumerB.\n\n**Example 2**\nConsumer Priority, Level, Permits\nC1, 0, 2\nC2, 0, 1\nC3, 0, 1\nC4, 1, 2\nC5, 1, 1\n\nOrder in which a broker dispatches messages to consumers is: C1, C2, C3, C1, C4, C5, C4.")
    private int priorityLevel = 0;
    @ApiModelProperty(name="maxPendingChunkedMessage", value="The maximum size of a queue holding pending chunked messages. When the threshold is reached, the consumer drops pending messages to optimize memory utilization.")
    private int maxPendingChunkedMessage = 10;
    @ApiModelProperty(name="autoAckOldestChunkedMessageOnQueueFull", value="Whether to automatically acknowledge pending chunked messages when the threshold of `maxPendingChunkedMessage` is reached. If set to `false`, these messages will be redelivered by their broker.")
    private boolean autoAckOldestChunkedMessageOnQueueFull = false;
    @ApiModelProperty(name="expireTimeOfIncompleteChunkedMessageMillis", value="The time interval to expire incomplete chunks if a consumer fails to receive all the chunks in the specified time period. The default value is 1 minute.")
    private long expireTimeOfIncompleteChunkedMessageMillis = TimeUnit.MINUTES.toMillis(1L);
    @JsonIgnore
    private CryptoKeyReader cryptoKeyReader = null;
    @JsonIgnore
    private transient MessageCrypto messageCrypto = null;
    @ApiModelProperty(name="cryptoFailureAction", value="Consumer should take action when it receives a message that can not be decrypted.\n* **FAIL**: this is the default option to fail messages until crypto succeeds.\n* **DISCARD**:silently acknowledge and not deliver message to an application.\n* **CONSUME**: deliver encrypted messages to applications. It is the application's responsibility to decrypt the message.\n\nThe decompression of message fails.\n\nIf messages contain batch messages, a client is not be able to retrieve individual messages in batch.\n\nDelivered encrypted message contains {@link EncryptionContext} which contains encryption and compression information in it using which application can decrypt consumed message payload.")
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    @ApiModelProperty(name="properties", value="A name or value property of this consumer.\n\n`properties` is application defined metadata attached to a consumer.\n\nWhen getting a topic stats, associate this metadata with the consumer stats for easier identification.")
    private SortedMap<String, String> properties = new TreeMap<String, String>();
    @ApiModelProperty(name="readCompacted", value="If enabling `readCompacted`, a consumer reads messages from a compacted topic rather than reading a full message backlog of a topic.\n\nA consumer only sees the latest value for each key in the compacted topic, up until reaching the point in the topic message when compacting backlog. Beyond that point, send messages as normal.\n\nOnly enabling `readCompacted` on subscriptions to persistent topics, which have a single active consumer (like failure or exclusive subscriptions).\n\nAttempting to enable it on subscriptions to non-persistent topics or on shared subscriptions leads to a subscription call throwing a `PulsarClientException`.")
    private boolean readCompacted = false;
    @ApiModelProperty(name="subscriptionInitialPosition", value="Initial position at which to set cursor when subscribing to a topic at first time.")
    private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Latest;
    @ApiModelProperty(name="patternAutoDiscoveryPeriod", value="Topic auto discovery period when using a pattern for topic's consumer.\n\nThe default and minimum value is 1 minute.")
    private int patternAutoDiscoveryPeriod = 60;
    @ApiModelProperty(name="regexSubscriptionMode", value="When subscribing to a topic using a regular expression, you can pick a certain type of topics.\n\n* **PersistentOnly**: only subscribe to persistent topics.\n* **NonPersistentOnly**: only subscribe to non-persistent topics.\n* **AllTopics**: subscribe to both persistent and non-persistent topics.")
    private RegexSubscriptionMode regexSubscriptionMode = RegexSubscriptionMode.PersistentOnly;
    @ApiModelProperty(name="deadLetterPolicy", value="Dead letter policy for consumers.\n\nBy default, some messages are probably redelivered many times, even to the extent that it never stops.\n\nBy using the dead letter mechanism, messages have the max redelivery count. **When exceeding the maximum number of redeliveries, messages are sent to the Dead Letter Topic and acknowledged automatically**.\n\nYou can enable the dead letter mechanism by setting `deadLetterPolicy`.\n\n**Example**\n```java\nclient.newConsumer()\n.deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(10).build())\n.subscribe();\n```\nDefault dead letter topic name is `{TopicName}-{Subscription}-DLQ`.\n\nTo set a custom dead letter topic name:\n```java\nclient.newConsumer()\n.deadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(10)\n.deadLetterTopic(\"your-topic-name\").build())\n.subscribe();\n```\nWhen specifying the dead letter policy while not specifying `ackTimeoutMillis`, you can set the ack timeout to 30000 millisecond.")
    private transient DeadLetterPolicy deadLetterPolicy;
    private boolean retryEnable = false;
    @JsonIgnore
    private BatchReceivePolicy batchReceivePolicy;
    @ApiModelProperty(name="autoUpdatePartitions", value="If `autoUpdatePartitions` is enabled, a consumer subscribes to partition increasement automatically.\n\n**Note**: this is only for partitioned consumers.")
    private boolean autoUpdatePartitions = true;
    private long autoUpdatePartitionsIntervalSeconds = 60L;
    @ApiModelProperty(name="replicateSubscriptionState", value="If `replicateSubscriptionState` is enabled, a subscription state is replicated to geo-replicated clusters.")
    private boolean replicateSubscriptionState = false;
    private boolean resetIncludeHead = false;
    @JsonIgnore
    private transient KeySharedPolicy keySharedPolicy;
    private boolean batchIndexAckEnabled = false;
    private boolean ackReceiptEnabled = false;
    private boolean poolMessages = false;
    @JsonIgnore
    private transient MessagePayloadProcessor payloadProcessor = null;
    private boolean startPaused = false;
    private boolean autoScaledReceiverQueueSizeEnabled = false;
    private List<TopicConsumerConfigurationData> topicConfigurations = new ArrayList<TopicConsumerConfigurationData>();

    @Deprecated
    public void setMaxPendingChuckedMessage(int maxPendingChuckedMessage) {
        this.maxPendingChunkedMessage = maxPendingChuckedMessage;
    }

    @Deprecated
    public int getMaxPendingChuckedMessage() {
        return this.maxPendingChunkedMessage;
    }

    public TopicConsumerConfigurationData getMatchingTopicConfiguration(String topicName) {
        return this.topicConfigurations.stream().filter(topicConf -> topicConf.getTopicNameMatcher().matches(topicName)).findFirst().orElseGet(() -> TopicConsumerConfigurationData.ofTopicName(topicName, this));
    }

    public void setTopicConfigurations(List<TopicConsumerConfigurationData> topicConfigurations) {
        Preconditions.checkArgument(topicConfigurations != null, "topicConfigurations should not be null.");
        this.topicConfigurations = topicConfigurations;
    }

    public void setAutoUpdatePartitionsIntervalSeconds(int interval, TimeUnit timeUnit) {
        Preconditions.checkArgument(interval > 0, "interval needs to be > 0");
        this.autoUpdatePartitionsIntervalSeconds = timeUnit.toSeconds(interval);
    }

    @JsonIgnore
    public String getSingleTopic() {
        Preconditions.checkArgument(this.topicNames.size() == 1, "topicNames needs to be = 1");
        return this.topicNames.iterator().next();
    }

    public ConsumerConfigurationData<T> clone() {
        try {
            ConsumerConfigurationData c = (ConsumerConfigurationData)super.clone();
            c.topicNames = Sets.newTreeSet(this.topicNames);
            c.properties = new TreeMap<String, String>(this.properties);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ConsumerConfigurationData");
        }
    }

    public Set<String> getTopicNames() {
        return this.topicNames;
    }

    public Pattern getTopicsPattern() {
        return this.topicsPattern;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public Map<String, String> getSubscriptionProperties() {
        return this.subscriptionProperties;
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public MessageListener<T> getMessageListener() {
        return this.messageListener;
    }

    public ConsumerEventListener getConsumerEventListener() {
        return this.consumerEventListener;
    }

    public RedeliveryBackoff getNegativeAckRedeliveryBackoff() {
        return this.negativeAckRedeliveryBackoff;
    }

    public RedeliveryBackoff getAckTimeoutRedeliveryBackoff() {
        return this.ackTimeoutRedeliveryBackoff;
    }

    public int getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public long getAcknowledgementsGroupTimeMicros() {
        return this.acknowledgementsGroupTimeMicros;
    }

    public int getMaxAcknowledgmentGroupSize() {
        return this.maxAcknowledgmentGroupSize;
    }

    public long getNegativeAckRedeliveryDelayMicros() {
        return this.negativeAckRedeliveryDelayMicros;
    }

    public int getMaxTotalReceiverQueueSizeAcrossPartitions() {
        return this.maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public long getAckTimeoutMillis() {
        return this.ackTimeoutMillis;
    }

    public long getTickDurationMillis() {
        return this.tickDurationMillis;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public int getMaxPendingChunkedMessage() {
        return this.maxPendingChunkedMessage;
    }

    public boolean isAutoAckOldestChunkedMessageOnQueueFull() {
        return this.autoAckOldestChunkedMessageOnQueueFull;
    }

    public long getExpireTimeOfIncompleteChunkedMessageMillis() {
        return this.expireTimeOfIncompleteChunkedMessageMillis;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public MessageCrypto getMessageCrypto() {
        return this.messageCrypto;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    public SubscriptionInitialPosition getSubscriptionInitialPosition() {
        return this.subscriptionInitialPosition;
    }

    public int getPatternAutoDiscoveryPeriod() {
        return this.patternAutoDiscoveryPeriod;
    }

    public RegexSubscriptionMode getRegexSubscriptionMode() {
        return this.regexSubscriptionMode;
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public boolean isRetryEnable() {
        return this.retryEnable;
    }

    public BatchReceivePolicy getBatchReceivePolicy() {
        return this.batchReceivePolicy;
    }

    public boolean isAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    public long getAutoUpdatePartitionsIntervalSeconds() {
        return this.autoUpdatePartitionsIntervalSeconds;
    }

    public boolean isReplicateSubscriptionState() {
        return this.replicateSubscriptionState;
    }

    public boolean isResetIncludeHead() {
        return this.resetIncludeHead;
    }

    public KeySharedPolicy getKeySharedPolicy() {
        return this.keySharedPolicy;
    }

    public boolean isBatchIndexAckEnabled() {
        return this.batchIndexAckEnabled;
    }

    public boolean isAckReceiptEnabled() {
        return this.ackReceiptEnabled;
    }

    public boolean isPoolMessages() {
        return this.poolMessages;
    }

    public MessagePayloadProcessor getPayloadProcessor() {
        return this.payloadProcessor;
    }

    public boolean isStartPaused() {
        return this.startPaused;
    }

    public boolean isAutoScaledReceiverQueueSizeEnabled() {
        return this.autoScaledReceiverQueueSizeEnabled;
    }

    public List<TopicConsumerConfigurationData> getTopicConfigurations() {
        return this.topicConfigurations;
    }

    public void setTopicNames(Set<String> topicNames) {
        this.topicNames = topicNames;
    }

    public void setTopicsPattern(Pattern topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public void setSubscriptionProperties(Map<String, String> subscriptionProperties) {
        this.subscriptionProperties = subscriptionProperties;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    @JsonIgnore
    public void setMessageListener(MessageListener<T> messageListener) {
        this.messageListener = messageListener;
    }

    @JsonIgnore
    public void setConsumerEventListener(ConsumerEventListener consumerEventListener) {
        this.consumerEventListener = consumerEventListener;
    }

    @JsonIgnore
    public void setNegativeAckRedeliveryBackoff(RedeliveryBackoff negativeAckRedeliveryBackoff) {
        this.negativeAckRedeliveryBackoff = negativeAckRedeliveryBackoff;
    }

    @JsonIgnore
    public void setAckTimeoutRedeliveryBackoff(RedeliveryBackoff ackTimeoutRedeliveryBackoff) {
        this.ackTimeoutRedeliveryBackoff = ackTimeoutRedeliveryBackoff;
    }

    public void setReceiverQueueSize(int receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
    }

    public void setAcknowledgementsGroupTimeMicros(long acknowledgementsGroupTimeMicros) {
        this.acknowledgementsGroupTimeMicros = acknowledgementsGroupTimeMicros;
    }

    public void setMaxAcknowledgmentGroupSize(int maxAcknowledgmentGroupSize) {
        this.maxAcknowledgmentGroupSize = maxAcknowledgmentGroupSize;
    }

    public void setNegativeAckRedeliveryDelayMicros(long negativeAckRedeliveryDelayMicros) {
        this.negativeAckRedeliveryDelayMicros = negativeAckRedeliveryDelayMicros;
    }

    public void setMaxTotalReceiverQueueSizeAcrossPartitions(int maxTotalReceiverQueueSizeAcrossPartitions) {
        this.maxTotalReceiverQueueSizeAcrossPartitions = maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public void setAckTimeoutMillis(long ackTimeoutMillis) {
        this.ackTimeoutMillis = ackTimeoutMillis;
    }

    public void setTickDurationMillis(long tickDurationMillis) {
        this.tickDurationMillis = tickDurationMillis;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.priorityLevel = priorityLevel;
    }

    public void setMaxPendingChunkedMessage(int maxPendingChunkedMessage) {
        this.maxPendingChunkedMessage = maxPendingChunkedMessage;
    }

    public void setAutoAckOldestChunkedMessageOnQueueFull(boolean autoAckOldestChunkedMessageOnQueueFull) {
        this.autoAckOldestChunkedMessageOnQueueFull = autoAckOldestChunkedMessageOnQueueFull;
    }

    public void setExpireTimeOfIncompleteChunkedMessageMillis(long expireTimeOfIncompleteChunkedMessageMillis) {
        this.expireTimeOfIncompleteChunkedMessageMillis = expireTimeOfIncompleteChunkedMessageMillis;
    }

    @JsonIgnore
    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    @JsonIgnore
    public void setMessageCrypto(MessageCrypto messageCrypto) {
        this.messageCrypto = messageCrypto;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public void setProperties(SortedMap<String, String> properties) {
        this.properties = properties;
    }

    public void setReadCompacted(boolean readCompacted) {
        this.readCompacted = readCompacted;
    }

    public void setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.subscriptionInitialPosition = subscriptionInitialPosition;
    }

    public void setPatternAutoDiscoveryPeriod(int patternAutoDiscoveryPeriod) {
        this.patternAutoDiscoveryPeriod = patternAutoDiscoveryPeriod;
    }

    public void setRegexSubscriptionMode(RegexSubscriptionMode regexSubscriptionMode) {
        this.regexSubscriptionMode = regexSubscriptionMode;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public void setRetryEnable(boolean retryEnable) {
        this.retryEnable = retryEnable;
    }

    @JsonIgnore
    public void setBatchReceivePolicy(BatchReceivePolicy batchReceivePolicy) {
        this.batchReceivePolicy = batchReceivePolicy;
    }

    public void setAutoUpdatePartitions(boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    public void setAutoUpdatePartitionsIntervalSeconds(long autoUpdatePartitionsIntervalSeconds) {
        this.autoUpdatePartitionsIntervalSeconds = autoUpdatePartitionsIntervalSeconds;
    }

    public void setReplicateSubscriptionState(boolean replicateSubscriptionState) {
        this.replicateSubscriptionState = replicateSubscriptionState;
    }

    public void setResetIncludeHead(boolean resetIncludeHead) {
        this.resetIncludeHead = resetIncludeHead;
    }

    @JsonIgnore
    public void setKeySharedPolicy(KeySharedPolicy keySharedPolicy) {
        this.keySharedPolicy = keySharedPolicy;
    }

    public void setBatchIndexAckEnabled(boolean batchIndexAckEnabled) {
        this.batchIndexAckEnabled = batchIndexAckEnabled;
    }

    public void setAckReceiptEnabled(boolean ackReceiptEnabled) {
        this.ackReceiptEnabled = ackReceiptEnabled;
    }

    public void setPoolMessages(boolean poolMessages) {
        this.poolMessages = poolMessages;
    }

    @JsonIgnore
    public void setPayloadProcessor(MessagePayloadProcessor payloadProcessor) {
        this.payloadProcessor = payloadProcessor;
    }

    public void setStartPaused(boolean startPaused) {
        this.startPaused = startPaused;
    }

    public void setAutoScaledReceiverQueueSizeEnabled(boolean autoScaledReceiverQueueSizeEnabled) {
        this.autoScaledReceiverQueueSizeEnabled = autoScaledReceiverQueueSizeEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerConfigurationData)) {
            return false;
        }
        ConsumerConfigurationData other = (ConsumerConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReceiverQueueSize() != other.getReceiverQueueSize()) {
            return false;
        }
        if (this.getAcknowledgementsGroupTimeMicros() != other.getAcknowledgementsGroupTimeMicros()) {
            return false;
        }
        if (this.getMaxAcknowledgmentGroupSize() != other.getMaxAcknowledgmentGroupSize()) {
            return false;
        }
        if (this.getNegativeAckRedeliveryDelayMicros() != other.getNegativeAckRedeliveryDelayMicros()) {
            return false;
        }
        if (this.getMaxTotalReceiverQueueSizeAcrossPartitions() != other.getMaxTotalReceiverQueueSizeAcrossPartitions()) {
            return false;
        }
        if (this.getAckTimeoutMillis() != other.getAckTimeoutMillis()) {
            return false;
        }
        if (this.getTickDurationMillis() != other.getTickDurationMillis()) {
            return false;
        }
        if (this.getPriorityLevel() != other.getPriorityLevel()) {
            return false;
        }
        if (this.getMaxPendingChunkedMessage() != other.getMaxPendingChunkedMessage()) {
            return false;
        }
        if (this.isAutoAckOldestChunkedMessageOnQueueFull() != other.isAutoAckOldestChunkedMessageOnQueueFull()) {
            return false;
        }
        if (this.getExpireTimeOfIncompleteChunkedMessageMillis() != other.getExpireTimeOfIncompleteChunkedMessageMillis()) {
            return false;
        }
        if (this.isReadCompacted() != other.isReadCompacted()) {
            return false;
        }
        if (this.getPatternAutoDiscoveryPeriod() != other.getPatternAutoDiscoveryPeriod()) {
            return false;
        }
        if (this.isRetryEnable() != other.isRetryEnable()) {
            return false;
        }
        if (this.isAutoUpdatePartitions() != other.isAutoUpdatePartitions()) {
            return false;
        }
        if (this.getAutoUpdatePartitionsIntervalSeconds() != other.getAutoUpdatePartitionsIntervalSeconds()) {
            return false;
        }
        if (this.isReplicateSubscriptionState() != other.isReplicateSubscriptionState()) {
            return false;
        }
        if (this.isResetIncludeHead() != other.isResetIncludeHead()) {
            return false;
        }
        if (this.isBatchIndexAckEnabled() != other.isBatchIndexAckEnabled()) {
            return false;
        }
        if (this.isAckReceiptEnabled() != other.isAckReceiptEnabled()) {
            return false;
        }
        if (this.isPoolMessages() != other.isPoolMessages()) {
            return false;
        }
        if (this.isStartPaused() != other.isStartPaused()) {
            return false;
        }
        if (this.isAutoScaledReceiverQueueSizeEnabled() != other.isAutoScaledReceiverQueueSizeEnabled()) {
            return false;
        }
        Set<String> this$topicNames = this.getTopicNames();
        Set<String> other$topicNames = other.getTopicNames();
        if (this$topicNames == null ? other$topicNames != null : !((Object)this$topicNames).equals(other$topicNames)) {
            return false;
        }
        Pattern this$topicsPattern = this.getTopicsPattern();
        Pattern other$topicsPattern = other.getTopicsPattern();
        if (this$topicsPattern == null ? other$topicsPattern != null : !this$topicsPattern.equals(other$topicsPattern)) {
            return false;
        }
        String this$subscriptionName = this.getSubscriptionName();
        String other$subscriptionName = other.getSubscriptionName();
        if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
            return false;
        }
        SubscriptionType this$subscriptionType = this.getSubscriptionType();
        SubscriptionType other$subscriptionType = other.getSubscriptionType();
        if (this$subscriptionType == null ? other$subscriptionType != null : !((Object)((Object)this$subscriptionType)).equals((Object)other$subscriptionType)) {
            return false;
        }
        Map<String, String> this$subscriptionProperties = this.getSubscriptionProperties();
        Map<String, String> other$subscriptionProperties = other.getSubscriptionProperties();
        if (this$subscriptionProperties == null ? other$subscriptionProperties != null : !((Object)this$subscriptionProperties).equals(other$subscriptionProperties)) {
            return false;
        }
        SubscriptionMode this$subscriptionMode = this.getSubscriptionMode();
        SubscriptionMode other$subscriptionMode = other.getSubscriptionMode();
        if (this$subscriptionMode == null ? other$subscriptionMode != null : !((Object)((Object)this$subscriptionMode)).equals((Object)other$subscriptionMode)) {
            return false;
        }
        MessageListener<T> this$messageListener = this.getMessageListener();
        MessageListener<T> other$messageListener = other.getMessageListener();
        if (this$messageListener == null ? other$messageListener != null : !this$messageListener.equals(other$messageListener)) {
            return false;
        }
        ConsumerEventListener this$consumerEventListener = this.getConsumerEventListener();
        ConsumerEventListener other$consumerEventListener = other.getConsumerEventListener();
        if (this$consumerEventListener == null ? other$consumerEventListener != null : !this$consumerEventListener.equals(other$consumerEventListener)) {
            return false;
        }
        RedeliveryBackoff this$negativeAckRedeliveryBackoff = this.getNegativeAckRedeliveryBackoff();
        RedeliveryBackoff other$negativeAckRedeliveryBackoff = other.getNegativeAckRedeliveryBackoff();
        if (this$negativeAckRedeliveryBackoff == null ? other$negativeAckRedeliveryBackoff != null : !this$negativeAckRedeliveryBackoff.equals(other$negativeAckRedeliveryBackoff)) {
            return false;
        }
        RedeliveryBackoff this$ackTimeoutRedeliveryBackoff = this.getAckTimeoutRedeliveryBackoff();
        RedeliveryBackoff other$ackTimeoutRedeliveryBackoff = other.getAckTimeoutRedeliveryBackoff();
        if (this$ackTimeoutRedeliveryBackoff == null ? other$ackTimeoutRedeliveryBackoff != null : !this$ackTimeoutRedeliveryBackoff.equals(other$ackTimeoutRedeliveryBackoff)) {
            return false;
        }
        String this$consumerName = this.getConsumerName();
        String other$consumerName = other.getConsumerName();
        if (this$consumerName == null ? other$consumerName != null : !this$consumerName.equals(other$consumerName)) {
            return false;
        }
        CryptoKeyReader this$cryptoKeyReader = this.getCryptoKeyReader();
        CryptoKeyReader other$cryptoKeyReader = other.getCryptoKeyReader();
        if (this$cryptoKeyReader == null ? other$cryptoKeyReader != null : !this$cryptoKeyReader.equals(other$cryptoKeyReader)) {
            return false;
        }
        ConsumerCryptoFailureAction this$cryptoFailureAction = this.getCryptoFailureAction();
        ConsumerCryptoFailureAction other$cryptoFailureAction = other.getCryptoFailureAction();
        if (this$cryptoFailureAction == null ? other$cryptoFailureAction != null : !((Object)((Object)this$cryptoFailureAction)).equals((Object)other$cryptoFailureAction)) {
            return false;
        }
        SortedMap<String, String> this$properties = this.getProperties();
        SortedMap<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        SubscriptionInitialPosition this$subscriptionInitialPosition = this.getSubscriptionInitialPosition();
        SubscriptionInitialPosition other$subscriptionInitialPosition = other.getSubscriptionInitialPosition();
        if (this$subscriptionInitialPosition == null ? other$subscriptionInitialPosition != null : !((Object)((Object)this$subscriptionInitialPosition)).equals((Object)other$subscriptionInitialPosition)) {
            return false;
        }
        RegexSubscriptionMode this$regexSubscriptionMode = this.getRegexSubscriptionMode();
        RegexSubscriptionMode other$regexSubscriptionMode = other.getRegexSubscriptionMode();
        if (this$regexSubscriptionMode == null ? other$regexSubscriptionMode != null : !((Object)((Object)this$regexSubscriptionMode)).equals((Object)other$regexSubscriptionMode)) {
            return false;
        }
        BatchReceivePolicy this$batchReceivePolicy = this.getBatchReceivePolicy();
        BatchReceivePolicy other$batchReceivePolicy = other.getBatchReceivePolicy();
        if (this$batchReceivePolicy == null ? other$batchReceivePolicy != null : !this$batchReceivePolicy.equals(other$batchReceivePolicy)) {
            return false;
        }
        List<TopicConsumerConfigurationData> this$topicConfigurations = this.getTopicConfigurations();
        List<TopicConsumerConfigurationData> other$topicConfigurations = other.getTopicConfigurations();
        return !(this$topicConfigurations == null ? other$topicConfigurations != null : !((Object)this$topicConfigurations).equals(other$topicConfigurations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsumerConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReceiverQueueSize();
        long $acknowledgementsGroupTimeMicros = this.getAcknowledgementsGroupTimeMicros();
        result = result * 59 + (int)($acknowledgementsGroupTimeMicros >>> 32 ^ $acknowledgementsGroupTimeMicros);
        result = result * 59 + this.getMaxAcknowledgmentGroupSize();
        long $negativeAckRedeliveryDelayMicros = this.getNegativeAckRedeliveryDelayMicros();
        result = result * 59 + (int)($negativeAckRedeliveryDelayMicros >>> 32 ^ $negativeAckRedeliveryDelayMicros);
        result = result * 59 + this.getMaxTotalReceiverQueueSizeAcrossPartitions();
        long $ackTimeoutMillis = this.getAckTimeoutMillis();
        result = result * 59 + (int)($ackTimeoutMillis >>> 32 ^ $ackTimeoutMillis);
        long $tickDurationMillis = this.getTickDurationMillis();
        result = result * 59 + (int)($tickDurationMillis >>> 32 ^ $tickDurationMillis);
        result = result * 59 + this.getPriorityLevel();
        result = result * 59 + this.getMaxPendingChunkedMessage();
        result = result * 59 + (this.isAutoAckOldestChunkedMessageOnQueueFull() ? 79 : 97);
        long $expireTimeOfIncompleteChunkedMessageMillis = this.getExpireTimeOfIncompleteChunkedMessageMillis();
        result = result * 59 + (int)($expireTimeOfIncompleteChunkedMessageMillis >>> 32 ^ $expireTimeOfIncompleteChunkedMessageMillis);
        result = result * 59 + (this.isReadCompacted() ? 79 : 97);
        result = result * 59 + this.getPatternAutoDiscoveryPeriod();
        result = result * 59 + (this.isRetryEnable() ? 79 : 97);
        result = result * 59 + (this.isAutoUpdatePartitions() ? 79 : 97);
        long $autoUpdatePartitionsIntervalSeconds = this.getAutoUpdatePartitionsIntervalSeconds();
        result = result * 59 + (int)($autoUpdatePartitionsIntervalSeconds >>> 32 ^ $autoUpdatePartitionsIntervalSeconds);
        result = result * 59 + (this.isReplicateSubscriptionState() ? 79 : 97);
        result = result * 59 + (this.isResetIncludeHead() ? 79 : 97);
        result = result * 59 + (this.isBatchIndexAckEnabled() ? 79 : 97);
        result = result * 59 + (this.isAckReceiptEnabled() ? 79 : 97);
        result = result * 59 + (this.isPoolMessages() ? 79 : 97);
        result = result * 59 + (this.isStartPaused() ? 79 : 97);
        result = result * 59 + (this.isAutoScaledReceiverQueueSizeEnabled() ? 79 : 97);
        Set<String> $topicNames = this.getTopicNames();
        result = result * 59 + ($topicNames == null ? 43 : ((Object)$topicNames).hashCode());
        Pattern $topicsPattern = this.getTopicsPattern();
        result = result * 59 + ($topicsPattern == null ? 43 : $topicsPattern.hashCode());
        String $subscriptionName = this.getSubscriptionName();
        result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
        SubscriptionType $subscriptionType = this.getSubscriptionType();
        result = result * 59 + ($subscriptionType == null ? 43 : ((Object)((Object)$subscriptionType)).hashCode());
        Map<String, String> $subscriptionProperties = this.getSubscriptionProperties();
        result = result * 59 + ($subscriptionProperties == null ? 43 : ((Object)$subscriptionProperties).hashCode());
        SubscriptionMode $subscriptionMode = this.getSubscriptionMode();
        result = result * 59 + ($subscriptionMode == null ? 43 : ((Object)((Object)$subscriptionMode)).hashCode());
        MessageListener<T> $messageListener = this.getMessageListener();
        result = result * 59 + ($messageListener == null ? 43 : $messageListener.hashCode());
        ConsumerEventListener $consumerEventListener = this.getConsumerEventListener();
        result = result * 59 + ($consumerEventListener == null ? 43 : $consumerEventListener.hashCode());
        RedeliveryBackoff $negativeAckRedeliveryBackoff = this.getNegativeAckRedeliveryBackoff();
        result = result * 59 + ($negativeAckRedeliveryBackoff == null ? 43 : $negativeAckRedeliveryBackoff.hashCode());
        RedeliveryBackoff $ackTimeoutRedeliveryBackoff = this.getAckTimeoutRedeliveryBackoff();
        result = result * 59 + ($ackTimeoutRedeliveryBackoff == null ? 43 : $ackTimeoutRedeliveryBackoff.hashCode());
        String $consumerName = this.getConsumerName();
        result = result * 59 + ($consumerName == null ? 43 : $consumerName.hashCode());
        CryptoKeyReader $cryptoKeyReader = this.getCryptoKeyReader();
        result = result * 59 + ($cryptoKeyReader == null ? 43 : $cryptoKeyReader.hashCode());
        ConsumerCryptoFailureAction $cryptoFailureAction = this.getCryptoFailureAction();
        result = result * 59 + ($cryptoFailureAction == null ? 43 : ((Object)((Object)$cryptoFailureAction)).hashCode());
        SortedMap<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        SubscriptionInitialPosition $subscriptionInitialPosition = this.getSubscriptionInitialPosition();
        result = result * 59 + ($subscriptionInitialPosition == null ? 43 : ((Object)((Object)$subscriptionInitialPosition)).hashCode());
        RegexSubscriptionMode $regexSubscriptionMode = this.getRegexSubscriptionMode();
        result = result * 59 + ($regexSubscriptionMode == null ? 43 : ((Object)((Object)$regexSubscriptionMode)).hashCode());
        BatchReceivePolicy $batchReceivePolicy = this.getBatchReceivePolicy();
        result = result * 59 + ($batchReceivePolicy == null ? 43 : $batchReceivePolicy.hashCode());
        List<TopicConsumerConfigurationData> $topicConfigurations = this.getTopicConfigurations();
        result = result * 59 + ($topicConfigurations == null ? 43 : ((Object)$topicConfigurations).hashCode());
        return result;
    }

    public String toString() {
        return "ConsumerConfigurationData(topicNames=" + this.getTopicNames() + ", topicsPattern=" + this.getTopicsPattern() + ", subscriptionName=" + this.getSubscriptionName() + ", subscriptionType=" + (Object)((Object)this.getSubscriptionType()) + ", subscriptionProperties=" + this.getSubscriptionProperties() + ", subscriptionMode=" + (Object)((Object)this.getSubscriptionMode()) + ", messageListener=" + this.getMessageListener() + ", consumerEventListener=" + this.getConsumerEventListener() + ", negativeAckRedeliveryBackoff=" + this.getNegativeAckRedeliveryBackoff() + ", ackTimeoutRedeliveryBackoff=" + this.getAckTimeoutRedeliveryBackoff() + ", receiverQueueSize=" + this.getReceiverQueueSize() + ", acknowledgementsGroupTimeMicros=" + this.getAcknowledgementsGroupTimeMicros() + ", maxAcknowledgmentGroupSize=" + this.getMaxAcknowledgmentGroupSize() + ", negativeAckRedeliveryDelayMicros=" + this.getNegativeAckRedeliveryDelayMicros() + ", maxTotalReceiverQueueSizeAcrossPartitions=" + this.getMaxTotalReceiverQueueSizeAcrossPartitions() + ", consumerName=" + this.getConsumerName() + ", ackTimeoutMillis=" + this.getAckTimeoutMillis() + ", tickDurationMillis=" + this.getTickDurationMillis() + ", priorityLevel=" + this.getPriorityLevel() + ", maxPendingChunkedMessage=" + this.getMaxPendingChunkedMessage() + ", autoAckOldestChunkedMessageOnQueueFull=" + this.isAutoAckOldestChunkedMessageOnQueueFull() + ", expireTimeOfIncompleteChunkedMessageMillis=" + this.getExpireTimeOfIncompleteChunkedMessageMillis() + ", cryptoKeyReader=" + this.getCryptoKeyReader() + ", messageCrypto=" + this.getMessageCrypto() + ", cryptoFailureAction=" + (Object)((Object)this.getCryptoFailureAction()) + ", properties=" + this.getProperties() + ", readCompacted=" + this.isReadCompacted() + ", subscriptionInitialPosition=" + (Object)((Object)this.getSubscriptionInitialPosition()) + ", patternAutoDiscoveryPeriod=" + this.getPatternAutoDiscoveryPeriod() + ", regexSubscriptionMode=" + (Object)((Object)this.getRegexSubscriptionMode()) + ", deadLetterPolicy=" + this.getDeadLetterPolicy() + ", retryEnable=" + this.isRetryEnable() + ", batchReceivePolicy=" + this.getBatchReceivePolicy() + ", autoUpdatePartitions=" + this.isAutoUpdatePartitions() + ", autoUpdatePartitionsIntervalSeconds=" + this.getAutoUpdatePartitionsIntervalSeconds() + ", replicateSubscriptionState=" + this.isReplicateSubscriptionState() + ", resetIncludeHead=" + this.isResetIncludeHead() + ", keySharedPolicy=" + this.getKeySharedPolicy() + ", batchIndexAckEnabled=" + this.isBatchIndexAckEnabled() + ", ackReceiptEnabled=" + this.isAckReceiptEnabled() + ", poolMessages=" + this.isPoolMessages() + ", payloadProcessor=" + this.getPayloadProcessor() + ", startPaused=" + this.isStartPaused() + ", autoScaledReceiverQueueSizeEnabled=" + this.isAutoScaledReceiverQueueSizeEnabled() + ", topicConfigurations=" + this.getTopicConfigurations() + ")";
    }

    public ConsumerConfigurationData() {
    }

    public ConsumerConfigurationData(Set<String> topicNames, Pattern topicsPattern, String subscriptionName, SubscriptionType subscriptionType, Map<String, String> subscriptionProperties, SubscriptionMode subscriptionMode, MessageListener<T> messageListener, ConsumerEventListener consumerEventListener, RedeliveryBackoff negativeAckRedeliveryBackoff, RedeliveryBackoff ackTimeoutRedeliveryBackoff, int receiverQueueSize, long acknowledgementsGroupTimeMicros, int maxAcknowledgmentGroupSize, long negativeAckRedeliveryDelayMicros, int maxTotalReceiverQueueSizeAcrossPartitions, String consumerName, long ackTimeoutMillis, long tickDurationMillis, int priorityLevel, int maxPendingChunkedMessage, boolean autoAckOldestChunkedMessageOnQueueFull, long expireTimeOfIncompleteChunkedMessageMillis, CryptoKeyReader cryptoKeyReader, MessageCrypto messageCrypto, ConsumerCryptoFailureAction cryptoFailureAction, SortedMap<String, String> properties, boolean readCompacted, SubscriptionInitialPosition subscriptionInitialPosition, int patternAutoDiscoveryPeriod, RegexSubscriptionMode regexSubscriptionMode, DeadLetterPolicy deadLetterPolicy, boolean retryEnable, BatchReceivePolicy batchReceivePolicy, boolean autoUpdatePartitions, long autoUpdatePartitionsIntervalSeconds, boolean replicateSubscriptionState, boolean resetIncludeHead, KeySharedPolicy keySharedPolicy, boolean batchIndexAckEnabled, boolean ackReceiptEnabled, boolean poolMessages, MessagePayloadProcessor payloadProcessor, boolean startPaused, boolean autoScaledReceiverQueueSizeEnabled, List<TopicConsumerConfigurationData> topicConfigurations) {
        this.topicNames = topicNames;
        this.topicsPattern = topicsPattern;
        this.subscriptionName = subscriptionName;
        this.subscriptionType = subscriptionType;
        this.subscriptionProperties = subscriptionProperties;
        this.subscriptionMode = subscriptionMode;
        this.messageListener = messageListener;
        this.consumerEventListener = consumerEventListener;
        this.negativeAckRedeliveryBackoff = negativeAckRedeliveryBackoff;
        this.ackTimeoutRedeliveryBackoff = ackTimeoutRedeliveryBackoff;
        this.receiverQueueSize = receiverQueueSize;
        this.acknowledgementsGroupTimeMicros = acknowledgementsGroupTimeMicros;
        this.maxAcknowledgmentGroupSize = maxAcknowledgmentGroupSize;
        this.negativeAckRedeliveryDelayMicros = negativeAckRedeliveryDelayMicros;
        this.maxTotalReceiverQueueSizeAcrossPartitions = maxTotalReceiverQueueSizeAcrossPartitions;
        this.consumerName = consumerName;
        this.ackTimeoutMillis = ackTimeoutMillis;
        this.tickDurationMillis = tickDurationMillis;
        this.priorityLevel = priorityLevel;
        this.maxPendingChunkedMessage = maxPendingChunkedMessage;
        this.autoAckOldestChunkedMessageOnQueueFull = autoAckOldestChunkedMessageOnQueueFull;
        this.expireTimeOfIncompleteChunkedMessageMillis = expireTimeOfIncompleteChunkedMessageMillis;
        this.cryptoKeyReader = cryptoKeyReader;
        this.messageCrypto = messageCrypto;
        this.cryptoFailureAction = cryptoFailureAction;
        this.properties = properties;
        this.readCompacted = readCompacted;
        this.subscriptionInitialPosition = subscriptionInitialPosition;
        this.patternAutoDiscoveryPeriod = patternAutoDiscoveryPeriod;
        this.regexSubscriptionMode = regexSubscriptionMode;
        this.deadLetterPolicy = deadLetterPolicy;
        this.retryEnable = retryEnable;
        this.batchReceivePolicy = batchReceivePolicy;
        this.autoUpdatePartitions = autoUpdatePartitions;
        this.autoUpdatePartitionsIntervalSeconds = autoUpdatePartitionsIntervalSeconds;
        this.replicateSubscriptionState = replicateSubscriptionState;
        this.resetIncludeHead = resetIncludeHead;
        this.keySharedPolicy = keySharedPolicy;
        this.batchIndexAckEnabled = batchIndexAckEnabled;
        this.ackReceiptEnabled = ackReceiptEnabled;
        this.poolMessages = poolMessages;
        this.payloadProcessor = payloadProcessor;
        this.startPaused = startPaused;
        this.autoScaledReceiverQueueSizeEnabled = autoScaledReceiverQueueSizeEnabled;
        this.topicConfigurations = topicConfigurations;
    }
}

