/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.metrics;

import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.impl.metrics.Counter;
import org.apache.pulsar.client.impl.metrics.LatencyHistogram;
import org.apache.pulsar.client.impl.metrics.Unit;
import org.apache.pulsar.client.impl.metrics.UpDownCounter;
import org.apache.pulsar.shade.io.opentelemetry.api.GlobalOpenTelemetry;
import org.apache.pulsar.shade.io.opentelemetry.api.OpenTelemetry;
import org.apache.pulsar.shade.io.opentelemetry.api.common.Attributes;
import org.apache.pulsar.shade.io.opentelemetry.api.metrics.Meter;

public class InstrumentProvider {
    public static final InstrumentProvider NOOP = new InstrumentProvider(OpenTelemetry.noop());
    private final Meter meter;

    public InstrumentProvider(OpenTelemetry otel) {
        if (otel == null) {
            otel = GlobalOpenTelemetry.get();
        }
        this.meter = otel.getMeterProvider().meterBuilder("org.apache.pulsar.client").setInstrumentationVersion(PulsarVersion.getVersion()).build();
    }

    public Counter newCounter(String name, Unit unit, String description, String topic, Attributes attributes) {
        return new Counter(this.meter, name, unit, description, topic, attributes);
    }

    public UpDownCounter newUpDownCounter(String name, Unit unit, String description, String topic, Attributes attributes) {
        return new UpDownCounter(this.meter, name, unit, description, topic, attributes);
    }

    public LatencyHistogram newLatencyHistogram(String name, String description, String topic, Attributes attributes) {
        return new LatencyHistogram(this.meter, name, description, topic, attributes);
    }
}

