/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.opentelemetry.api.incubator.events;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.events.EventLoggerProvider;

public final class GlobalEventLoggerProvider {
    private static final AtomicReference<EventLoggerProvider> instance = new AtomicReference<EventLoggerProvider>(EventLoggerProvider.noop());
    @Nullable
    private static volatile Throwable setInstanceCaller;

    private GlobalEventLoggerProvider() {
    }

    public static EventLoggerProvider get() {
        return instance.get();
    }

    public static void set(EventLoggerProvider eventLoggerProvider) {
        boolean changed = instance.compareAndSet(EventLoggerProvider.noop(), eventLoggerProvider);
        if (!changed && eventLoggerProvider != EventLoggerProvider.noop()) {
            throw new IllegalStateException("GlobalEventLoggerProvider.set has already been called. GlobalEventLoggerProvider.set must be called only once before any calls to GlobalEventLoggerProvider.get. Previous invocation set to cause of this exception.", setInstanceCaller);
        }
        setInstanceCaller = new Throwable();
    }

    public static void resetForTest() {
        instance.set(EventLoggerProvider.noop());
    }
}

