/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs.AnyValueArray;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs.AnyValueBoolean;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs.AnyValueBytes;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs.AnyValueDouble;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs.AnyValueLong;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs.AnyValueString;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs.AnyValueType;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs.KeyAnyValue;
import org.apache.pulsar.shade.io.opentelemetry.api.incubator.logs.KeyAnyValueList;

public interface AnyValue<T> {
    public static AnyValue<String> of(String value) {
        return AnyValueString.create(value);
    }

    public static AnyValue<Boolean> of(boolean value) {
        return AnyValueBoolean.create(value);
    }

    public static AnyValue<Long> of(long value) {
        return AnyValueLong.create(value);
    }

    public static AnyValue<Double> of(double value) {
        return AnyValueDouble.create(value);
    }

    public static AnyValue<ByteBuffer> of(byte[] value) {
        return AnyValueBytes.create(value);
    }

    public static AnyValue<List<AnyValue<?>>> of(AnyValue<?> ... value) {
        return AnyValueArray.create(value);
    }

    public static AnyValue<List<AnyValue<?>>> of(List<AnyValue<?>> value) {
        return AnyValueArray.create(value);
    }

    public static AnyValue<List<KeyAnyValue>> of(KeyAnyValue ... value) {
        return KeyAnyValueList.create(value);
    }

    public static AnyValue<List<KeyAnyValue>> of(Map<String, AnyValue<?>> value) {
        return KeyAnyValueList.createFromMap(value);
    }

    public AnyValueType getType();

    public T getValue();

    public String asString();
}

