/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.handler;

import org.apache.pulsar.shade.com.typesafe.netty.HandlerPublisher;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.util.concurrent.EventExecutor;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseBodyPart;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.ChannelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamedResponsePublisher
extends HandlerPublisher<HttpResponseBodyPart> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ChannelManager channelManager;
    private final NettyResponseFuture<?> future;
    private final Channel channel;

    StreamedResponsePublisher(EventExecutor executor, ChannelManager channelManager, NettyResponseFuture<?> future, Channel channel) {
        super(executor, HttpResponseBodyPart.class);
        this.channelManager = channelManager;
        this.future = future;
        this.channel = channel;
    }

    @Override
    protected void cancelled() {
        this.logger.debug("Subscriber cancelled, ignoring the rest of the body");
        try {
            this.future.done();
        }
        catch (Exception t2) {
            this.logger.debug(t2.getMessage(), (Throwable)t2);
        }
        this.channelManager.closeChannel(this.channel);
    }

    NettyResponseFuture<?> future() {
        return this.future;
    }
}

