/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pulsar.shade.javax.xml.parsers.DocumentBuilderFactory;
import org.apache.pulsar.shade.javax.xml.parsers.ParserConfigurationException;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHandler;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseBodyPart;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseStatus;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponse;
import org.apache.pulsar.shade.org.asynchttpclient.webdav.WebDavResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class WebDavCompletionHandlerBase<T>
implements AsyncHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDavCompletionHandlerBase.class);
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private final List<HttpResponseBodyPart> bodyParts = Collections.synchronizedList(new ArrayList());
    private HttpResponseStatus status;
    private HttpHeaders headers;

    @Override
    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) {
        this.bodyParts.add(content);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onStatusReceived(HttpResponseStatus status) {
        this.status = status;
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onHeadersReceived(HttpHeaders headers) {
        this.headers = headers;
        return AsyncHandler.State.CONTINUE;
    }

    private Document readXMLResponse(InputStream stream) {
        Document document;
        try {
            document = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().parse(stream);
            this.parse(document);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        return document;
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        NodeList statusNode = element.getElementsByTagName("status");
        for (int i = 0; i < statusNode.getLength(); ++i) {
            Node node = statusNode.item(i);
            String value = node.getFirstChild().getNodeValue();
            int statusCode = Integer.parseInt(value.substring(value.indexOf(" "), value.lastIndexOf(" ")).trim());
            String statusText = value.substring(value.lastIndexOf(" "));
            this.status = new HttpStatusWrapper(this.status, statusText, statusCode);
        }
    }

    @Override
    public final T onCompleted() throws Exception {
        if (this.status != null) {
            Document document = null;
            if (this.status.getStatusCode() == 207) {
                document = this.readXMLResponse(new NettyResponse(this.status, this.headers, this.bodyParts).getResponseBodyAsStream());
            }
            return this.onCompleted(new WebDavResponse(new NettyResponse(this.status, this.headers, this.bodyParts), document));
        }
        throw new IllegalStateException("Status is null");
    }

    @Override
    public void onThrowable(Throwable t2) {
        LOGGER.debug(t2.getMessage(), t2);
    }

    public abstract T onCompleted(WebDavResponse var1) throws Exception;

    static {
        if (Boolean.getBoolean("org.apache.pulsar.shade.org.asynchttpclient.webdav.enableDtd")) {
            try {
                DOCUMENT_BUILDER_FACTORY.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException e) {
                LOGGER.error("Failed to disable doctype declaration");
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static class HttpStatusWrapper
    extends HttpResponseStatus {
        private final HttpResponseStatus wrapped;
        private final String statusText;
        private final int statusCode;

        HttpStatusWrapper(HttpResponseStatus wrapper, String statusText, int statusCode) {
            super(wrapper.getUri());
            this.wrapped = wrapper;
            this.statusText = statusText;
            this.statusCode = statusCode;
        }

        @Override
        public int getStatusCode() {
            return this.statusText == null ? this.wrapped.getStatusCode() : this.statusCode;
        }

        @Override
        public String getStatusText() {
            return this.statusText == null ? this.wrapped.getStatusText() : this.statusText;
        }

        @Override
        public String getProtocolName() {
            return this.wrapped.getProtocolName();
        }

        @Override
        public int getProtocolMajorVersion() {
            return this.wrapped.getProtocolMajorVersion();
        }

        @Override
        public int getProtocolMinorVersion() {
            return this.wrapped.getProtocolMinorVersion();
        }

        @Override
        public String getProtocolText() {
            return this.wrapped.getStatusText();
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.wrapped.getRemoteAddress();
        }

        @Override
        public SocketAddress getLocalAddress() {
            return this.wrapped.getLocalAddress();
        }
    }
}

