/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.pulsar.PulsarOptions$;
import org.apache.spark.sql.pulsar.PulsarSourceUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001q3AAB\u0004\u0001%!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015Q\u0004\u0001\"\u0001<\u0011!\u0001\u0005\u0001#b\u0001\n\u0013\t\u0005\"B&\u0001\t\u0003a%\u0001\b)vYN\f'/\u00113nSN\u001c\u0018n\u001c8D_:$(o\u001c7IK2\u0004XM\u001d\u0006\u0003\u0011%\ta\u0001];mg\u0006\u0014(B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011c\u0001\u0001\u00143A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u000f\u000e\u0003mQ!\u0001H\u0006\u0002\u0011%tG/\u001a:oC2L!AH\u000e\u0003\u000f1{wmZ5oO\u0006A\u0011\rZ7j]V\u0013H\u000e\u0005\u0002\"Q9\u0011!E\n\t\u0003GUi\u0011\u0001\n\u0006\u0003KE\ta\u0001\u0010:p_Rt\u0014BA\u0014\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011F\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d*\u0012\u0001B2p]\u001a\u0004B!\f\u001a!i5\taF\u0003\u00020a\u0005!Q\u000f^5m\u0015\u0005\t\u0014\u0001\u00026bm\u0006L!a\r\u0018\u0003\u00075\u000b\u0007\u000f\u0005\u00026q5\taG\u0003\u00028a\u0005!A.\u00198h\u0013\tIdG\u0001\u0004PE*,7\r^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007qrt\b\u0005\u0002>\u00015\tq\u0001C\u0003 \u0007\u0001\u0007\u0001\u0005C\u0003,\u0007\u0001\u0007A&A\u0006qk2\u001c\u0018M]!e[&tW#\u0001\"\u0011\u0005\rKU\"\u0001#\u000b\u0005\u00153\u0015!B1e[&t'BA$I\u0003\u0019\u0019G.[3oi*\u0011\u0001\"D\u0005\u0003\u0015\u0012\u00131\u0002U;mg\u0006\u0014\u0018\tZ7j]\u0006iB.\u0019;fgR|eMZ:fi\u001a{'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003N'V;\u0006C\u0001(R\u001b\u0005y%B\u0001)G\u0003\r\t\u0007/[\u0005\u0003%>\u0013\u0011\"T3tg\u0006<W-\u00133\t\u000bQ+\u0001\u0019\u0001\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\")a+\u0002a\u0001\u001b\u0006q1\u000f^1si6+7o]1hK&#\u0007\"\u0002-\u0006\u0001\u0004I\u0016!\u0003:fC\u0012d\u0015.\\5u!\t!\",\u0003\u0002\\+\t!Aj\u001c8h\u0001")
public class PulsarAdmissionControlHelper
implements Logging {
    private PulsarAdmin pulsarAdmin;
    private String adminUrl;
    private Map<String, Object> conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private PulsarAdmin pulsarAdmin$lzycompute() {
        PulsarAdmissionControlHelper pulsarAdmissionControlHelper = this;
        synchronized (pulsarAdmissionControlHelper) {
            if (!this.bitmap$0) {
                this.pulsarAdmin = PulsarAdmin.builder().serviceHttpUrl(this.adminUrl).loadConf(this.conf).build();
                this.bitmap$0 = true;
            }
        }
        this.adminUrl = null;
        this.conf = null;
        return this.pulsarAdmin;
    }

    private PulsarAdmin pulsarAdmin() {
        if (!this.bitmap$0) {
            return this.pulsarAdmin$lzycompute();
        }
        return this.pulsarAdmin;
    }

    public MessageId latestOffsetForTopicPartition(String topicPartition, MessageId startMessageId, long readLimit) {
        MessageId messageId;
        Object object = new Object();
        try {
            long startLedgerId = PulsarSourceUtils$.MODULE$.getLedgerId(startMessageId);
            long startEntryId = PulsarSourceUtils$.MODULE$.getEntryId(startMessageId);
            PersistentTopicInternalStats stats = this.pulsarAdmin().topics().getInternalStats(topicPartition);
            Buffer ledgers = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stats.ledgers).asScala()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)PulsarAdmissionControlHelper.$anonfun$latestOffsetForTopicPartition$1(startLedgerId, x$9)))).sortBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.ledgerId), (Ordering)Ordering.Long$.MODULE$);
            if (ledgers.nonEmpty()) {
                ((ManagedLedgerInternalStats.LedgerInfo)ledgers.last()).size = stats.currentLedgerSize;
                ((ManagedLedgerInternalStats.LedgerInfo)ledgers.last()).entries = stats.currentLedgerEntries;
            }
            int partitionIndex = topicPartition.contains(PulsarOptions$.MODULE$.PartitionSuffix()) ? new StringOps(Predef$.MODULE$.augmentString(topicPartition.split(PulsarOptions$.MODULE$.PartitionSuffix())[1])).toInt() : -1;
            ObjectRef messageId2 = ObjectRef.create((Object)startMessageId);
            LongRef readLimitLeft = LongRef.create((long)readLimit);
            ((IterableLike)((SeqLike)ledgers.filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)PulsarAdmissionControlHelper.$anonfun$latestOffsetForTopicPartition$3(x$11)))).sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.ledgerId), (Ordering)Ordering.Long$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)ledger -> {
                PulsarAdmissionControlHelper.$anonfun$latestOffsetForTopicPartition$5(readLimitLeft, object, messageId2, startLedgerId, startEntryId, partitionIndex, ledger);
                return BoxedUnit.UNIT;
            });
            messageId = (MessageId)messageId2.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                messageId = (MessageId)ex.value();
            }
            throw ex;
        }
        return messageId;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffsetForTopicPartition$1(long startLedgerId$1, ManagedLedgerInternalStats.LedgerInfo x$9) {
        return x$9.ledgerId >= startLedgerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffsetForTopicPartition$3(ManagedLedgerInternalStats.LedgerInfo x$11) {
        return x$11.entries != 0L;
    }

    public static final /* synthetic */ void $anonfun$latestOffsetForTopicPartition$5(LongRef readLimitLeft$1, Object nonLocalReturnKey1$1, ObjectRef messageId$1, long startLedgerId$1, long startEntryId$1, int partitionIndex$1, ManagedLedgerInternalStats.LedgerInfo ledger) {
        long bytesLeftInLedger;
        Predef$.MODULE$.assert(readLimitLeft$1.elem >= 0L);
        if (readLimitLeft$1.elem == 0L) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)((MessageId)messageId$1.elem));
        }
        long avgBytesPerEntries = ledger.size / ledger.entries;
        long l = bytesLeftInLedger = ledger.ledgerId == startLedgerId$1 ? avgBytesPerEntries * (ledger.entries - startEntryId$1 - 1L) : ledger.size;
        if (readLimitLeft$1.elem > bytesLeftInLedger) {
            readLimitLeft$1.elem -= bytesLeftInLedger;
            messageId$1.elem = DefaultImplementation.getDefaultImplementation().newMessageId(ledger.ledgerId, ledger.entries - 1L, partitionIndex$1);
            return;
        }
        long numEntriesToRead = Math.max(1L, readLimitLeft$1.elem / avgBytesPerEntries);
        long lastEntryId = ledger.ledgerId != startLedgerId$1 ? numEntriesToRead - 1L : startEntryId$1 + numEntriesToRead;
        long lastEntryRead = Math.min(ledger.entries - 1L, lastEntryId);
        messageId$1.elem = DefaultImplementation.getDefaultImplementation().newMessageId(ledger.ledgerId, lastEntryRead, partitionIndex$1);
        readLimitLeft$1.elem = 0L;
    }

    public PulsarAdmissionControlHelper(String adminUrl, Map<String, Object> conf) {
        this.adminUrl = adminUrl;
        this.conf = conf;
        Logging.$init$((Logging)this);
    }
}

