/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.pulsar.EarliestOffset$;
import org.apache.spark.sql.pulsar.JsonUtils$;
import org.apache.spark.sql.pulsar.LatestOffset$;
import org.apache.spark.sql.pulsar.PulsarConfigUpdater;
import org.apache.spark.sql.pulsar.PulsarConfigUpdater$;
import org.apache.spark.sql.pulsar.PulsarConfigurationUtils$;
import org.apache.spark.sql.pulsar.PulsarOffset;
import org.apache.spark.sql.pulsar.PulsarOptions$;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset;
import org.apache.spark.sql.pulsar.SpecificPulsarTime;
import org.apache.spark.sql.pulsar.TimeOffset;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PulsarProvider$
implements Logging {
    public static PulsarProvider$ MODULE$;
    private final long LATEST_TIME;
    private final long EARLIEST_TIME;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PulsarProvider$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long LATEST_TIME() {
        return this.LATEST_TIME;
    }

    public long EARLIEST_TIME() {
        return this.EARLIEST_TIME;
    }

    private scala.collection.immutable.Map<String, String> getClientParams(scala.collection.immutable.Map<String, String> parameters) {
        scala.collection.immutable.Map lowercaseKeyMap = ((TraversableOnce)((SetLike)parameters.keySet().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(PulsarOptions$.MODULE$.PulsarClientOptionKeyPrefix())))).map((Function1 & Serializable & scala.Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)new StringOps(Predef$.MODULE$.augmentString(k)).drop(PulsarOptions$.MODULE$.PulsarClientOptionKeyPrefix().length())).toString()), parameters.apply(k)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (scala.collection.immutable.Map)lowercaseKeyMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PulsarConfigurationUtils$.MODULE$.clientConfKeys().getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(24).append(k).append(" not supported by pulsar").toString());
                })), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Map<String, String> getAdminParams(scala.collection.immutable.Map<String, String> parameters) {
        return this.getModuleParams(parameters, PulsarOptions$.MODULE$.PulsarAdminOptionKeyPrefix(), PulsarConfigurationUtils$.MODULE$.clientConfKeys());
    }

    private scala.collection.immutable.Map<String, String> getProducerParams(scala.collection.immutable.Map<String, String> parameters) {
        return this.getModuleParams(parameters, PulsarOptions$.MODULE$.PulsarProducerOptionKeyPrefix(), PulsarConfigurationUtils$.MODULE$.producerConfKeys());
    }

    private scala.collection.immutable.Map<String, String> getReaderParams(scala.collection.immutable.Map<String, String> parameters) {
        return this.getModuleParams(parameters, PulsarOptions$.MODULE$.PulsarReaderOptionKeyPrefix(), PulsarConfigurationUtils$.MODULE$.readerConfKeys());
    }

    private scala.collection.immutable.Map<String, String> getModuleParams(scala.collection.immutable.Map<String, String> connectorConfiguration, String modulePrefix, scala.collection.immutable.Map<String, String> moduleKeyLookup) {
        scala.collection.immutable.Map lowerCaseModuleParameters = ((TraversableOnce)((SetLike)connectorConfiguration.keySet().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith(modulePrefix)))).map((Function1 & Serializable & scala.Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringOps(Predef$.MODULE$.augmentString(k)).drop(modulePrefix.length())), connectorConfiguration.apply(k)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (scala.collection.immutable.Map)lowerCaseModuleParameters.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(moduleKeyLookup.getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(24).append(k).append(" not supported by pulsar").toString());
                })), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PulsarOffset getPulsarOffset(scala.collection.immutable.Map<String, String> params, PulsarOffset defaultOffsets, String optionKey) {
        PulsarOffset pulsarOffset;
        Option time;
        Option option;
        Option option2;
        String string = optionKey;
        String string2 = PulsarOptions$.MODULE$.StartOptionKey();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            option2 = params.get((Object)PulsarOptions$.MODULE$.StartingOffsetsOptionKey()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.trim());
        } else {
            String string4 = PulsarOptions$.MODULE$.EndOptionKey();
            String string5 = string;
            if (string4 == null) {
                if (string5 != null) {
                    throw new MatchError((Object)string);
                }
            } else if (!string4.equals(string5)) throw new MatchError((Object)string);
            option2 = params.get((Object)PulsarOptions$.MODULE$.EndingOffsetsOptionKey()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.trim());
        }
        Option offsets = option2;
        String string6 = optionKey;
        String string7 = PulsarOptions$.MODULE$.StartOptionKey();
        String string8 = string6;
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            option = params.get((Object)PulsarOptions$.MODULE$.StartingTime()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.trim());
        } else {
            String string9 = PulsarOptions$.MODULE$.EndOptionKey();
            String string10 = string6;
            if (string9 == null) {
                if (string10 != null) {
                    throw new MatchError((Object)string6);
                }
            } else if (!string9.equals(string10)) throw new MatchError((Object)string6);
            option = time = params.get((Object)PulsarOptions$.MODULE$.EndingTime()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.trim());
        }
        if (offsets.isDefined() && time.isDefined()) {
            throw new IllegalArgumentException(new StringBuilder(61).append("You can only specify starting ").append(optionKey).append(" through ").append("either ").append(PulsarOptions$.MODULE$.StartingOffsetsOptionKey()).append(" or ").append(PulsarOptions$.MODULE$.StartingTime()).append(", not both.").toString());
        }
        if (offsets.isDefined()) {
            boolean bl = false;
            Some some = null;
            Option option3 = offsets;
            if (option3 instanceof Some) {
                bl = true;
                some = (Some)option3;
                String offset = (String)some.value();
                String string11 = offset.toLowerCase(Locale.ROOT);
                String string12 = "latest";
                if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                    pulsarOffset = LatestOffset$.MODULE$;
                    return pulsarOffset;
                }
            }
            if (bl) {
                String offset = (String)some.value();
                String string13 = offset.toLowerCase(Locale.ROOT);
                String string14 = "earliest";
                if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                    pulsarOffset = EarliestOffset$.MODULE$;
                    return pulsarOffset;
                }
            }
            if (bl) {
                String json = (String)some.value();
                pulsarOffset = new SpecificPulsarOffset(JsonUtils$.MODULE$.topicOffsets(json));
                return pulsarOffset;
            } else {
                if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                pulsarOffset = defaultOffsets;
            }
            return pulsarOffset;
        }
        if (time.isDefined()) {
            boolean bl = false;
            Some some = null;
            Option option4 = time;
            if (option4 instanceof Some) {
                bl = true;
                some = (Some)option4;
                String json = (String)some.value();
                if (json.startsWith("{")) {
                    pulsarOffset = new SpecificPulsarTime(JsonUtils$.MODULE$.topicTimes(json));
                    return pulsarOffset;
                }
            }
            if (bl) {
                String t2 = (String)some.value();
                try {
                    pulsarOffset = new TimeOffset(new StringOps(Predef$.MODULE$.augmentString(t2)).toLong());
                    return pulsarOffset;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(new StringBuilder(34).append(optionKey).append(" time ").append(t2).append(" cannot be converted to Long").toString());
                }
            } else {
                if (!None$.MODULE$.equals(option4)) throw new MatchError((Object)option4);
                pulsarOffset = defaultOffsets;
            }
            return pulsarOffset;
        }
        pulsarOffset = defaultOffsets;
        return pulsarOffset;
    }

    public PulsarOffset getPulsarOffset(scala.collection.immutable.Map<String, String> params, String offsetOptionKey, PulsarOffset defaultOffsets) {
        boolean bl = false;
        Some some = null;
        Option option = params.get((Object)offsetOptionKey).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.trim());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String offset = (String)some.value();
            String string = offset.toLowerCase(Locale.ROOT);
            String string2 = "latest";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return LatestOffset$.MODULE$;
            }
        }
        if (bl) {
            String offset = (String)some.value();
            String string = offset.toLowerCase(Locale.ROOT);
            String string3 = "earliest";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return EarliestOffset$.MODULE$;
            }
        }
        if (bl) {
            String json = (String)some.value();
            return new SpecificPulsarOffset(JsonUtils$.MODULE$.topicOffsets(json));
        }
        if (None$.MODULE$.equals(option)) {
            return defaultOffsets;
        }
        throw new MatchError((Object)option);
    }

    public Map<String, Object> paramsToPulsarConf(String module, scala.collection.immutable.Map<String, String> params) {
        return new PulsarConfigUpdater(module, params, PulsarConfigUpdater$.MODULE$.apply$default$3(), PulsarConfigUpdater$.MODULE$.apply$default$4()).rebuild();
    }

    public String org$apache$spark$sql$pulsar$PulsarProvider$$getSubscriptionPrefix(scala.collection.immutable.Map<String, String> parameters, boolean isBatch) {
        String defaultPrefix = isBatch ? "spark-pulsar-batch" : "spark-pulsar";
        return (String)parameters.getOrElse((Object)PulsarOptions$.MODULE$.SubscriptionPrefix(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(defaultPrefix).append("-").append(UUID.randomUUID()).toString());
    }

    public boolean org$apache$spark$sql$pulsar$PulsarProvider$$getSubscriptionPrefix$default$2() {
        return false;
    }

    public Option<String> org$apache$spark$sql$pulsar$PulsarProvider$$getPredefinedSubscription(scala.collection.immutable.Map<String, String> parameters) {
        String sub = (String)parameters.getOrElse((Object)PulsarOptions$.MODULE$.PredefinedSubscription(), (Function0 & Serializable & scala.Serializable)() -> "");
        String string = sub;
        if ("".equals(string)) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply((Object)string);
    }

    private String getServiceUrl(scala.collection.immutable.Map<String, String> parameters) {
        return (String)parameters.apply((Object)PulsarOptions$.MODULE$.ServiceUrlOptionKey());
    }

    private Option<String> getAdminUrl(scala.collection.immutable.Map<String, String> parameters) {
        return parameters.get((Object)PulsarOptions$.MODULE$.AdminUrlOptionKey());
    }

    public boolean org$apache$spark$sql$pulsar$PulsarProvider$$getAllowDifferentTopicSchemas(scala.collection.immutable.Map<String, String> parameters) {
        return new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)PulsarOptions$.MODULE$.AllowDifferentTopicSchemas(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
    }

    public boolean org$apache$spark$sql$pulsar$PulsarProvider$$failOnDataLoss(scala.collection.immutable.Map<String, String> caseInsensitiveParams) {
        return new StringOps(Predef$.MODULE$.augmentString((String)caseInsensitiveParams.getOrElse((Object)PulsarOptions$.MODULE$.FailOnDataLossOptionKey(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
    }

    public int org$apache$spark$sql$pulsar$PulsarProvider$$pollTimeoutMs(scala.collection.immutable.Map<String, String> caseInsensitiveParams) {
        return new StringOps(Predef$.MODULE$.augmentString((String)caseInsensitiveParams.getOrElse((Object)PulsarOptions$.MODULE$.PollTimeoutMS(), (Function0 & Serializable & scala.Serializable)() -> Long.toString(SparkEnv$.MODULE$.get().conf().getTimeAsSeconds("spark.network.timeout", "120s") * 1000L)))).toInt();
    }

    public long org$apache$spark$sql$pulsar$PulsarProvider$$maxBytesPerTrigger(scala.collection.immutable.Map<String, String> caseInsensitiveParams) {
        return new StringOps(Predef$.MODULE$.augmentString((String)caseInsensitiveParams.getOrElse((Object)PulsarOptions$.MODULE$.MaxBytesPerTrigger(), (Function0 & Serializable & scala.Serializable)() -> Long.toString(0L)))).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private scala.collection.immutable.Map<String, String> validateGeneralOptions(scala.collection.immutable.Map<String, String> caseInsensitiveParams) {
        if (!caseInsensitiveParams.contains((Object)PulsarOptions$.MODULE$.ServiceUrlOptionKey())) {
            throw new IllegalArgumentException(new StringBuilder(18).append(PulsarOptions$.MODULE$.ServiceUrlOptionKey()).append(" must be specified").toString());
        }
        Seq topicOptions = ((MapLike)caseInsensitiveParams.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PulsarProvider$.$anonfun$validateGeneralOptions$1(x0$1)))).toSeq();
        if (topicOptions.isEmpty() || topicOptions.size() > 1) {
            throw new IllegalArgumentException(new StringBuilder(60).append("You should specify topic(s) using one of the topic options: ").append(PulsarOptions$.MODULE$.TopicOptionKeys().mkString(", ")).toString());
        }
        Tuple2 tuple2 = (Tuple2)topicOptions.head();
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String value = (String)tuple2._2();
            if ("topic".equals(string)) {
                if (value.contains(",")) {
                    throw new IllegalArgumentException("Use \"topics\" instead of \"topic\" for multi topic read");
                }
                if (!value.trim().isEmpty()) return caseInsensitiveParams;
                throw new IllegalArgumentException("No topic is specified");
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String value = (String)tuple2._2();
            if ("topics".equals(string)) {
                String[] topics = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.split(","))).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)PulsarProvider$.$anonfun$validateGeneralOptions$3(x$15)));
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topics)).isEmpty()) return caseInsensitiveParams;
                throw new IllegalArgumentException(new StringBuilder(45).append("No topics is specified for read with option: ").append(value).toString());
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String string = (String)tuple2._1();
        String value = (String)tuple2._2();
        if (!"topicspattern".equals(string)) throw new MatchError((Object)tuple2);
        if (!value.trim().isEmpty()) return caseInsensitiveParams;
        throw new IllegalArgumentException("TopicsPattern is empty");
    }

    public scala.collection.immutable.Map<String, String> org$apache$spark$sql$pulsar$PulsarProvider$$validateStreamOptions(scala.collection.immutable.Map<String, String> parameters) {
        scala.collection.immutable.Map caseInsensitiveParams = (scala.collection.immutable.Map)parameters.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k.toLowerCase(Locale.ROOT), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        caseInsensitiveParams.get((Object)PulsarOptions$.MODULE$.EndingOffsetsOptionKey()).map((Function1 & Serializable & scala.Serializable)x$16 -> {
            throw new IllegalArgumentException("ending offset not valid in streaming queries");
        });
        return this.validateGeneralOptions((scala.collection.immutable.Map<String, String>)caseInsensitiveParams);
    }

    public scala.collection.immutable.Map<String, String> org$apache$spark$sql$pulsar$PulsarProvider$$validateBatchOptions(scala.collection.immutable.Map<String, String> parameters) {
        scala.collection.immutable.Map caseInsensitiveParams = (scala.collection.immutable.Map)parameters.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k.toLowerCase(Locale.ROOT), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        PulsarOffset pulsarOffset = this.getPulsarOffset((scala.collection.immutable.Map<String, String>)caseInsensitiveParams, PulsarOptions$.MODULE$.StartingOffsetsOptionKey(), EarliestOffset$.MODULE$);
        if (EarliestOffset$.MODULE$.equals(pulsarOffset)) {
        } else {
            if (LatestOffset$.MODULE$.equals(pulsarOffset)) {
                throw new IllegalArgumentException("starting offset can't be latest for batch queries on Pulsar");
            }
            if (pulsarOffset instanceof SpecificPulsarOffset) {
                SpecificPulsarOffset specificPulsarOffset = (SpecificPulsarOffset)pulsarOffset;
                scala.collection.immutable.Map<String, MessageId> topicOffsets = specificPulsarOffset.topicOffsets();
                topicOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    PulsarProvider$.$anonfun$validateBatchOptions$2(x0$2);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)pulsarOffset);
            }
        }
        PulsarOffset pulsarOffset2 = this.getPulsarOffset((scala.collection.immutable.Map<String, String>)caseInsensitiveParams, PulsarOptions$.MODULE$.EndingOffsetsOptionKey(), LatestOffset$.MODULE$);
        if (EarliestOffset$.MODULE$.equals(pulsarOffset2)) {
            throw new IllegalArgumentException("ending offset can't be earliest for batch queries on Pulsar");
        }
        if (LatestOffset$.MODULE$.equals(pulsarOffset2)) {
        } else if (pulsarOffset2 instanceof SpecificPulsarOffset) {
            SpecificPulsarOffset specificPulsarOffset = (SpecificPulsarOffset)pulsarOffset2;
            scala.collection.immutable.Map<String, MessageId> topicOffsets = specificPulsarOffset.topicOffsets();
            topicOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                PulsarProvider$.$anonfun$validateBatchOptions$3(x0$3);
                return BoxedUnit.UNIT;
            });
        } else {
            throw new MatchError((Object)pulsarOffset2);
        }
        return this.validateGeneralOptions((scala.collection.immutable.Map<String, String>)caseInsensitiveParams);
    }

    public scala.collection.immutable.Map<String, String> org$apache$spark$sql$pulsar$PulsarProvider$$validateSinkOptions(scala.collection.immutable.Map<String, String> parameters) {
        scala.collection.immutable.Map caseInsensitiveParams = (scala.collection.immutable.Map)parameters.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k.toLowerCase(Locale.ROOT), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        if (!caseInsensitiveParams.contains((Object)PulsarOptions$.MODULE$.ServiceUrlOptionKey())) {
            throw new IllegalArgumentException(new StringBuilder(18).append(PulsarOptions$.MODULE$.ServiceUrlOptionKey()).append(" must be specified").toString());
        }
        scala.collection.immutable.Map topicOptions = ((MapLike)caseInsensitiveParams.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PulsarProvider$.$anonfun$validateSinkOptions$2(x0$2)))).toSeq().toMap(Predef$.MODULE$.$conforms());
        if (topicOptions.size() > 1 || topicOptions.contains((Object)PulsarOptions$.MODULE$.TopicMulti()) || topicOptions.contains((Object)PulsarOptions$.MODULE$.TopicPattern())) {
            throw new IllegalArgumentException(new StringBuilder(85).append("Currently, we only support specify single topic through option, ").append("use '").append(PulsarOptions$.MODULE$.TopicSingle()).append("' to specify it.").toString());
        }
        return caseInsensitiveParams;
    }

    public Tuple5<Map<String, Object>, Map<String, Object>, Map<String, Object>, String, Option<String>> org$apache$spark$sql$pulsar$PulsarProvider$$prepareConfForReader(scala.collection.immutable.Map<String, String> parameters) {
        String serviceUrl = this.getServiceUrl(parameters);
        Option<String> adminUrl = this.getAdminUrl(parameters);
        scala.collection.immutable.Map clientParams = this.getClientParams(parameters);
        clientParams = clientParams.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PulsarOptions$.MODULE$.ServiceUrlOptionKey()), (Object)serviceUrl));
        scala.collection.immutable.Map<String, String> readerParams = this.getReaderParams(parameters);
        scala.collection.immutable.Map<String, String> adminParams = this.getAdminParams(parameters);
        return new Tuple5(this.paramsToPulsarConf("pulsar.client", (scala.collection.immutable.Map<String, String>)clientParams), this.paramsToPulsarConf("pulsar.reader", readerParams), this.paramsToPulsarConf("pulsar.admin", adminParams), (Object)serviceUrl, adminUrl);
    }

    public Tuple3<Map<String, Object>, Map<String, Object>, Option<String>> org$apache$spark$sql$pulsar$PulsarProvider$$prepareConfForProducer(scala.collection.immutable.Map<String, String> parameters) {
        String serviceUrl = this.getServiceUrl(parameters);
        scala.collection.immutable.Map clientParams = this.getClientParams(parameters);
        clientParams = clientParams.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PulsarOptions$.MODULE$.ServiceUrlOptionKey()), (Object)serviceUrl));
        scala.collection.immutable.Map<String, String> producerParams = this.getProducerParams(parameters);
        Option topic = parameters.get((Object)PulsarOptions$.MODULE$.TopicSingle()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.trim()).map((Function1 & Serializable & scala.Serializable)x$18 -> TopicName.get(x$18).toString());
        return new Tuple3(this.paramsToPulsarConf("pulsar.client", (scala.collection.immutable.Map<String, String>)clientParams), this.paramsToPulsarConf("pulsar.producer", producerParams), (Object)topic);
    }

    public JSONOptionsInRead org$apache$spark$sql$pulsar$PulsarProvider$$jsonOptions() {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        return new JSONOptionsInRead((scala.collection.immutable.Map)CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty()), spark.sessionState().conf().sessionLocalTimeZone(), spark.sessionState().conf().columnNameOfCorruptRecord());
    }

    public static final /* synthetic */ boolean $anonfun$validateGeneralOptions$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return PulsarOptions$.MODULE$.TopicOptionKeys().contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$validateGeneralOptions$3(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$validateBatchOptions$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            MessageId offset;
            String topic = (String)tuple2._1();
            MessageId messageId = offset = (MessageId)tuple2._2();
            MessageId messageId2 = MessageId.latest;
            if (!(messageId != null ? !messageId.equals(messageId2) : messageId2 != null)) {
                throw new IllegalArgumentException(new StringBuilder(64).append("starting offset for ").append(topic).append(" can't ").append("be latest for batch queries on Pulsar").toString());
            }
        }
    }

    public static final /* synthetic */ void $anonfun$validateBatchOptions$3(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            MessageId offset;
            String topic = (String)tuple2._1();
            MessageId messageId = offset = (MessageId)tuple2._2();
            MessageId messageId2 = MessageId.earliest;
            if (!(messageId != null ? !messageId.equals(messageId2) : messageId2 != null)) {
                throw new IllegalArgumentException(new StringBuilder(64).append("ending offset for ").append(topic).append(" can't ").append("be earliest for batch queries on Pulsar").toString());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateSinkOptions$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return PulsarOptions$.MODULE$.TopicOptionKeys().contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    private PulsarProvider$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.LATEST_TIME = -2L;
        this.EARLIEST_TIME = -1L;
    }
}

