/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.avro.LogicalType;
import org.apache.pulsar.shade.org.apache.avro.LogicalTypes;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.SchemaBuilder;
import org.apache.spark.sql.pulsar.IncompatibleSchemaException;
import org.apache.spark.sql.pulsar.IncompatibleSchemaException$;
import org.apache.spark.sql.pulsar.PulsarOptions$;
import org.apache.spark.sql.pulsar.SchemaUtils;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxesRunTime;

public final class SchemaUtils$ {
    public static SchemaUtils$ MODULE$;
    private Schema nullSchema;
    private final Seq<StructField> metaDataFields;
    private volatile boolean bitmap$0;

    static {
        new SchemaUtils$();
    }

    private Schema nullSchema$lzycompute() {
        SchemaUtils$ schemaUtils$ = this;
        synchronized (schemaUtils$) {
            if (!this.bitmap$0) {
                this.nullSchema = Schema.create(Schema.Type.NULL);
                this.bitmap$0 = true;
            }
        }
        return this.nullSchema;
    }

    private Schema nullSchema() {
        if (!this.bitmap$0) {
            return this.nullSchema$lzycompute();
        }
        return this.nullSchema;
    }

    public SchemaInfo emptySchemaInfo() {
        return SchemaInfo.builder().name("empty").type(SchemaType.NONE).schema(new byte[0]).build();
    }

    public org.apache.pulsar.client.api.Schema<?> getPSchema(SchemaInfo schemaInfo) {
        SchemaType schemaType = schemaInfo.getType();
        if (((Object)((Object)SchemaType.BOOLEAN)).equals((Object)schemaType)) {
            return BooleanSchema.of();
        }
        if (((Object)((Object)SchemaType.INT8)).equals((Object)schemaType)) {
            return ByteSchema.of();
        }
        if (((Object)((Object)SchemaType.INT16)).equals((Object)schemaType)) {
            return ShortSchema.of();
        }
        if (((Object)((Object)SchemaType.INT32)).equals((Object)schemaType)) {
            return IntSchema.of();
        }
        if (((Object)((Object)SchemaType.INT64)).equals((Object)schemaType)) {
            return LongSchema.of();
        }
        if (((Object)((Object)SchemaType.STRING)).equals((Object)schemaType)) {
            return org.apache.pulsar.client.api.Schema.STRING;
        }
        if (((Object)((Object)SchemaType.FLOAT)).equals((Object)schemaType)) {
            return FloatSchema.of();
        }
        if (((Object)((Object)SchemaType.DOUBLE)).equals((Object)schemaType)) {
            return DoubleSchema.of();
        }
        if (((Object)((Object)SchemaType.BYTES)).equals((Object)schemaType)) {
            return BytesSchema.of();
        }
        if (((Object)((Object)SchemaType.DATE)).equals((Object)schemaType)) {
            return DateSchema.of();
        }
        if (((Object)((Object)SchemaType.TIME)).equals((Object)schemaType)) {
            return TimeSchema.of();
        }
        if (((Object)((Object)SchemaType.TIMESTAMP)).equals((Object)schemaType)) {
            return TimestampSchema.of();
        }
        if (((Object)((Object)SchemaType.NONE)).equals((Object)schemaType)) {
            return BytesSchema.of();
        }
        if (((Object)((Object)SchemaType.AVRO)).equals((Object)schemaType) ? true : ((Object)((Object)SchemaType.JSON)).equals((Object)schemaType)) {
            return GenericSchemaImpl.of(schemaInfo);
        }
        throw new IllegalArgumentException(new StringBuilder(74).append("Retrieve schema instance from schema info for type '").append((Object)schemaInfo.getType()).append("' is not supported yet").toString());
    }

    public StructType pulsarSourceSchema(SchemaInfo si) {
        ListBuffer mainSchema = (ListBuffer)ListBuffer$.MODULE$.empty();
        SchemaUtils.TypeNullable typeNullable = this.si2SqlType(si);
        DataType dataType = typeNullable.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            mainSchema.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())));
        } else {
            mainSchema.$plus$eq((Object)new StructField("value", dataType, typeNullable.nullable(), StructField$.MODULE$.apply$default$4()));
        }
        mainSchema.$plus$plus$eq(this.metaDataFields());
        return StructType$.MODULE$.apply((Seq)mainSchema);
    }

    public SchemaUtils.TypeNullable si2SqlType(SchemaInfo si) {
        SchemaType schemaType = si.getType();
        if (((Object)((Object)SchemaType.NONE)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)BinaryType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.BOOLEAN)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)BooleanType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.BYTES)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)BinaryType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.DATE)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)DateType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.STRING)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)StringType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.TIMESTAMP)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)TimestampType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.INT8)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)ByteType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.DOUBLE)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)DoubleType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.FLOAT)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)FloatType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.INT32)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)IntegerType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.INT64)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)LongType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.INT16)).equals((Object)schemaType)) {
            return new SchemaUtils.TypeNullable((DataType)ShortType$.MODULE$, false);
        }
        if (((Object)((Object)SchemaType.AVRO)).equals((Object)schemaType) ? true : ((Object)((Object)SchemaType.JSON)).equals((Object)schemaType)) {
            Schema avroSchema = new Schema.Parser().parse(new String(si.getSchema(), StandardCharsets.UTF_8));
            return this.avro2SqlType(avroSchema, (Set<String>)Predef$.MODULE$.Set().empty());
        }
        throw new UnsupportedOperationException(new StringBuilder(29).append("We do not support ").append((Object)schemaType).append(" currently.").toString());
    }

    public SchemaUtils.TypeNullable avro2SqlType(Schema avroSchema, Set<String> existingRecordNames) {
        Schema.Type type;
        block22: {
            Some some;
            Buffer buffer;
            while (true) {
                if (((Object)((Object)Schema.Type.INT)).equals((Object)(type = avroSchema.getType()))) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Date) {
                        return new SchemaUtils.TypeNullable((DataType)DateType$.MODULE$, false);
                    }
                    return new SchemaUtils.TypeNullable((DataType)IntegerType$.MODULE$, false);
                }
                if (((Object)((Object)Schema.Type.STRING)).equals((Object)type)) {
                    return new SchemaUtils.TypeNullable((DataType)StringType$.MODULE$, false);
                }
                if (((Object)((Object)Schema.Type.BOOLEAN)).equals((Object)type)) {
                    return new SchemaUtils.TypeNullable((DataType)BooleanType$.MODULE$, false);
                }
                if (((Object)((Object)Schema.Type.BYTES)).equals((Object)type) ? true : ((Object)((Object)Schema.Type.FIXED)).equals((Object)type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Decimal) {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return new SchemaUtils.TypeNullable((DataType)new DecimalType(decimal.getPrecision(), decimal.getScale()), false);
                    }
                    return new SchemaUtils.TypeNullable((DataType)BinaryType$.MODULE$, false);
                }
                if (((Object)((Object)Schema.Type.DOUBLE)).equals((Object)type)) {
                    return new SchemaUtils.TypeNullable((DataType)DoubleType$.MODULE$, false);
                }
                if (((Object)((Object)Schema.Type.FLOAT)).equals((Object)type)) {
                    return new SchemaUtils.TypeNullable((DataType)FloatType$.MODULE$, false);
                }
                if (((Object)((Object)Schema.Type.LONG)).equals((Object)type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.TimestampMillis ? true : logicalType instanceof LogicalTypes.TimestampMicros) {
                        return new SchemaUtils.TypeNullable((DataType)TimestampType$.MODULE$, false);
                    }
                    return new SchemaUtils.TypeNullable((DataType)LongType$.MODULE$, false);
                }
                if (((Object)((Object)Schema.Type.ENUM)).equals((Object)type)) {
                    return new SchemaUtils.TypeNullable((DataType)StringType$.MODULE$, false);
                }
                if (((Object)((Object)Schema.Type.RECORD)).equals((Object)type)) {
                    if (existingRecordNames.contains((Object)avroSchema.getFullName())) {
                        throw new IncompatibleSchemaException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(117).append("\n            |Found recursive reference in Avro schema, which can not be processed by Spark:\n            |").append(avroSchema.toString(true)).append("\n          ").toString())).stripMargin(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    }
                    Set newRecordNames = (Set)existingRecordNames.$plus((Object)avroSchema.getFullName());
                    Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> {
                        SchemaUtils.TypeNullable typeNullable = MODULE$.avro2SqlType(f.schema(), (Set<String>)newRecordNames);
                        return new StructField(f.name(), typeNullable.dataType(), typeNullable.nullable(), StructField$.MODULE$.apply$default$4());
                    }, Buffer$.MODULE$.canBuildFrom());
                    return new SchemaUtils.TypeNullable((DataType)StructType$.MODULE$.apply((Seq)fields), false);
                }
                if (((Object)((Object)Schema.Type.ARRAY)).equals((Object)type)) {
                    SchemaUtils.TypeNullable typeNullable = this.avro2SqlType(avroSchema.getElementType(), existingRecordNames);
                    return new SchemaUtils.TypeNullable((DataType)new ArrayType(typeNullable.dataType(), typeNullable.nullable()), false);
                }
                if (((Object)((Object)Schema.Type.MAP)).equals((Object)type)) {
                    SchemaUtils.TypeNullable typeNullable = this.avro2SqlType(avroSchema.getValueType(), existingRecordNames);
                    return new SchemaUtils.TypeNullable((DataType)new MapType((DataType)StringType$.MODULE$, typeNullable.dataType(), typeNullable.nullable()), false);
                }
                if (!((Object)((Object)Schema.Type.UNION)).equals((Object)type)) break block22;
                if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$avro2SqlType$2(x$1)))) {
                    Buffer remainingUnionTypes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$avro2SqlType$3(x$2)));
                    if (remainingUnionTypes.size() == 1) {
                        SchemaUtils.TypeNullable qual$1 = this.avro2SqlType((Schema)remainingUnionTypes.head(), existingRecordNames);
                        boolean x$12 = true;
                        DataType x$22 = qual$1.copy$default$1();
                        return qual$1.copy(x$22, x$12);
                    }
                    SchemaUtils.TypeNullable qual$2 = this.avro2SqlType(Schema.createUnion((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(remainingUnionTypes).asJava()), existingRecordNames);
                    boolean x$32 = true;
                    DataType x$4 = qual$2.copy$default$1();
                    return qual$2.copy(x$4, x$32);
                }
                buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getType(), Buffer$.MODULE$.canBuildFrom());
                Some some2 = Seq$.MODULE$.unapplySeq((Seq)buffer);
                if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(1) != 0) break;
                avroSchema = avroSchema.getTypes().get(0);
            }
            Some some3 = Seq$.MODULE$.unapplySeq((Seq)buffer);
            if (!some3.isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(2) == 0) {
                Schema.Type t1 = (Schema.Type)((Object)((SeqLike)some3.get()).apply(0));
                Schema.Type t2 = (Schema.Type)((Object)((SeqLike)some3.get()).apply(1));
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2}));
                GenTraversable genTraversable2 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG}));
                if (!(genTraversable != null ? !genTraversable.equals(genTraversable2) : genTraversable2 != null)) {
                    return new SchemaUtils.TypeNullable((DataType)LongType$.MODULE$, false);
                }
            }
            if (!(some = Seq$.MODULE$.unapplySeq((Seq)buffer)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                Schema.Type t1 = (Schema.Type)((Object)((SeqLike)some.get()).apply(0));
                Schema.Type t2 = (Schema.Type)((Object)((SeqLike)some.get()).apply(1));
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2}));
                GenTraversable genTraversable3 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE}));
                if (!(genTraversable != null ? !genTraversable.equals(genTraversable3) : genTraversable3 != null)) {
                    return new SchemaUtils.TypeNullable((DataType)DoubleType$.MODULE$, false);
                }
            }
            Buffer fields = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Schema s2 = (Schema)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    SchemaUtils.TypeNullable TypeNullable2 = MODULE$.avro2SqlType(s2, existingRecordNames);
                    return new StructField(new StringBuilder(6).append("member").append(i).toString(), TypeNullable2.dataType(), true, StructField$.MODULE$.apply$default$4());
                }
                throw new MatchError((Object)tuple2);
            }, Buffer$.MODULE$.canBuildFrom());
            return new SchemaUtils.TypeNullable((DataType)StructType$.MODULE$.apply((Seq)fields), false);
        }
        throw new IncompatibleSchemaException(new StringBuilder(17).append("Unsupported type ").append((Object)type).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    public GenericSchema<GenericRecord> ASchema2PSchema(Schema aschema) {
        byte[] schema = aschema.toString().getBytes(StandardCharsets.UTF_8);
        SchemaInfoImpl si = SchemaInfoImpl.builder().name("Avro").schema(schema).type(SchemaType.AVRO).build();
        return org.apache.pulsar.client.api.Schema.generic(si);
    }

    public org.apache.pulsar.client.api.Schema<?> sqlType2PSchema(DataType catalystType, boolean nullable) {
        DataType dataType = catalystType;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return BooleanSchema.of();
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return BytesSchema.of();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return DateSchema.of();
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return org.apache.pulsar.client.api.Schema.STRING;
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return TimestampSchema.of();
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return ByteSchema.of();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return DoubleSchema.of();
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return FloatSchema.of();
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return IntSchema.of();
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return LongSchema.of();
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return ShortSchema.of();
        }
        if (dataType instanceof StructType) {
            return this.ASchema2PSchema(this.sqlType2ASchema(catalystType, this.sqlType2ASchema$default$2(), this.sqlType2ASchema$default$3(), this.sqlType2ASchema$default$4()));
        }
        throw new RuntimeException(new StringBuilder(21).append(catalystType).append(" is not supported yet").toString());
    }

    public boolean sqlType2PSchema$default$2() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public Schema sqlType2ASchema(DataType catalystType, boolean nullable, String recordName, String nameSpace) {
        block6: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block5: {
                                                        builder = SchemaBuilder.builder();
                                                        var10_6 = catalystType;
                                                        if (!BooleanType$.MODULE$.equals(var10_6)) break block5;
                                                        v0 = (Schema)builder.booleanType();
                                                        break block6;
                                                    }
                                                    if (!(ByteType$.MODULE$.equals(var10_6) != false ? true : (ShortType$.MODULE$.equals(var10_6) != false ? true : IntegerType$.MODULE$.equals(var10_6) != false))) break block7;
                                                    v0 = (Schema)builder.intType();
                                                    break block6;
                                                }
                                                if (!LongType$.MODULE$.equals(var10_6)) break block8;
                                                v0 = (Schema)builder.longType();
                                                break block6;
                                            }
                                            if (!DateType$.MODULE$.equals(var10_6)) break block9;
                                            v0 = LogicalTypes.date().addToSchema((Schema)builder.intType());
                                            break block6;
                                        }
                                        if (!TimestampType$.MODULE$.equals(var10_6)) break block10;
                                        v0 = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
                                        break block6;
                                    }
                                    if (!FloatType$.MODULE$.equals(var10_6)) break block11;
                                    v0 = (Schema)builder.floatType();
                                    break block6;
                                }
                                if (!DoubleType$.MODULE$.equals(var10_6)) break block12;
                                v0 = (Schema)builder.doubleType();
                                break block6;
                            }
                            if (!StringType$.MODULE$.equals(var10_6)) break block13;
                            v0 = (Schema)builder.stringType();
                            break block6;
                        }
                        if (!BinaryType$.MODULE$.equals(var10_6)) break block14;
                        v0 = (Schema)builder.bytesType();
                        break block6;
                    }
                    if (!(var10_6 instanceof DecimalType)) break block15;
                    var11_7 = (DecimalType)var10_6;
                    avroType = LogicalTypes.decimal(var11_7.precision(), var11_7.scale());
                    fixedSize = Decimal$.MODULE$.minBytesForPrecision()[var11_7.precision()];
                    var15_10 = nameSpace;
                    name = "".equals(var15_10) != false ? new StringBuilder(6).append(recordName).append(".fixed").toString() : new StringBuilder(7).append(nameSpace).append(".").append(recordName).append(".fixed").toString();
                    v0 = avroType.addToSchema(SchemaBuilder.fixed(name).size(fixedSize));
                    break block6;
                }
                if (!(var10_6 instanceof ArrayType)) break block16;
                var16_12 = (ArrayType)var10_6;
                et = var16_12.elementType();
                containsNull = var16_12.containsNull();
                v0 = (Schema)builder.array().items(this.sqlType2ASchema(et, containsNull, recordName, nameSpace));
                break block6;
            }
            if (!(var10_6 instanceof MapType)) ** GOTO lbl-1000
            var19_15 = (MapType)var10_6;
            var20_16 = var19_15.keyType();
            vt = var19_15.valueType();
            valueContainsNull = var19_15.valueContainsNull();
            if (StringType$.MODULE$.equals(var20_16)) {
                v0 = (Schema)builder.map().values(this.sqlType2ASchema(vt, valueContainsNull, recordName, nameSpace));
            } else if (var10_6 instanceof StructType) {
                var23_19 = (StructType)var10_6;
                v1 = nameSpace;
                var25_20 = "";
                childNameSpace = (v1 == null ? var25_20 != null : v1.equals(var25_20) == false) ? new StringBuilder(1).append(nameSpace).append(".").append(recordName).toString() : recordName;
                fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(nameSpace)).fields();
                var23_19.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$sqlType2ASchema$1(java.lang.String org.apache.pulsar.shade.org.apache.avro.SchemaBuilder$FieldAssembler org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lorg/apache/pulsar/shade/org/apache/avro/SchemaBuilder$FieldAssembler;)((String)childNameSpace, fieldsAssembler));
                v0 = (Schema)fieldsAssembler.endRecord();
            } else {
                throw new IncompatibleSchemaException(new StringBuilder(17).append("Unexpected type ").append(var10_6).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        schema = v0;
        if (nullable) {
            return Schema.createUnion(new Schema[]{schema, this.nullSchema()});
        }
        return schema;
    }

    public boolean sqlType2ASchema$default$2() {
        return false;
    }

    public String sqlType2ASchema$default$3() {
        return "topLevelRecord";
    }

    public String sqlType2ASchema$default$4() {
        return "";
    }

    public Seq<StructField> metaDataFields() {
        return this.metaDataFields;
    }

    public static final /* synthetic */ boolean $anonfun$avro2SqlType$2(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$avro2SqlType$3(Schema x$2) {
        Schema.Type type = x$2.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null);
    }

    public static final /* synthetic */ SchemaBuilder.FieldAssembler $anonfun$sqlType2ASchema$1(String childNameSpace$1, SchemaBuilder.FieldAssembler fieldsAssembler$1, StructField f) {
        Schema fieldAvroType = MODULE$.sqlType2ASchema(f.dataType(), f.nullable(), f.name(), childNameSpace$1);
        return fieldsAssembler$1.name(f.name()).type(fieldAvroType).noDefault();
    }

    private SchemaUtils$() {
        MODULE$ = this;
        this.metaDataFields = (Seq)new .colon.colon((Object)new StructField(PulsarOptions$.MODULE$.KeyAttributeName(), (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(PulsarOptions$.MODULE$.TopicAttributeName(), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(PulsarOptions$.MODULE$.MessageIdName(), (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(PulsarOptions$.MODULE$.PublishTimeName(), (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(PulsarOptions$.MODULE$.EventTimeName(), (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(PulsarOptions$.MODULE$.MessagePropertiesName(), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
    }
}

