/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.reference;

import io.swagger.v3.parser.reference.OpenAPIDereferencer;
import io.swagger.v3.parser.reference.OpenAPIDereferencer31;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DereferencersFactory {
    private static DereferencersFactory instance;
    static Logger LOGGER;
    private final List<OpenAPIDereferencer> dereferencers = new CopyOnWriteArrayList<OpenAPIDereferencer>();

    private DereferencersFactory() {
        this.dereferencers.add(new OpenAPIDereferencer31());
    }

    public static DereferencersFactory getInstance() {
        if (instance == null) {
            instance = new DereferencersFactory();
        }
        return instance;
    }

    public void addDereferencer(OpenAPIDereferencer dereferencer) {
        this.dereferencers.add(0, dereferencer);
    }

    public void removeDereferencer(OpenAPIDereferencer dereferencer) {
        this.dereferencers.remove(dereferencer);
    }

    public List<OpenAPIDereferencer> getDereferencers() {
        return Collections.unmodifiableList(this.dereferencers);
    }

    static {
        LOGGER = LoggerFactory.getLogger(DereferencersFactory.class);
        ServiceLoader<OpenAPIDereferencer> loader = ServiceLoader.load(OpenAPIDereferencer.class);
        for (OpenAPIDereferencer ext : loader) {
            if (ext == null) {
                LOGGER.error("failed to load extension {}", (Object)ext);
                continue;
            }
            instance.addDereferencer(ext);
            LOGGER.debug("adding OpenAPIDereferencer: {}", (Object)ext);
        }
    }
}

