package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Elytron;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ElytronConsumer<T extends Elytron<T>> {

	/**
	 * Configure a pre-constructed instance of Elytron resource
	 * 
	 * @parameter Instance of Elytron to configure
	 * @return nothing
	 */
	void accept(T value);

	default ElytronConsumer<T> andThen(ElytronConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}