package org.wildfly.swarm.config;

import org.wildfly.swarm.config.IO;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface IOConsumer<T extends IO<T>> {

	/**
	 * Configure a pre-constructed instance of IO resource
	 * 
	 * @parameter Instance of IO to configure
	 * @return nothing
	 */
	void accept(T value);

	default IOConsumer<T> andThen(IOConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}