package org.wildfly.swarm.config;

import org.wildfly.swarm.config.ManagementCoreService;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ManagementCoreServiceConsumer<T extends ManagementCoreService<T>> {

	/**
	 * Configure a pre-constructed instance of ManagementCoreService resource
	 * 
	 * @parameter Instance of ManagementCoreService to configure
	 * @return nothing
	 */
	void accept(T value);

	default ManagementCoreServiceConsumer<T> andThen(
			ManagementCoreServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}