package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Pojo;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PojoConsumer<T extends Pojo<T>> {

	/**
	 * Configure a pre-constructed instance of Pojo resource
	 * 
	 * @parameter Instance of Pojo to configure
	 * @return nothing
	 */
	void accept(T value);

	default PojoConsumer<T> andThen(PojoConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}