package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Singleton;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SingletonConsumer<T extends Singleton<T>> {

	/**
	 * Configure a pre-constructed instance of Singleton resource
	 * 
	 * @parameter Instance of Singleton to configure
	 * @return nothing
	 */
	void accept(T value);

	default SingletonConsumer<T> andThen(SingletonConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}