package org.wildfly.swarm.config.ee;

import org.wildfly.swarm.config.ee.ManagedThreadFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ManagedThreadFactoryConsumer<T extends ManagedThreadFactory<T>> {

	/**
	 * Configure a pre-constructed instance of ManagedThreadFactory resource
	 * 
	 * @parameter Instance of ManagedThreadFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default ManagedThreadFactoryConsumer<T> andThen(
			ManagedThreadFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}