package org.wildfly.swarm.config.ejb3.remoting_profile;

import org.wildfly.swarm.config.ejb3.remoting_profile.RemotingEJBReceiver;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RemotingEJBReceiverConsumer<T extends RemotingEJBReceiver<T>> {

	/**
	 * Configure a pre-constructed instance of RemotingEJBReceiver resource
	 * 
	 * @parameter Instance of RemotingEJBReceiver to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemotingEJBReceiverConsumer<T> andThen(
			RemotingEJBReceiverConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}