package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A principal decoder definition where the principal decoder is an aggregation
 * of other principal decoders.
 */
@Address("/subsystem=elytron/aggregate-principal-decoder=*")
@ResourceType("aggregate-principal-decoder")
public class AggregatePrincipalDecoder<T extends AggregatePrincipalDecoder<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The referenced principal decoders to aggregate.")
	private List<String> principalDecoders;

	public AggregatePrincipalDecoder(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The referenced principal decoders to aggregate.
	 */
	@ModelNodeBinding(detypedName = "principal-decoders")
	public List<String> principalDecoders() {
		return this.principalDecoders;
	}

	/**
	 * The referenced principal decoders to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T principalDecoders(java.util.List<String> value) {
		Object oldValue = this.principalDecoders;
		this.principalDecoders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principalDecoders", oldValue, value);
		return (T) this;
	}

	/**
	 * The referenced principal decoders to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T principalDecoder(String value) {
		if (this.principalDecoders == null) {
			this.principalDecoders = new java.util.ArrayList<>();
		}
		this.principalDecoders.add(value);
		return (T) this;
	}

	/**
	 * The referenced principal decoders to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T principalDecoders(String... args) {
		principalDecoders(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}