package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AggregateProviders;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregateProvidersConsumer<T extends AggregateProviders<T>> {

	/**
	 * Configure a pre-constructed instance of AggregateProviders resource
	 * 
	 * @parameter Instance of AggregateProviders to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregateProvidersConsumer<T> andThen(
			AggregateProvidersConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}