package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A role mapper definition where the role mapper is an aggregation of other
 * role mappers.
 */
@Address("/subsystem=elytron/aggregate-role-mapper=*")
@ResourceType("aggregate-role-mapper")
public class AggregateRoleMapper<T extends AggregateRoleMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The referenced role mappers to aggregate.")
	private List<String> roleMappers;

	public AggregateRoleMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The referenced role mappers to aggregate.
	 */
	@ModelNodeBinding(detypedName = "role-mappers")
	public List<String> roleMappers() {
		return this.roleMappers;
	}

	/**
	 * The referenced role mappers to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T roleMappers(java.util.List<String> value) {
		Object oldValue = this.roleMappers;
		this.roleMappers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("roleMappers", oldValue, value);
		return (T) this;
	}

	/**
	 * The referenced role mappers to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T roleMapper(String value) {
		if (this.roleMappers == null) {
			this.roleMappers = new java.util.ArrayList<>();
		}
		this.roleMappers.add(value);
		return (T) this;
	}

	/**
	 * The referenced role mappers to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T roleMappers(String... args) {
		roleMappers(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}