package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ConstantPrincipalTransformer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConstantPrincipalTransformerConsumer<T extends ConstantPrincipalTransformer<T>> {

	/**
	 * Configure a pre-constructed instance of ConstantPrincipalTransformer
	 * resource
	 * 
	 * @parameter Instance of ConstantPrincipalTransformer to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConstantPrincipalTransformerConsumer<T> andThen(
			ConstantPrincipalTransformerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}