package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A custom realm definitions can implement either the SecurityRealm interface
 * or the ModifiableSecurityRealm interface. Regardless of which interface is
 * implemented management operations will not be exposed to manage the realm.
 * However other services that depend on the realm will still be able to perform
 * a type check and cast to gain access to the modification API.
 */
@Address("/subsystem=elytron/custom-realm=*")
@ResourceType("custom-realm")
public class CustomRealm<T extends CustomRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The optional key/value configuration for the custom realm.")
	private Map configuration;
	@AttributeDocumentation("The class name of the implementation of the custom realm.")
	private String className;
	@AttributeDocumentation("The module to use to load the custom realm.")
	private String module;

	public CustomRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The optional key/value configuration for the custom realm.
	 */
	@ModelNodeBinding(detypedName = "configuration")
	public Map configuration() {
		return this.configuration;
	}

	/**
	 * The optional key/value configuration for the custom realm.
	 */
	@SuppressWarnings("unchecked")
	public T configuration(java.util.Map value) {
		Object oldValue = this.configuration;
		this.configuration = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("configuration", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional key/value configuration for the custom realm.
	 */
	@SuppressWarnings("unchecked")
	public T configuration(java.lang.String key, java.lang.Object value) {
		if (this.configuration == null) {
			this.configuration = new java.util.HashMap<>();
		}
		this.configuration.put(key, value);
		return (T) this;
	}

	/**
	 * The class name of the implementation of the custom realm.
	 */
	@ModelNodeBinding(detypedName = "class-name")
	public String className() {
		return this.className;
	}

	/**
	 * The class name of the implementation of the custom realm.
	 */
	@SuppressWarnings("unchecked")
	public T className(java.lang.String value) {
		Object oldValue = this.className;
		this.className = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("className", oldValue, value);
		return (T) this;
	}

	/**
	 * The module to use to load the custom realm.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module to use to load the custom realm.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}
}