package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomRealmMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomRealmMapperConsumer<T extends CustomRealmMapper<T>> {

	/**
	 * Configure a pre-constructed instance of CustomRealmMapper resource
	 * 
	 * @parameter Instance of CustomRealmMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomRealmMapperConsumer<T> andThen(
			CustomRealmMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}