package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.FilesystemRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface FilesystemRealmConsumer<T extends FilesystemRealm<T>> {

	/**
	 * Configure a pre-constructed instance of FilesystemRealm resource
	 * 
	 * @parameter Instance of FilesystemRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default FilesystemRealmConsumer<T> andThen(FilesystemRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}