package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * Resource containing the association of a SecurityDomain with a
 * HttpServerAuthenticationMechanismFactory.
 */
@Address("/subsystem=elytron/http-authentication-factory=*")
@ResourceType("http-authentication-factory")
public class HTTPAuthenticationFactory<T extends HTTPAuthenticationFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The HTTP mechanisms available from this configuration after all filtering has been applied.")
	private List<String> availableMechanisms;
	@AttributeDocumentation("The HttpServerAuthenticationMechanismFactory to associate with this resource")
	private String httpServerMechanismFactory;
	@AttributeDocumentation("Mechanism specific configuration")
	private List<java.util.Map> mechanismConfigurations;
	@AttributeDocumentation("The SecurityDomain to associate with this resource")
	private String securityDomain;

	public HTTPAuthenticationFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The HTTP mechanisms available from this configuration after all filtering
	 * has been applied.
	 */
	@ModelNodeBinding(detypedName = "available-mechanisms")
	public List<String> availableMechanisms() {
		return this.availableMechanisms;
	}

	/**
	 * The HTTP mechanisms available from this configuration after all filtering
	 * has been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(java.util.List<String> value) {
		Object oldValue = this.availableMechanisms;
		this.availableMechanisms = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
		return (T) this;
	}

	/**
	 * The HTTP mechanisms available from this configuration after all filtering
	 * has been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanism(String value) {
		if (this.availableMechanisms == null) {
			this.availableMechanisms = new java.util.ArrayList<>();
		}
		this.availableMechanisms.add(value);
		return (T) this;
	}

	/**
	 * The HTTP mechanisms available from this configuration after all filtering
	 * has been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(String... args) {
		availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The HttpServerAuthenticationMechanismFactory to associate with this
	 * resource
	 */
	@ModelNodeBinding(detypedName = "http-server-mechanism-factory")
	public String httpServerMechanismFactory() {
		return this.httpServerMechanismFactory;
	}

	/**
	 * The HttpServerAuthenticationMechanismFactory to associate with this
	 * resource
	 */
	@SuppressWarnings("unchecked")
	public T httpServerMechanismFactory(java.lang.String value) {
		Object oldValue = this.httpServerMechanismFactory;
		this.httpServerMechanismFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpServerMechanismFactory", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Mechanism specific configuration
	 */
	@ModelNodeBinding(detypedName = "mechanism-configurations")
	public List<Map> mechanismConfigurations() {
		return this.mechanismConfigurations;
	}

	/**
	 * Mechanism specific configuration
	 */
	@SuppressWarnings("unchecked")
	public T mechanismConfigurations(java.util.List<java.util.Map> value) {
		Object oldValue = this.mechanismConfigurations;
		this.mechanismConfigurations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mechanismConfigurations", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Mechanism specific configuration
	 */
	@SuppressWarnings("unchecked")
	public T mechanismConfiguration(java.util.Map value) {
		if (this.mechanismConfigurations == null) {
			this.mechanismConfigurations = new java.util.ArrayList<>();
		}
		this.mechanismConfigurations.add(value);
		return (T) this;
	}

	/**
	 * Mechanism specific configuration
	 */
	@SuppressWarnings("unchecked")
	public T mechanismConfigurations(java.util.Map... args) {
		mechanismConfigurations(Arrays.stream(args)
				.collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The SecurityDomain to associate with this resource
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * The SecurityDomain to associate with this resource
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String value) {
		Object oldValue = this.securityDomain;
		this.securityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomain", oldValue, value);
		return (T) this;
	}
}