package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.HTTPAuthenticationFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface HTTPAuthenticationFactoryConsumer<T extends HTTPAuthenticationFactory<T>> {

	/**
	 * Configure a pre-constructed instance of HTTPAuthenticationFactory
	 * resource
	 * 
	 * @parameter Instance of HTTPAuthenticationFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default HTTPAuthenticationFactoryConsumer<T> andThen(
			HTTPAuthenticationFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}