package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.IdentityRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface IdentityRealmConsumer<T extends IdentityRealm<T>> {

	/**
	 * Configure a pre-constructed instance of IdentityRealm resource
	 * 
	 * @parameter Instance of IdentityRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default IdentityRealmConsumer<T> andThen(IdentityRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}