package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.KeyStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface KeyStoreConsumer<T extends KeyStore<T>> {

	/**
	 * Configure a pre-constructed instance of KeyStore resource
	 * 
	 * @parameter Instance of KeyStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default KeyStoreConsumer<T> andThen(KeyStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}