package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.KeyStoreRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface KeyStoreRealmConsumer<T extends KeyStoreRealm<T>> {

	/**
	 * Configure a pre-constructed instance of KeyStoreRealm resource
	 * 
	 * @parameter Instance of KeyStoreRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default KeyStoreRealmConsumer<T> andThen(KeyStoreRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}